/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl;

import javolution.util.FastCollection;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.m3ua.impl.AsImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspState;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSM;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSMState;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.TransitionHandler;
import org.mobicents.protocols.ss7.m3ua.message.mgmt.Notify;
import org.mobicents.protocols.ss7.m3ua.parameter.Status;

public class THLocalAsActToPendRemAspDwn
implements TransitionHandler {
    private static final Logger logger = Logger.getLogger(THLocalAsActToPendRemAspDwn.class);
    private AsImpl asImpl = null;
    private FSM fsm;
    private int lbCount = 0;

    public THLocalAsActToPendRemAspDwn(AsImpl asImpl, FSM fsm) {
        this.asImpl = asImpl;
        this.fsm = fsm;
    }

    @Override
    public boolean process(FSMState state) {
        try {
            FastCollection.Record end;
            FastCollection.Record n;
            AspImpl remAsp = (AspImpl)this.fsm.getAttribute("asp");
            if (this.asImpl.getTrafficModeType().getMode() == 3) {
                return false;
            }
            if (this.asImpl.getTrafficModeType().getMode() == 2) {
                AspState aspState;
                FSM aspPeerFSM;
                this.lbCount = 0;
                n = this.asImpl.appServerProcs.head();
                end = this.asImpl.appServerProcs.tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    AspImpl remAspImpl = (AspImpl)((FastList.Node)n).getValue();
                    aspPeerFSM = remAspImpl.getPeerFSM();
                    aspState = AspState.getState(aspPeerFSM.getState().getName());
                    if (aspState != AspState.ACTIVE) continue;
                    ++this.lbCount;
                }
                if (this.lbCount >= this.asImpl.getMinAspActiveForLb()) {
                    return false;
                }
                if (this.lbCount > 0) {
                    n = this.asImpl.appServerProcs.head();
                    end = this.asImpl.appServerProcs.tail();
                    while ((n = ((FastList.Node)n).getNext()) != end) {
                        AspImpl remAspTemp = (AspImpl)((FastList.Node)n).getValue();
                        aspPeerFSM = remAspTemp.getPeerFSM();
                        aspState = AspState.getState(aspPeerFSM.getState().getName());
                        if (aspState != AspState.INACTIVE) continue;
                        Notify notify = this.createNotify(remAsp, 2, 1);
                        remAspTemp.getAspFactory().write(notify);
                    }
                    return false;
                }
            }
            n = this.asImpl.appServerProcs.head();
            end = this.asImpl.appServerProcs.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                remAsp = (AspImpl)((FastList.Node)n).getValue();
                FSM aspPeerFSM = remAsp.getPeerFSM();
                AspState aspState = AspState.getState(aspPeerFSM.getState().getName());
                if (aspState != AspState.INACTIVE) continue;
                Notify notify = this.createNotify(remAsp, 1, 4);
                remAsp.getAspFactory().write(notify);
            }
        }
        catch (Exception e) {
            logger.error(String.format("Error while translating Rem AS to PENDING. %s", this.fsm.toString()), e);
        }
        return true;
    }

    private Notify createNotify(AspImpl remAsp, int type, int info) {
        Notify msg = (Notify)this.asImpl.getMessageFactory().createMessage(0, 1);
        Status status = this.asImpl.getParameterFactory().createStatus(type, info);
        msg.setStatus(status);
        if (remAsp.getASPIdentifier() != null) {
            msg.setASPIdentifier(remAsp.getASPIdentifier());
        }
        if (this.asImpl.getRoutingContext() != null) {
            msg.setRoutingContext(this.asImpl.getRoutingContext());
        }
        return msg;
    }
}

