/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.sms;

import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.ss7.map.MAPDialogImpl;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.MAPServiceBaseImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.MAPServiceListener;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckData;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckResult;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPDialogSms;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPServiceSms;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPServiceSmsListener;
import org.mobicents.protocols.ss7.map.dialog.ServingCheckDataImpl;
import org.mobicents.protocols.ss7.map.service.sms.AlertServiceCentreRequestImpl;
import org.mobicents.protocols.ss7.map.service.sms.AlertServiceCentreResponseImpl;
import org.mobicents.protocols.ss7.map.service.sms.ForwardShortMessageRequestImpl;
import org.mobicents.protocols.ss7.map.service.sms.ForwardShortMessageResponseImpl;
import org.mobicents.protocols.ss7.map.service.sms.InformServiceCentreRequestImpl;
import org.mobicents.protocols.ss7.map.service.sms.MAPDialogSmsImpl;
import org.mobicents.protocols.ss7.map.service.sms.MoForwardShortMessageRequestImpl;
import org.mobicents.protocols.ss7.map.service.sms.MoForwardShortMessageResponseImpl;
import org.mobicents.protocols.ss7.map.service.sms.MtForwardShortMessageRequestImpl;
import org.mobicents.protocols.ss7.map.service.sms.MtForwardShortMessageResponseImpl;
import org.mobicents.protocols.ss7.map.service.sms.NoteSubscriberPresentRequestImpl;
import org.mobicents.protocols.ss7.map.service.sms.ReadyForSMRequestImpl;
import org.mobicents.protocols.ss7.map.service.sms.ReadyForSMResponseImpl;
import org.mobicents.protocols.ss7.map.service.sms.ReportSMDeliveryStatusRequestImpl;
import org.mobicents.protocols.ss7.map.service.sms.ReportSMDeliveryStatusResponseImpl;
import org.mobicents.protocols.ss7.map.service.sms.SendRoutingInfoForSMRequestImpl;
import org.mobicents.protocols.ss7.map.service.sms.SendRoutingInfoForSMResponseImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class MAPServiceSmsImpl
extends MAPServiceBaseImpl
implements MAPServiceSms {
    protected Logger loger = Logger.getLogger(MAPServiceSmsImpl.class);

    public MAPServiceSmsImpl(MAPProviderImpl mapProviderImpl) {
        super(mapProviderImpl);
    }

    public MAPDialogSms createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference) throws MAPException {
        return this.createNewDialog(appCntx, origAddress, origReference, destAddress, destReference, null);
    }

    public MAPDialogSms createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference, Long localTrId) throws MAPException {
        if (!this.isActivated()) {
            throw new MAPException("Cannot create MAPDialogSms because MAPServiceSms is not activated");
        }
        Dialog tcapDialog = this.createNewTCAPDialog(origAddress, destAddress, localTrId);
        MAPDialogSmsImpl dialog = new MAPDialogSmsImpl(appCntx, tcapDialog, this.mapProviderImpl, this, origReference, destReference);
        this.putMAPDialogIntoCollection(dialog);
        return dialog;
    }

    protected MAPDialogImpl createNewDialogIncoming(MAPApplicationContext appCntx, Dialog tcapDialog) {
        return new MAPDialogSmsImpl(appCntx, tcapDialog, this.mapProviderImpl, this, null, null);
    }

    public void addMAPServiceListener(MAPServiceSmsListener mapServiceListener) {
        super.addMAPServiceListener(mapServiceListener);
    }

    public void removeMAPServiceListener(MAPServiceSmsListener mapServiceListener) {
        super.removeMAPServiceListener(mapServiceListener);
    }

    public ServingCheckData isServingService(MAPApplicationContext dialogApplicationContext) {
        MAPApplicationContextName ctx = dialogApplicationContext.getApplicationContextName();
        int vers = dialogApplicationContext.getApplicationContextVersion().getVersion();
        switch (ctx) {
            case shortMsgAlertContext: {
                if (vers >= 1 && vers <= 2) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 2) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 2L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName(altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case shortMsgMORelayContext: 
            case shortMsgGatewayContext: {
                if (vers >= 1 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName(altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case shortMsgMTRelayContext: {
                if (vers >= 2 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName(altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case mwdMngtContext: {
                if (vers >= 1 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName(altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
        }
        return new ServingCheckDataImpl(ServingCheckResult.AC_NotServing);
    }

    public MAPApplicationContext getMAPv1ApplicationContext(int operationCode, Invoke invoke) {
        switch (operationCode) {
            case 46: {
                return MAPApplicationContext.getInstance(MAPApplicationContextName.shortMsgMORelayContext, MAPApplicationContextVersion.version1);
            }
            case 49: {
                return MAPApplicationContext.getInstance(MAPApplicationContextName.shortMsgAlertContext, MAPApplicationContextVersion.version1);
            }
            case 45: {
                return MAPApplicationContext.getInstance(MAPApplicationContextName.shortMsgGatewayContext, MAPApplicationContextVersion.version1);
            }
            case 47: {
                return MAPApplicationContext.getInstance(MAPApplicationContextName.shortMsgGatewayContext, MAPApplicationContextVersion.version1);
            }
            case 48: {
                return MAPApplicationContext.getInstance(MAPApplicationContextName.mwdMngtContext, MAPApplicationContextVersion.version1);
            }
        }
        return null;
    }

    public void processComponent(ComponentType compType, OperationCode oc, Parameter parameter, MAPDialog mapDialog, Long invokeId, Long linkedId, Invoke linkedInvoke) throws MAPParsingComponentException {
        if (compType != ComponentType.Invoke || this.mapProviderImpl.isCongested()) {
            // empty if block
        }
        MAPDialogSmsImpl mapDialogSmsImpl = (MAPDialogSmsImpl)mapDialog;
        Long ocValue = oc.getLocalOperationCode();
        if (ocValue == null) {
            new MAPParsingComponentException("", MAPParsingComponentExceptionReason.UnrecognizedOperation);
        }
        MAPApplicationContextName acn = mapDialog.getApplicationContext().getApplicationContextName();
        int vers = mapDialog.getApplicationContext().getApplicationContextVersion().getVersion();
        int ocValueInt = (int)ocValue.longValue();
        switch (ocValueInt) {
            case 46: {
                if (acn != MAPApplicationContextName.shortMsgMORelayContext && (acn != MAPApplicationContextName.shortMsgMTRelayContext || vers != 2)) break;
                if (vers >= 3) {
                    if (compType == ComponentType.Invoke) {
                        this.moForwardShortMessageRequest(parameter, mapDialogSmsImpl, invokeId);
                        break;
                    }
                    this.moForwardShortMessageResponse(parameter, mapDialogSmsImpl, invokeId, compType == ComponentType.ReturnResult);
                    break;
                }
                if (compType == ComponentType.Invoke) {
                    this.forwardShortMessageRequest(parameter, mapDialogSmsImpl, invokeId);
                    break;
                }
                this.forwardShortMessageResponse(parameter, mapDialogSmsImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 44: {
                if (acn != MAPApplicationContextName.shortMsgMTRelayContext || vers < 3) break;
                if (compType == ComponentType.Invoke) {
                    this.mtForwardShortMessageRequest(parameter, mapDialogSmsImpl, invokeId);
                    break;
                }
                this.mtForwardShortMessageResponse(parameter, mapDialogSmsImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 45: {
                if (acn != MAPApplicationContextName.shortMsgGatewayContext) break;
                if (compType == ComponentType.Invoke) {
                    this.sendRoutingInfoForSMRequest(parameter, mapDialogSmsImpl, invokeId);
                    break;
                }
                this.sendRoutingInfoForSMResponse(parameter, mapDialogSmsImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 47: {
                if (acn != MAPApplicationContextName.shortMsgGatewayContext) break;
                if (compType == ComponentType.Invoke) {
                    this.reportSMDeliveryStatusRequest(parameter, mapDialogSmsImpl, invokeId);
                    break;
                }
                this.reportSMDeliveryStatusResponse(parameter, mapDialogSmsImpl, invokeId, vers, compType == ComponentType.ReturnResult);
                break;
            }
            case 63: {
                if (acn != MAPApplicationContextName.shortMsgGatewayContext || vers < 2 || compType != ComponentType.Invoke) break;
                this.informServiceCentreRequest(parameter, mapDialogSmsImpl, invokeId);
                break;
            }
            case 64: {
                if (acn != MAPApplicationContextName.shortMsgAlertContext || vers < 2) break;
                if (compType == ComponentType.Invoke) {
                    this.alertServiceCentreRequest(parameter, mapDialogSmsImpl, invokeId, ocValueInt);
                    break;
                }
                this.alertServiceCentreResponse(parameter, mapDialogSmsImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 49: {
                if (acn != MAPApplicationContextName.shortMsgAlertContext || vers != 1 || compType != ComponentType.Invoke) break;
                this.alertServiceCentreRequest(parameter, mapDialogSmsImpl, invokeId, ocValueInt);
                break;
            }
            case 66: {
                if (acn != MAPApplicationContextName.mwdMngtContext || vers < 2) break;
                if (compType == ComponentType.Invoke) {
                    this.readyForSMRequest(parameter, mapDialogSmsImpl, invokeId, ocValueInt);
                    break;
                }
                this.readyForSMResponse(parameter, mapDialogSmsImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 48: {
                if (acn != MAPApplicationContextName.mwdMngtContext || vers != 1 || compType != ComponentType.Invoke) break;
                this.noteSubscriberPresentRequest(parameter, mapDialogSmsImpl, invokeId, ocValueInt);
                break;
            }
            default: {
                throw new MAPParsingComponentException("MAPServiceSms: unknown incoming operation code: " + ocValueInt, MAPParsingComponentExceptionReason.UnrecognizedOperation);
            }
        }
    }

    private void forwardShortMessageRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding forwardShortMessageRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding moForwardShortMessageRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ForwardShortMessageRequestImpl ind = new ForwardShortMessageRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onForwardShortMessageRequest(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing forwardShortMessageRequest: " + e.getMessage(), e);
            }
        }
    }

    private void forwardShortMessageResponse(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        ForwardShortMessageResponseImpl ind = new ForwardShortMessageResponseImpl();
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onForwardShortMessageResponse(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing forwardShortMessageResponse: " + e.getMessage(), e);
            }
        }
    }

    private void moForwardShortMessageRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding moForwardShortMessageRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding moForwardShortMessageRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        MoForwardShortMessageRequestImpl ind = new MoForwardShortMessageRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onMoForwardShortMessageRequest(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing onMoForwardShortMessageIndication: " + e.getMessage(), e);
            }
        }
    }

    private void moForwardShortMessageResponse(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        MoForwardShortMessageResponseImpl ind = new MoForwardShortMessageResponseImpl();
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding moForwardShortMessageResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onMoForwardShortMessageResponse(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing onMoForwardShortMessageRespIndication: " + e.getMessage(), e);
            }
        }
    }

    private void mtForwardShortMessageRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding mtForwardShortMessageRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding mtForwardShortMessageRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        MtForwardShortMessageRequestImpl ind = new MtForwardShortMessageRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onMtForwardShortMessageRequest(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing onMtForwardShortMessageIndication: " + e.getMessage(), e);
            }
        }
    }

    private void mtForwardShortMessageResponse(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        MtForwardShortMessageResponseImpl ind = new MtForwardShortMessageResponseImpl();
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding mtForwardShortMessageResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onMtForwardShortMessageResponse(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing onMtForwardShortMessageRespIndication: " + e.getMessage(), e);
            }
        }
    }

    private void sendRoutingInfoForSMRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForSMRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForSMRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        SendRoutingInfoForSMRequestImpl ind = new SendRoutingInfoForSMRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onSendRoutingInfoForSMRequest(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing onSendRoutingInfoForSMIndication: " + e.getMessage(), e);
            }
        }
    }

    private void sendRoutingInfoForSMResponse(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        SendRoutingInfoForSMResponseImpl ind = new SendRoutingInfoForSMResponseImpl();
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForSMResponse: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForSMResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onSendRoutingInfoForSMResponse(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing onSendRoutingInfoForSMRespIndication: " + e.getMessage(), e);
            }
        }
    }

    private void reportSMDeliveryStatusRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForSMRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding sendRoutingInfoForSMRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ReportSMDeliveryStatusRequestImpl ind = new ReportSMDeliveryStatusRequestImpl(mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion());
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onReportSMDeliveryStatusRequest(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing onReportSMDeliveryStatusIndication: " + e.getMessage(), e);
            }
        }
    }

    private void reportSMDeliveryStatusResponse(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId, long mapProtocolVersion, boolean returnResultNotLast) throws MAPParsingComponentException {
        ReportSMDeliveryStatusResponseImpl ind = new ReportSMDeliveryStatusResponseImpl(mapProtocolVersion);
        if (parameter != null) {
            if (mapProtocolVersion >= 3L ? parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive() : parameter.getTag() != 4 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding reportSMDeliveryStatusResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onReportSMDeliveryStatusResponse(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing onReportSMDeliveryStatusRespIndication: " + e.getMessage(), e);
            }
        }
    }

    private void informServiceCentreRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding informServiceCentreRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding informServiceCentreRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        InformServiceCentreRequestImpl ind = new InformServiceCentreRequestImpl();
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onInformServiceCentreRequest(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing onInformServiceCentreIndication: " + e.getMessage(), e);
            }
        }
    }

    private void alertServiceCentreRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId, int operationCode) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding alertServiceCentreRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding alertServiceCentreRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        AlertServiceCentreRequestImpl ind = new AlertServiceCentreRequestImpl(operationCode);
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onAlertServiceCentreRequest(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing onAlertServiceCentreIndication: " + e.getMessage(), e);
            }
        }
    }

    private void alertServiceCentreResponse(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        AlertServiceCentreResponseImpl ind = new AlertServiceCentreResponseImpl();
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onAlertServiceCentreResponse(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing onAlertServiceCentreRespIndication: " + e.getMessage(), e);
            }
        }
    }

    private void readyForSMRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId, int operationCode) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding readyForSMRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding readyForSMRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        ReadyForSMRequestImpl ind = new ReadyForSMRequestImpl();
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onReadyForSMRequest(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing onReadyForSMRequest: " + e.getMessage(), e);
            }
        }
    }

    private void readyForSMResponse(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        ReadyForSMResponseImpl ind = new ReadyForSMResponseImpl();
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding readyForSMResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onReadyForSMResponse(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing onReadyForSMResponse: " + e.getMessage(), e);
            }
        }
    }

    private void noteSubscriberPresentRequest(Parameter parameter, MAPDialogSmsImpl mapDialogImpl, Long invokeId, int operationCode) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding noteSubscriberPresentRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 4 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding noteSubscriberPresentRequest: Bad tag or tagClass or parameter is not primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        NoteSubscriberPresentRequestImpl ind = new NoteSubscriberPresentRequestImpl();
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSmsListener)serLis).onNoteSubscriberPresentRequest(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing onNoteSubscriberPresentRequest: " + e.getMessage(), e);
            }
        }
    }
}

