/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.ss7.congestion;

import javolution.util.FastCollection;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.restcomm.ss7.congestion.CongestionListener;
import org.restcomm.ss7.congestion.CongestionMonitor;
import org.restcomm.ss7.congestion.CongestionTicket;
import org.restcomm.ss7.congestion.CongestionTicketImpl;

public abstract class BaseCongestionMonitor
implements CongestionMonitor {
    protected static final Logger logger = Logger.getLogger(BaseCongestionMonitor.class);
    private final FastList<CongestionListener> listeners = new FastList();

    @Override
    public void addCongestionListener(CongestionListener listener) {
        this.listeners.add(listener);
        CongestionTicket[] ticketsList = this.getCongestionTicketsList();
        if (ticketsList != null) {
            for (CongestionTicket ticket : ticketsList) {
                listener.onCongestionStart(ticket);
            }
        }
    }

    @Override
    public void removeCongestionListener(CongestionListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract CongestionTicketImpl generateTicket();

    protected void applyNewValue(int currentAlarmLevel, double newValue, double[] alarmThreshold, double[] clearThreshold, boolean reverse) {
        CongestionListener listener;
        FastCollection.Record end;
        FastCollection.Record n;
        CongestionTicketImpl ticket;
        int i1;
        int sign = 1;
        if (!reverse) {
            sign = -1;
        }
        int newAlarmLevel = currentAlarmLevel;
        for (i1 = currentAlarmLevel - 1; i1 >= 0; --i1) {
            if (!(newValue * (double)sign <= clearThreshold[i1] * (double)sign)) continue;
            newAlarmLevel = i1;
        }
        for (i1 = currentAlarmLevel; i1 < 3; ++i1) {
            if (!(newValue * (double)sign >= alarmThreshold[i1] * (double)sign)) continue;
            newAlarmLevel = i1 + 1;
        }
        if (newAlarmLevel != currentAlarmLevel) {
            this.setAlarmLevel(newAlarmLevel);
        }
        if (newAlarmLevel < currentAlarmLevel) {
            String msg = "CongestionMonitor-" + this.getSource() + ": congestion decrease down to level " + newAlarmLevel + ", couter value=" + newValue + ", description=" + this.getAlarmDescription();
            if (newAlarmLevel == 3) {
                logger.error(msg);
            } else {
                logger.warn(msg);
            }
            ticket = this.generateTicket();
            n = this.listeners.head();
            end = this.listeners.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                listener = (CongestionListener)((FastList.Node)n).getValue();
                listener.onCongestionFinish(ticket);
            }
        }
        if (newAlarmLevel > currentAlarmLevel) {
            String msg = "CongestionMonitor-" + this.getSource() + ": congestion increase up to level " + newAlarmLevel + ", couter value=" + newValue + ", description=" + this.getAlarmDescription();
            if (currentAlarmLevel == 3) {
                logger.error(msg);
            } else {
                logger.warn(msg);
            }
            ticket = this.generateTicket();
            n = this.listeners.head();
            end = this.listeners.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                listener = (CongestionListener)((FastList.Node)n).getValue();
                listener.onCongestionStart(ticket);
            }
        }
    }

    protected abstract int getAlarmLevel();

    protected abstract void setAlarmLevel(int var1);

    protected abstract String getAlarmDescription();

    @Override
    public CongestionTicket[] getCongestionTicketsList() {
        if (this.getAlarmLevel() > 0) {
            return new CongestionTicket[]{this.generateTicket()};
        }
        return null;
    }
}

