/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.router;

import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.restcomm.protocols.ss7.sccp.Mtp3Destination;

public class Mtp3DestinationImpl
implements XMLSerializable,
Mtp3Destination {
    private static final String FIRST_DPC = "firstDpc";
    private static final String LAST_DPC = "lastDpc";
    private static final String FIRST_SLS = "firstSls";
    private static final String LAST_SLS = "lastSls";
    private static final String SLS_MASK = "slsMask";
    private int firstDpc;
    private int lastDpc;
    private int firstSls;
    private int lastSls;
    private int slsMask;
    protected static final XMLFormat<Mtp3DestinationImpl> XML = new XMLFormat<Mtp3DestinationImpl>(Mtp3DestinationImpl.class){

        @Override
        public void write(Mtp3DestinationImpl dest, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(Mtp3DestinationImpl.FIRST_DPC, dest.firstDpc);
            xml.setAttribute(Mtp3DestinationImpl.LAST_DPC, dest.lastDpc);
            xml.setAttribute(Mtp3DestinationImpl.FIRST_SLS, dest.firstSls);
            xml.setAttribute(Mtp3DestinationImpl.LAST_SLS, dest.lastSls);
            xml.setAttribute(Mtp3DestinationImpl.SLS_MASK, dest.slsMask);
        }

        @Override
        public void read(XMLFormat.InputElement xml, Mtp3DestinationImpl dest) throws XMLStreamException {
            dest.firstDpc = xml.getAttribute(Mtp3DestinationImpl.FIRST_DPC).toInt();
            dest.lastDpc = xml.getAttribute(Mtp3DestinationImpl.LAST_DPC).toInt();
            dest.firstSls = xml.getAttribute(Mtp3DestinationImpl.FIRST_SLS).toInt();
            dest.lastSls = xml.getAttribute(Mtp3DestinationImpl.LAST_SLS).toInt();
            dest.slsMask = xml.getAttribute(Mtp3DestinationImpl.SLS_MASK).toInt();
        }
    };

    public Mtp3DestinationImpl() {
    }

    public Mtp3DestinationImpl(int firstDpc, int lastDpc, int firstSls, int lastSls, int slsMask) {
        this.firstDpc = firstDpc;
        this.lastDpc = lastDpc;
        this.firstSls = firstSls;
        this.lastSls = lastSls;
        this.slsMask = slsMask;
    }

    @Override
    public int getFirstDpc() {
        return this.firstDpc;
    }

    @Override
    public int getLastDpc() {
        return this.lastDpc;
    }

    @Override
    public int getFirstSls() {
        return this.firstSls;
    }

    @Override
    public int getLastSls() {
        return this.lastSls;
    }

    @Override
    public int getSlsMask() {
        return this.slsMask;
    }

    @Override
    public boolean match(int dpc, int sls) {
        return dpc >= this.firstDpc && dpc <= this.lastDpc && (sls &= this.slsMask) >= this.firstSls && sls <= this.lastSls;
    }

    @Override
    public boolean match(int dpc) {
        return dpc >= this.firstDpc && dpc <= this.lastDpc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("firstDpc=").append(this.firstDpc).append(", lastDpc=").append(this.lastDpc).append(", firstSls=").append(this.firstSls).append(", lastSls=").append(this.lastSls).append(", slsMask=").append(this.slsMask);
        return sb.toString();
    }
}

