/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.SuperChargerInfo;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class SuperChargerInfoImpl
implements SuperChargerInfo,
MAPAsnPrimitive {
    public static final int _ID_sendSubscriberData = 0;
    public static final int _ID_subscriberDataStored = 1;
    public static final String _PrimitiveName = "SuperChargerInfo";
    private Boolean sendSubscriberData;
    private byte[] subscriberDataStored;

    public SuperChargerInfoImpl() {
    }

    public SuperChargerInfoImpl(Boolean sendSubscriberData) {
        this.sendSubscriberData = sendSubscriberData;
    }

    public SuperChargerInfoImpl(byte[] subscriberDataStored) {
        this.subscriberDataStored = subscriberDataStored;
    }

    @Override
    public Boolean getSendSubscriberData() {
        return this.sendSubscriberData;
    }

    @Override
    public byte[] getSubscriberDataStored() {
        return this.subscriberDataStored;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.sendSubscriberData != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getTagClass() {
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SuperChargerInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SuperChargerInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SuperChargerInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SuperChargerInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.sendSubscriberData = null;
        this.subscriberDataStored = null;
        if (ansIS.getTagClass() != 2 || !ansIS.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding SuperChargerInfo: bad tag class or is not primitive: TagClass=" + ansIS.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (ansIS.getTag()) {
            case 0: {
                try {
                    ansIS.readNullData(length);
                    this.sendSubscriberData = Boolean.TRUE;
                    break;
                }
                catch (AsnException e) {
                    throw new MAPParsingComponentException("AsnException when decoding SuperChargerInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                catch (IOException e) {
                    throw new MAPParsingComponentException("IOException when decoding SuperChargerInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
                }
            }
            case 1: {
                this.subscriberDataStored = ansIS.readOctetStringData(length);
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error while SuperChargerInfo: bad tag: " + ansIS.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 2, this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SuperChargerInfo: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.sendSubscriberData != null) {
            asnOs.writeNullData();
        } else {
            asnOs.writeOctetStringData(this.subscriberDataStored);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SuperChargerInfo [");
        if (this.sendSubscriberData != null) {
            sb.append("sendSubscriberData, ");
        }
        if (this.subscriberDataStored != null) {
            sb.append("subscriberDataStored=[");
            sb.append(this.printDataArr(this.subscriberDataStored));
            sb.append("], ");
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }
}

