/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map;

import org.restcomm.protocols.ss7.map.MAPProviderImpl;
import org.restcomm.protocols.ss7.map.MAPStackConfigurationManagement;
import org.restcomm.protocols.ss7.map.api.MAPProvider;
import org.restcomm.protocols.ss7.map.api.MAPStack;
import org.restcomm.protocols.ss7.sccp.SccpProvider;
import org.restcomm.protocols.ss7.tcap.TCAPStackImpl;
import org.restcomm.protocols.ss7.tcap.api.TCAPProvider;
import org.restcomm.protocols.ss7.tcap.api.TCAPStack;

public class MAPStackImpl
implements MAPStack {
    protected TCAPStack tcapStack = null;
    protected MAPProviderImpl mapProvider = null;
    private State state = State.IDLE;
    private final String name;
    private final MAPStackConfigurationManagement mapCfg;
    private String persistDir = null;

    public MAPStackImpl(String name, SccpProvider sccpPprovider, int ssn) {
        this.name = name;
        this.tcapStack = new TCAPStackImpl(name, sccpPprovider, ssn);
        TCAPProvider tcapProvider = this.tcapStack.getProvider();
        this.mapProvider = new MAPProviderImpl(name, tcapProvider);
        this.state = State.CONFIGURED;
        this.mapCfg = MAPStackConfigurationManagement.getInstance();
        this.mapCfg.setConfigFileName(this.name);
    }

    public MAPStackImpl(String name, TCAPProvider tcapProvider) {
        this.name = name;
        this.mapProvider = new MAPProviderImpl(name, tcapProvider);
        this.tcapStack = tcapProvider.getStack();
        this.state = State.CONFIGURED;
        this.mapCfg = MAPStackConfigurationManagement.getInstance();
        this.mapCfg.setConfigFileName(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MAPProvider getMAPProvider() {
        return this.mapProvider;
    }

    @Override
    public void start() throws Exception {
        this.mapCfg.setPersistDir(this.persistDir);
        this.mapCfg.load();
        if (this.state != State.CONFIGURED) {
            throw new IllegalStateException("Stack has not been configured or is already running!");
        }
        if (this.tcapStack != null) {
            this.tcapStack.start();
        }
        this.mapProvider.start();
        this.state = State.RUNNING;
    }

    @Override
    public void stop() {
        if (this.state != State.RUNNING) {
            throw new IllegalStateException("Stack is not running!");
        }
        this.mapProvider.stop();
        if (this.tcapStack != null) {
            this.tcapStack.stop();
        }
        this.state = State.CONFIGURED;
        this.mapCfg.store();
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    @Override
    public TCAPStack getTCAPStack() {
        return this.tcapStack;
    }

    private static enum State {
        IDLE,
        CONFIGURED,
        RUNNING;

    }
}

