/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl.parameter;

import org.restcomm.protocols.ss7.m3ua.impl.parameter.ParameterImpl;
import org.restcomm.protocols.ss7.m3ua.parameter.ASPIdentifier;

public class ASPIdentifierImpl
extends ParameterImpl
implements ASPIdentifier {
    private long aspID = 0L;
    private byte[] value;

    protected ASPIdentifierImpl(byte[] value) {
        this.tag = (short)17;
        this.aspID = 0L;
        this.aspID |= (long)(value[0] & 0xFF);
        this.aspID <<= 8;
        this.aspID |= (long)(value[1] & 0xFF);
        this.aspID <<= 8;
        this.aspID |= (long)(value[2] & 0xFF);
        this.aspID <<= 8;
        this.aspID |= (long)(value[3] & 0xFF);
        this.value = value;
    }

    protected ASPIdentifierImpl(long id) {
        this.tag = (short)17;
        this.aspID = id;
        this.encode();
    }

    private void encode() {
        this.value = new byte[4];
        this.value[0] = (byte)(this.aspID >> 24);
        this.value[1] = (byte)(this.aspID >> 16);
        this.value[2] = (byte)(this.aspID >> 8);
        this.value[3] = (byte)this.aspID;
    }

    @Override
    public long getAspId() {
        return this.aspID;
    }

    @Override
    protected byte[] getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("ASPIdentifier id=%d", this.aspID);
    }
}

