/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.scheduler;

import java.util.concurrent.atomic.AtomicBoolean;
import org.mobicents.protocols.ss7.scheduler.Scheduler;

public abstract class Task
implements Runnable {
    protected Scheduler scheduler;
    private volatile boolean isActive = true;
    private volatile boolean isHeartbeat = true;
    private final Object LOCK = new Object();
    private AtomicBoolean inQueue0 = new AtomicBoolean(false);
    private AtomicBoolean inQueue1 = new AtomicBoolean(false);

    public Task(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public void storedInQueue0() {
        this.inQueue0.set(true);
    }

    public void storedInQueue1() {
        this.inQueue1.set(true);
    }

    public void removeFromQueue0() {
        this.inQueue0.set(false);
    }

    public void removeFromQueue1() {
        this.inQueue1.set(false);
    }

    public Boolean isInQueue0() {
        return this.inQueue0.get();
    }

    public Boolean isInQueue1() {
        return this.inQueue1.get();
    }

    public abstract int getQueueNumber();

    public abstract long perform();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.LOCK;
        synchronized (object) {
            this.isActive = false;
        }
    }

    public void run() {
        if (this.isActive) {
            try {
                this.perform();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.scheduler.notifyCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(Boolean isHeartbeat) {
        Object object = this.LOCK;
        synchronized (object) {
            this.isActive = true;
            this.isHeartbeat = isHeartbeat;
        }
    }

    public boolean isActive() {
        return this.isActive;
    }
}

