/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.BurstList;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.AudibleIndicator;
import org.mobicents.protocols.ss7.cap.primitives.BurstListImpl;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class AudibleIndicatorImpl
implements AudibleIndicator,
CAPAsnPrimitive {
    private static final String TONE = "tone";
    private static final String BURST_LIST = "burstList";
    public static final int _ID_burstList = 1;
    public static final String _PrimitiveName = "AudibleIndicator";
    private Boolean tone;
    private BurstList burstList;
    protected static final XMLFormat<AudibleIndicatorImpl> AUDIBLE_INDICATOR_XML = new XMLFormat<AudibleIndicatorImpl>(AudibleIndicatorImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, AudibleIndicatorImpl audibleIndicator) throws XMLStreamException {
            audibleIndicator.tone = xml.get(AudibleIndicatorImpl.TONE, Boolean.class);
            audibleIndicator.burstList = xml.get(AudibleIndicatorImpl.BURST_LIST, BurstListImpl.class);
        }

        @Override
        public void write(AudibleIndicatorImpl audibleIndicator, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (audibleIndicator.tone != null) {
                xml.add(audibleIndicator.tone, AudibleIndicatorImpl.TONE, Boolean.class);
            }
            if (audibleIndicator.burstList != null) {
                xml.add((BurstListImpl)audibleIndicator.burstList, AudibleIndicatorImpl.BURST_LIST, BurstListImpl.class);
            }
        }
    };

    public AudibleIndicatorImpl() {
    }

    public AudibleIndicatorImpl(Boolean tone) {
        this.tone = tone;
    }

    public AudibleIndicatorImpl(BurstList burstList) {
        this.burstList = burstList;
    }

    public Boolean getTone() {
        return this.tone;
    }

    public BurstList getBurstList() {
        return this.burstList;
    }

    public int getTag() throws CAPException {
        if (this.tone != null) {
            return 1;
        }
        if (this.burstList != null) {
            return 1;
        }
        throw new CAPException("Error while encoding AudibleIndicator: no choice is specified");
    }

    public int getTagClass() {
        if (this.tone != null) {
            return 0;
        }
        return 2;
    }

    public boolean getIsPrimitive() {
        return this.tone != null;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding AudibleIndicator: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding AudibleIndicator: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding AudibleIndicator: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding AudibleIndicator: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding AudibleIndicator: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding AudibleIndicator: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws CAPParsingComponentException, MAPParsingComponentException, IOException, AsnException {
        block8: {
            block9: {
                int tag;
                block7: {
                    this.tone = null;
                    this.burstList = null;
                    tag = ais.getTag();
                    if (ais.getTagClass() != 0) break block7;
                    switch (tag) {
                        case 1: {
                            if (!ais.isTagPrimitive()) {
                                throw new CAPParsingComponentException("Error while decoding AudibleIndicator- tone: parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.tone = ais.readBooleanData(length);
                            break block8;
                        }
                        default: {
                            throw new CAPParsingComponentException("Error while decoding AudibleIndicator: bad choice tag", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                    }
                }
                if (ais.getTagClass() != 2) break block9;
                switch (tag) {
                    case 1: {
                        this.burstList = new BurstListImpl();
                        ((BurstListImpl)this.burstList).decodeData(ais, length);
                        break block8;
                    }
                    default: {
                        throw new CAPParsingComponentException("Error while decoding AudibleIndicator: bad choice tag", CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
            }
            throw new CAPParsingComponentException("Error while decoding AudibleIndicator: bad choice tagClass", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding AudibleIndicator: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        try {
            if (this.tone != null) {
                asnOs.writeBooleanData(this.tone);
                return;
            }
            if (this.burstList != null) {
                ((BurstListImpl)this.burstList).encodeData(asnOs);
                return;
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding AudibleIndicator: " + e.getMessage(), e);
        }
        throw new CAPException("Error while encoding AudibleIndicator: no choice is specified");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.tone != null) {
            sb.append("tone=[");
            sb.append(this.tone);
            sb.append("]");
        } else if (this.burstList != null) {
            sb.append("burstList=[");
            sb.append(this.burstList);
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }
}

