/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.EsiGprs;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.EsiGprs.DisconnectSpecificInformation;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.InitiatingEntity;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class DisconnectSpecificInformationImpl
extends SequenceBase
implements DisconnectSpecificInformation {
    public static final int _ID_initiatingEntity = 0;
    public static final int _ID_routeingAreaUpdate = 1;
    public static final int _ID_DisconnectSpecificInformation = 3;
    private InitiatingEntity initiatingEntity;
    private boolean routeingAreaUpdate;

    public DisconnectSpecificInformationImpl() {
        super("DisconnectSpecificInformation");
    }

    public DisconnectSpecificInformationImpl(InitiatingEntity initiatingEntity, boolean routeingAreaUpdate) {
        super("DisconnectSpecificInformation");
        this.initiatingEntity = initiatingEntity;
        this.routeingAreaUpdate = routeingAreaUpdate;
    }

    public InitiatingEntity getInitiatingEntity() {
        return this.initiatingEntity;
    }

    public boolean getRouteingAreaUpdate() {
        return this.routeingAreaUpdate;
    }

    public int getTag() throws CAPException {
        return 16;
    }

    public int getTagClass() {
        return 2;
    }

    protected void _decode(AsnInputStream asnIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        this.initiatingEntity = null;
        this.routeingAreaUpdate = false;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".initiatingEntity: Parameter is not  primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.initiatingEntity = InitiatingEntity.getInstance(i1);
                        break;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".routeingAreaUpdate: Parameter is not  primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.routeingAreaUpdate = true;
                        ais.readNull();
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        try {
            if (this.initiatingEntity != null) {
                asnOs.writeInteger(2, 0, this.initiatingEntity.getCode());
            }
            if (this.routeingAreaUpdate) {
                asnOs.writeNull(2, 1);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.initiatingEntity != null) {
            sb.append("initiatingEntity=");
            sb.append(this.initiatingEntity.toString());
            sb.append(", ");
        }
        if (this.routeingAreaUpdate) {
            sb.append("routeingAreaUpdate ");
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

