/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mobicents.protocols.ss7.cap.CAPDialogImpl;
import org.mobicents.protocols.ss7.cap.CAPProviderImpl;
import org.mobicents.protocols.ss7.cap.api.CAPApplicationContext;
import org.mobicents.protocols.ss7.cap.api.CAPDialog;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPProvider;
import org.mobicents.protocols.ss7.cap.api.CAPServiceBase;
import org.mobicents.protocols.ss7.cap.api.CAPServiceListener;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessage;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.TCAPException;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;

public abstract class CAPServiceBaseImpl
implements CAPServiceBase {
    protected Boolean _isActivated = false;
    protected List<CAPServiceListener> serviceListeners = new CopyOnWriteArrayList<CAPServiceListener>();
    protected CAPProviderImpl capProviderImpl = null;

    protected CAPServiceBaseImpl(CAPProviderImpl capProviderImpl) {
        this.capProviderImpl = capProviderImpl;
    }

    public CAPProvider getCAPProvider() {
        return this.capProviderImpl;
    }

    protected abstract CAPDialogImpl createNewDialogIncoming(CAPApplicationContext var1, Dialog var2);

    protected Dialog createNewTCAPDialog(SccpAddress origAddress, SccpAddress destAddress, Long localTrId) throws CAPException {
        try {
            return this.capProviderImpl.getTCAPProvider().getNewDialog(origAddress, destAddress, localTrId);
        }
        catch (TCAPException e) {
            throw new CAPException(e.getMessage(), e);
        }
    }

    public abstract void processComponent(ComponentType var1, OperationCode var2, Parameter var3, CAPDialog var4, Long var5, Long var6, Invoke var7) throws CAPParsingComponentException;

    public long[] getLinkedOperationList(long operCode) {
        return null;
    }

    protected void putCAPDialogIntoCollection(CAPDialogImpl dialog) {
        this.capProviderImpl.addDialog(dialog);
    }

    protected void addCAPServiceListener(CAPServiceListener capServiceListener) {
        this.serviceListeners.add(capServiceListener);
    }

    protected void removeCAPServiceListener(CAPServiceListener capServiceListener) {
        this.serviceListeners.remove(capServiceListener);
    }

    public boolean checkInvokeTimeOut(CAPDialog dialog, Invoke invoke) {
        return false;
    }

    public boolean isActivated() {
        return this._isActivated;
    }

    public void acivate() {
        this._isActivated = true;
    }

    public void deactivate() {
        this._isActivated = false;
    }

    protected void deliverErrorComponent(CAPDialog capDialog, Long invokeId, CAPErrorMessage capErrorMessage) {
        for (CAPServiceListener serLis : this.serviceListeners) {
            serLis.onErrorComponent(capDialog, invokeId, capErrorMessage);
        }
    }

    protected void deliverRejectComponent(CAPDialog capDialog, Long invokeId, Problem problem, boolean isLocalOriginated) {
        for (CAPServiceListener serLis : this.serviceListeners) {
            serLis.onRejectComponent(capDialog, invokeId, problem, isLocalOriginated);
        }
    }

    protected void deliverInvokeTimeout(CAPDialog capDialog, Invoke invoke) {
        for (CAPServiceListener serLis : this.serviceListeners) {
            serLis.onInvokeTimeout(capDialog, invoke.getInvokeId());
        }
    }
}

