/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.oam.common.m3ua;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javolution.util.FastCollection;
import javolution.util.FastList;
import org.mobicents.protocols.ss7.m3ua.As;
import org.mobicents.protocols.ss7.m3ua.Asp;
import org.mobicents.protocols.ss7.m3ua.AspFactory;
import org.mobicents.protocols.ss7.m3ua.ExchangeType;
import org.mobicents.protocols.ss7.m3ua.Functionality;
import org.mobicents.protocols.ss7.m3ua.IPSPType;
import org.mobicents.protocols.ss7.m3ua.M3UAManagement;
import org.mobicents.protocols.ss7.m3ua.M3UAManagementEventListener;
import org.mobicents.protocols.ss7.m3ua.RouteAs;
import org.mobicents.protocols.ss7.m3ua.State;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.ParameterFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.parameter.NetworkAppearance;
import org.mobicents.protocols.ss7.m3ua.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.m3ua.parameter.RoutingContext;
import org.mobicents.protocols.ss7.m3ua.parameter.TrafficModeType;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmListener;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmListenerCollection;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmMediator;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmMessage;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmMessageImpl;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmSeverity;
import org.mobicents.protocols.ss7.oam.common.alarm.CurrentAlarmList;
import org.mobicents.protocols.ss7.oam.common.alarm.CurrentAlarmListImpl;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanHost;
import org.mobicents.protocols.ss7.oam.common.jmxss7.Ss7Layer;
import org.mobicents.protocols.ss7.oam.common.m3ua.AsJmx;
import org.mobicents.protocols.ss7.oam.common.m3ua.AspFactoryJmx;
import org.mobicents.protocols.ss7.oam.common.m3ua.AspJmx;
import org.mobicents.protocols.ss7.oam.common.m3ua.M3UAManagementType;
import org.mobicents.protocols.ss7.oam.common.m3ua.M3uaManagementJmxMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M3uaManagementJmx
implements M3uaManagementJmxMBean,
M3UAManagementEventListener,
AlarmMediator {
    private final MBeanHost ss7Management;
    private final M3UAManagement wrappedM3UAManagement;
    protected FastList<As> appServers = new FastList();
    protected FastList<AspFactory> aspfactories = new FastList();
    private AlarmListenerCollection alc = new AlarmListenerCollection();
    private static final ParameterFactory parameterFactory = new ParameterFactoryImpl();

    public M3uaManagementJmx(MBeanHost ss7Management, M3UAManagement wrappedM3UAManagement) {
        this.ss7Management = ss7Management;
        this.wrappedM3UAManagement = wrappedM3UAManagement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        FastList<Object> fastList = this.appServers;
        synchronized (fastList) {
            this.appServers.clear();
        }
        fastList = this.aspfactories;
        synchronized (fastList) {
            this.aspfactories.clear();
        }
        this.ss7Management.registerMBean(Ss7Layer.M3UA, M3UAManagementType.MANAGEMENT, this.getName(), this);
        this.wrappedM3UAManagement.addM3UAManagementEventListener(this);
        List<AspFactory> aspFactories = this.wrappedM3UAManagement.getAspfactories();
        for (AspFactory aspFactory : aspFactories) {
            this.addAspFactoryToManagement(aspFactory);
        }
        List<As> appServers = this.wrappedM3UAManagement.getAppServers();
        for (As as : appServers) {
            this.addAsToManagement(as);
            List<Asp> asps = as.getAspList();
            for (Asp asp : asps) {
                this.onAspAssignedToAs(as, asp);
            }
        }
    }

    @Override
    public void stop() {
        this.removeAllResourcesFromManagement();
    }

    @Override
    public String getName() {
        return this.wrappedM3UAManagement.getName();
    }

    @Override
    public String getPersistDir() {
        return this.wrappedM3UAManagement.getPersistDir();
    }

    @Override
    public void setPersistDir(String persistDir) {
        this.wrappedM3UAManagement.setPersistDir(persistDir);
    }

    @Override
    public int getMaxSequenceNumber() {
        return this.wrappedM3UAManagement.getMaxSequenceNumber();
    }

    @Override
    public void setMaxSequenceNumber(int maxSequenceNumber) throws Exception {
        this.wrappedM3UAManagement.setMaxSequenceNumber(maxSequenceNumber);
    }

    @Override
    public int getMaxAsForRoute() {
        return this.wrappedM3UAManagement.getMaxAsForRoute();
    }

    @Override
    public void setMaxAsForRoute(int maxAsForRoute) throws Exception {
        this.wrappedM3UAManagement.setMaxAsForRoute(maxAsForRoute);
    }

    @Override
    public List<As> getAppServers() {
        return this.appServers.unmodifiable();
    }

    @Override
    public List<AspFactory> getAspfactories() {
        return this.aspfactories.unmodifiable();
    }

    @Override
    public As createAs(String asName, Functionality functionality, ExchangeType exchangeType, IPSPType ipspType, RoutingContext rc, TrafficModeType trafficMode, int minAspActive, NetworkAppearance na) throws Exception {
        As as = this.wrappedM3UAManagement.createAs(asName, functionality, exchangeType, ipspType, rc, trafficMode, minAspActive, na);
        return null;
    }

    @Override
    public As createAppServer(String asName, Functionality functionality, ExchangeType exchangeType, IPSPType ipspType, String rc, int trafficMode, int minAspActive, String na) throws Exception {
        NetworkAppearance networkAppearance = null;
        if (na != null && !na.trim().equals("")) {
            long naLong = Long.parseLong(na);
            networkAppearance = parameterFactory.createNetworkAppearance(naLong);
        }
        RoutingContext routingContext = null;
        if (rc != null && !rc.trim().equals("")) {
            long rcLong = Long.parseLong(rc.trim());
            routingContext = parameterFactory.createRoutingContext(new long[]{rcLong});
        }
        TrafficModeType trafficModeType = parameterFactory.createTrafficModeType(trafficMode);
        As as = this.wrappedM3UAManagement.createAs(asName, functionality, exchangeType, ipspType, routingContext, trafficModeType, minAspActive, networkAppearance);
        return null;
    }

    @Override
    public As destroyAs(String asName) throws Exception {
        this.wrappedM3UAManagement.destroyAs(asName);
        return null;
    }

    @Override
    public AspFactory createAspFactory(String aspName, String associationName) throws Exception {
        this.wrappedM3UAManagement.createAspFactory(aspName, associationName);
        return null;
    }

    @Override
    public AspFactory createAspFactory(String aspName, String associationName, boolean isHeartBeatEnabled) throws Exception {
        this.wrappedM3UAManagement.createAspFactory(aspName, associationName, isHeartBeatEnabled);
        return null;
    }

    @Override
    public int getHeartbeatTime() {
        return this.wrappedM3UAManagement.getHeartbeatTime();
    }

    @Override
    public void setHeartbeatTime(int timeBetweenHeartbeat) throws Exception {
        this.wrappedM3UAManagement.setHeartbeatTime(timeBetweenHeartbeat);
    }

    @Override
    public boolean isStarted() {
        return this.wrappedM3UAManagement.isStarted();
    }

    @Override
    public AspFactory createAspFactory(String aspName, String associationName, long aspid, boolean isHeartBeatEnabled) throws Exception {
        this.wrappedM3UAManagement.createAspFactory(aspName, associationName, aspid, isHeartBeatEnabled);
        return null;
    }

    @Override
    public AspFactory destroyAspFactory(String aspName) throws Exception {
        this.wrappedM3UAManagement.destroyAspFactory(aspName);
        return null;
    }

    @Override
    public Asp assignAspToAs(String asName, String aspName) throws Exception {
        this.wrappedM3UAManagement.assignAspToAs(asName, aspName);
        return null;
    }

    @Override
    public Asp unassignAspFromAs(String asName, String aspName) throws Exception {
        this.wrappedM3UAManagement.unassignAspFromAs(asName, aspName);
        return null;
    }

    @Override
    public void startAsp(String aspName) throws Exception {
        this.wrappedM3UAManagement.startAsp(aspName);
    }

    @Override
    public void stopAsp(String aspName) throws Exception {
        this.wrappedM3UAManagement.stopAsp(aspName);
    }

    @Override
    @Deprecated
    public void addRoute(int dpc, int opc, int si, String asName) throws Exception {
        this.wrappedM3UAManagement.addRoute(dpc, opc, si, asName);
    }

    @Override
    public void addRoute(int dpc, int opc, int si, String asName, int trafficModeType) throws Exception {
        this.wrappedM3UAManagement.addRoute(dpc, opc, si, asName, trafficModeType);
    }

    @Override
    public void removeRoute(int dpc, int opc, int si, String asName) throws Exception {
        this.wrappedM3UAManagement.removeRoute(dpc, opc, si, asName);
    }

    @Override
    public void removeAllResourses() throws Exception {
    }

    @Override
    public void onAsCreated(As as) {
        this.addAsToManagement(as);
        if (!as.getState().getName().equals("ACTIVE")) {
            AlarmMessage alm = this.generateAsAlarm(as, false);
            this.alc.onAlarm(alm);
        }
    }

    @Override
    public void onAsDestroyed(As as) {
        this.removeAsFromManagement(as);
        if (!as.getState().getName().equals("ACTIVE")) {
            AlarmMessage alm = this.generateAsAlarm(as, true);
            this.alc.onAlarm(alm);
        }
    }

    @Override
    public void onAsDown(As as, State oldState) {
        AlarmMessage alm = this.generateAsAlarm(as, false);
        this.alc.onAlarm(alm);
    }

    @Override
    public void onAsInactive(As as, State oldState) {
        AlarmMessage alm = this.generateAsAlarm(as, false);
        this.alc.onAlarm(alm);
    }

    @Override
    public void onAsActive(As as, State oldState) {
        AlarmMessage alm = this.generateAsAlarm(as, true);
        this.alc.onAlarm(alm);
    }

    @Override
    public void onAsPending(As as, State oldState) {
        AlarmMessage alm = this.generateAsAlarm(as, false);
        this.alc.onAlarm(alm);
    }

    @Override
    public void onAspInactive(Asp asp, State oldState) {
        AlarmMessage alm = this.generateAspAlarm(asp, false);
        this.alc.onAlarm(alm);
    }

    @Override
    public void onAspActive(Asp asp, State oldState) {
        AlarmMessage alm = this.generateAspAlarm(asp, true);
        this.alc.onAlarm(alm);
    }

    @Override
    public void onAspDown(Asp asp, State oldState) {
        AlarmMessage alm = this.generateAspAlarm(asp, false);
        this.alc.onAlarm(alm);
    }

    public void onStarted() {
        CurrentAlarmListImpl all = this.checkAllAlarms(false);
        for (AlarmMessage alm : all.getCurrentAlarmList()) {
            this.alc.onAlarm(alm);
        }
        AlarmMessage alm2 = this.generateStoppedAlarm(true);
        this.alc.onAlarm(alm2);
    }

    public void onStopped() {
        CurrentAlarmListImpl all = this.checkAllAlarms(true);
        for (AlarmMessage alm : all.getCurrentAlarmList()) {
            this.alc.onAlarm(alm);
        }
        AlarmMessage alm2 = this.generateStoppedAlarm(false);
        this.alc.onAlarm(alm2);
    }

    @Override
    public void onAspFactoryCreated(AspFactory aspFactory) {
        this.addAspFactoryToManagement(aspFactory);
    }

    @Override
    public void onAspFactoryDestroyed(AspFactory aspFactory) {
        this.removeAspFactoryFromManagement(aspFactory);
    }

    @Override
    public void onAspFactoryStarted(AspFactory aspFact) {
        List<Asp> lstAsp = aspFact.getAspList();
        for (Asp asp : lstAsp) {
            if (asp.getState().getName().equals("ACTIVE")) continue;
            AlarmMessage alm = this.generateAspAlarm(asp, false);
            this.alc.onAlarm(alm);
        }
    }

    @Override
    public void onAspFactoryStopped(AspFactory aspFact) {
        List<Asp> lstAsp = aspFact.getAspList();
        for (Asp asp : lstAsp) {
            if (asp.getState().getName().equals("ACTIVE")) continue;
            AlarmMessage alm = this.generateAspAlarm(asp, true);
            this.alc.onAlarm(alm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAspAssignedToAs(As as, Asp asp) {
        FastCollection.Record end;
        FastCollection.Record n;
        AsJmx asJmx = null;
        AspFactoryJmx aspFactoryJmx = null;
        FastList<Object> fastList = this.appServers;
        synchronized (fastList) {
            n = this.appServers.head();
            end = this.appServers.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                As asTemp = (As)((FastList.Node)n).getValue();
                if (!asTemp.getName().equals(as.getName())) continue;
                asJmx = (AsJmx)asTemp;
                break;
            }
        }
        fastList = this.aspfactories;
        synchronized (fastList) {
            n = this.aspfactories.head();
            end = this.aspfactories.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                AspFactory aspFactoryJmxTmp = (AspFactory)((FastList.Node)n).getValue();
                if (!aspFactoryJmxTmp.getName().equals(asp.getName())) continue;
                aspFactoryJmx = (AspFactoryJmx)aspFactoryJmxTmp;
                break;
            }
        }
        this.addAspToManagement(asJmx, aspFactoryJmx, asp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAspUnassignedFromAs(As as, Asp asp) {
        FastCollection.Record end;
        FastCollection.Record n;
        AsJmx asJmx = null;
        AspFactoryJmx aspFactoryJmx = null;
        FastList<Object> fastList = this.appServers;
        synchronized (fastList) {
            n = this.appServers.head();
            end = this.appServers.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                As asTemp = (As)((FastList.Node)n).getValue();
                if (!asTemp.getName().equals(as.getName())) continue;
                asJmx = (AsJmx)asTemp;
                break;
            }
        }
        fastList = this.aspfactories;
        synchronized (fastList) {
            n = this.aspfactories.head();
            end = this.aspfactories.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                AspFactory aspFactoryJmxTmp = (AspFactory)((FastList.Node)n).getValue();
                if (!aspFactoryJmxTmp.getName().equals(asp.getName())) continue;
                aspFactoryJmx = (AspFactoryJmx)aspFactoryJmxTmp;
                break;
            }
        }
        this.removeAspFromManagement(asJmx, aspFactoryJmx, asp);
    }

    @Override
    public void onRemoveAllResources() {
        this.removeAllResourcesFromManagement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAsToManagement(As as) {
        FastList<As> fastList = this.appServers;
        synchronized (fastList) {
            AsJmx asJmx = new AsJmx(as);
            this.ss7Management.registerMBean(Ss7Layer.M3UA, M3UAManagementType.AS, as.getName(), asJmx);
            this.appServers.add(asJmx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAsFromManagement(As as) {
        FastList<As> fastList = this.appServers;
        synchronized (fastList) {
            As asJmx = null;
            FastCollection.Record n = this.appServers.head();
            FastCollection.Record end = this.appServers.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                As asTemp = (As)((FastList.Node)n).getValue();
                if (!asTemp.getName().equals(as.getName())) continue;
                asJmx = asTemp;
                break;
            }
            this.appServers.remove(asJmx);
            this.ss7Management.unregisterMBean(Ss7Layer.M3UA, M3UAManagementType.AS, as.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAspFactoryToManagement(AspFactory aspFactory) {
        FastList<AspFactory> fastList = this.aspfactories;
        synchronized (fastList) {
            AspFactoryJmx aspFactoryJmx = new AspFactoryJmx(aspFactory);
            this.ss7Management.registerMBean(Ss7Layer.M3UA, M3UAManagementType.ASPFACTORY, aspFactory.getName(), aspFactoryJmx);
            this.aspfactories.add(aspFactoryJmx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAspFactoryFromManagement(AspFactory aspFactory) {
        FastList<AspFactory> fastList = this.aspfactories;
        synchronized (fastList) {
            AspFactory aspFactoryJmx = null;
            FastCollection.Record n = this.aspfactories.head();
            FastCollection.Record end = this.aspfactories.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                AspFactory aspFactoryJmxTmp = (AspFactory)((FastList.Node)n).getValue();
                if (!aspFactoryJmxTmp.getName().equals(aspFactory.getName())) continue;
                aspFactoryJmx = aspFactoryJmxTmp;
                break;
            }
            this.aspfactories.remove(aspFactoryJmx);
            this.ss7Management.unregisterMBean(Ss7Layer.M3UA, M3UAManagementType.ASPFACTORY, aspFactoryJmx.getName());
        }
    }

    private void addAspToManagement(AsJmx asJmx, AspFactoryJmx aspFactoryJmx, Asp asp) {
        AspJmx aspJmx = new AspJmx(asp, asJmx, aspFactoryJmx);
        asJmx.addAppServerProcess(aspJmx);
        aspFactoryJmx.addAppServerProcess(aspJmx);
        this.ss7Management.registerMBean(Ss7Layer.M3UA, M3UAManagementType.ASP, aspJmx.getName(), aspJmx);
    }

    private void removeAspFromManagement(AsJmx asJmx, AspFactoryJmx aspFactoryJmx, Asp asp) {
        AspJmx aspJmx = asJmx.removeAppServerProcess(asp.getName());
        aspFactoryJmx.removeAppServerProcess(aspJmx);
        this.ss7Management.unregisterMBean(Ss7Layer.M3UA, M3UAManagementType.ASP, asp.getName());
    }

    private void removeAllResourcesFromManagement() {
        List<As> appServers = this.wrappedM3UAManagement.getAppServers();
        for (As as : appServers) {
            List<Asp> asps = as.getAspList();
            for (Asp asp : asps) {
                this.onAspUnassignedFromAs(as, asp);
            }
            this.removeAsFromManagement(as);
        }
        List<AspFactory> aspFactories = this.wrappedM3UAManagement.getAspfactories();
        for (AspFactory aspFactory : aspFactories) {
            this.removeAspFactoryFromManagement(aspFactory);
        }
    }

    @Override
    public String getAlarmProviderObjectPath() {
        return this.alc.getAlarmProviderObjectPath();
    }

    @Override
    public CurrentAlarmList getCurrentAlarmList() {
        CurrentAlarmListImpl all = new CurrentAlarmListImpl();
        all = this.checkAllAlarms(false);
        return all;
    }

    @Override
    public void registerAlarmListener(AlarmListener al) {
        this.alc.registerAlarmListener(al);
    }

    @Override
    public void setAlarmProviderObjectPath(String value) {
        this.alc.setAlarmProviderObjectPath(value);
    }

    @Override
    public void unregisterAlarmListener(AlarmListener al) {
        this.alc.unregisterAlarmListener(al);
    }

    private AlarmMessage generateAsAlarm(As ass, boolean isCleared) {
        AlarmMessageImpl alm = new AlarmMessageImpl();
        alm.setIsCleared(isCleared);
        alm.setAlarmSeverity(AlarmSeverity.major);
        alm.setAlarmSource("SS7_M3UA_" + this.getName());
        alm.setObjectName("AS: " + ass.getName());
        alm.setObjectPath("/M3ua:" + this.getName() + "/Ass/As:" + ass.getName());
        alm.setProblemName("AS state is not active");
        alm.setTimeAlarm(Calendar.getInstance());
        return alm;
    }

    private AlarmMessage generateAspAlarm(Asp asp, boolean isCleared) {
        AlarmMessageImpl alm = new AlarmMessageImpl();
        alm.setIsCleared(isCleared);
        alm.setAlarmSeverity(AlarmSeverity.minor);
        alm.setAlarmSource("SS7_M3UA_" + this.getName());
        alm.setObjectName("ASP: " + asp.getName());
        alm.setObjectPath("/M3ua:" + this.getName() + "/Asps/Asp:" + asp.getName());
        alm.setProblemName("ASP state is not active");
        alm.setTimeAlarm(Calendar.getInstance());
        return alm;
    }

    private AlarmMessage generateStoppedAlarm(boolean isCleared) {
        AlarmMessageImpl alm = new AlarmMessageImpl();
        alm.setIsCleared(isCleared);
        alm.setAlarmSeverity(AlarmSeverity.critical);
        alm.setAlarmSource("SS7_M3UA_" + this.getName());
        alm.setObjectName("M3UA");
        alm.setObjectPath("/M3ua:" + this.getName());
        alm.setProblemName("M3UA server is stopped");
        alm.setTimeAlarm(Calendar.getInstance());
        return alm;
    }

    private CurrentAlarmListImpl checkAllAlarms(boolean isCleared) {
        CurrentAlarmListImpl all = new CurrentAlarmListImpl();
        List<AspFactory> lstAspFact = this.wrappedM3UAManagement.getAspfactories();
        for (AspFactory aspFact : lstAspFact) {
            if (!aspFact.getStatus()) continue;
            List<Asp> lstAsp = aspFact.getAspList();
            for (Asp asp : lstAsp) {
                if (asp.getState().getName().equals("ACTIVE")) continue;
                AlarmMessage alm = this.generateAspAlarm(asp, isCleared);
                all.addAlarm(alm);
            }
        }
        List<As> lstAs = this.wrappedM3UAManagement.getAppServers();
        for (As as : lstAs) {
            if (as.getState().getName().equals("ACTIVE")) continue;
            AlarmMessage alm = this.generateAsAlarm(as, isCleared);
            all.addAlarm(alm);
        }
        return all;
    }

    @Override
    public void onServiceStarted() {
    }

    @Override
    public void onServiceStopped() {
    }

    @Override
    public void addM3UAManagementEventListener(M3UAManagementEventListener arg0) {
    }

    @Override
    public void removeM3UAManagementEventListener(M3UAManagementEventListener arg0) {
    }

    @Override
    public Map<String, RouteAs> getRoute() {
        return this.wrappedM3UAManagement.getRoute();
    }
}

