/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractAsnEncodable;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractRemoteOperation;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.OperationCodeImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ParameterImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.Invoke;
import org.mobicents.protocols.ss7.isup.message.parameter.OperationCode;
import org.mobicents.protocols.ss7.isup.message.parameter.OperationCodeType;
import org.mobicents.protocols.ss7.isup.message.parameter.Parameter;
import org.mobicents.protocols.ss7.isup.message.parameter.RemoteOperation;

public class InvokeImpl
extends AbstractRemoteOperation
implements Invoke {
    private Long invokeId;
    private Long linkedId;
    private OperationCode operationCode;
    private Parameter parameter;

    public InvokeImpl() {
        super(RemoteOperation.OperationType.Invoke);
    }

    public void setInvokeId(Long i) {
        if (i == null || i < -128L || i > 127L) {
            throw new IllegalArgumentException("Invoke ID our of range: <-128,127>: " + i);
        }
        this.invokeId = i;
    }

    public Long getInvokeId() {
        return this.invokeId;
    }

    public void setLinkedId(Long i) {
        if (i == null || i < -128L || i > 127L) {
            throw new IllegalArgumentException("Invoke ID our of range: <-128,127>: " + i);
        }
        this.linkedId = i;
    }

    public Long getLinkedId() {
        return this.linkedId;
    }

    public void setOperationCode(OperationCode i) {
        this.operationCode = i;
    }

    public OperationCode getOperationCode() {
        return this.operationCode;
    }

    public void setParameter(Parameter p) {
        this.parameter = p;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void decode(AsnInputStream ais) throws ParameterException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag != 2 || localAis.getTagClass() != 0) {
                throw new ParameterException("Error while decoding Invoke: bad tag or tag class for InvokeID: tag=" + tag + ", tagClass = " + localAis.getTagClass());
            }
            this.invokeId = localAis.readInteger();
            tag = localAis.readTag();
            if (tag == 0 && localAis.getTagClass() == 2) {
                this.linkedId = localAis.readInteger();
                tag = localAis.readTag();
            }
            if (tag != 6 && tag != 2 || localAis.getTagClass() != 0) {
                throw new ParameterException("Error while decoding Invoke: bad tag or tag class for operationCode: tag=" + tag + ", tagClass = " + localAis.getTagClass());
            }
            this.operationCode = new OperationCodeImpl();
            ((OperationCodeImpl)this.operationCode).setOperationType(6 == tag ? OperationCodeType.Global : OperationCodeType.Local);
            ((AbstractAsnEncodable)((Object)this.operationCode)).decode(localAis);
            if (localAis.available() == 0) {
                return;
            }
            tag = localAis.readTag();
            this.parameter = new ParameterImpl(tag, localAis, true);
        }
        catch (IOException e) {
            throw new ParameterException("IOException while decoding Invoke: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParameterException("AsnException while decoding Invoke: " + e.getMessage(), e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParameterException {
        if (this.invokeId == null) {
            throw new ParameterException("Invoke ID not set!");
        }
        if (this.operationCode == null) {
            throw new ParameterException("Operation Code not set!");
        }
        try {
            aos.writeTag(2, false, 1);
            int pos = aos.StartContentDefiniteLength();
            aos.writeInteger(this.invokeId);
            if (this.linkedId != null) {
                aos.writeInteger(2, 0, this.linkedId);
            }
            ((AbstractAsnEncodable)((Object)this.operationCode)).encode(aos);
            if (this.parameter != null) {
                ((AbstractAsnEncodable)((Object)this.parameter)).encode(aos);
            }
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new ParameterException("IOException while encoding Invoke: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParameterException("AsnException while encoding Invoke: " + e.getMessage(), e);
        }
    }
}

