/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import org.apache.commons.mail.DataSourceResolver;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.EmailUtils;
import org.apache.commons.mail.HtmlEmail;

public class ImageHtmlEmail
extends HtmlEmail {
    public static final String REGEX_IMG_SRC = "(<[Ii][Mm][Gg]\\s*[^>]*?\\s+[Ss][Rr][Cc]\\s*=\\s*[\"'])([^\"']+?)([\"'])";
    public static final String REGEX_SCRIPT_SRC = "(<[Ss][Cc][Rr][Ii][Pp][Tt]\\s*.*?\\s+[Ss][Rr][Cc]\\s*=\\s*[\"'])([^\"']+?)([\"'])";
    private static final Pattern IMG_PATTERN = Pattern.compile("(<[Ii][Mm][Gg]\\s*[^>]*?\\s+[Ss][Rr][Cc]\\s*=\\s*[\"'])([^\"']+?)([\"'])");
    private static final Pattern SCRIPT_PATTERN = Pattern.compile("(<[Ss][Cc][Rr][Ii][Pp][Tt]\\s*.*?\\s+[Ss][Rr][Cc]\\s*=\\s*[\"'])([^\"']+?)([\"'])");
    private DataSourceResolver dataSourceResolver;

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }

    public void buildMimeMessage() throws EmailException {
        try {
            String temp = this.replacePattern(this.html, IMG_PATTERN);
            temp = this.replacePattern(temp, SCRIPT_PATTERN);
            this.setHtmlMsg(temp);
            super.buildMimeMessage();
        }
        catch (IOException e) {
            throw new EmailException("Building the MimeMessage failed", e);
        }
    }

    private String replacePattern(String htmlMessage, Pattern pattern) throws EmailException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        HashMap<String, String> cidCache = new HashMap<String, String>();
        HashMap<String, DataSource> dataSourceCache = new HashMap<String, DataSource>();
        Matcher matcher = pattern.matcher(htmlMessage);
        while (matcher.find()) {
            String cid;
            DataSource dataSource;
            String resourceLocation = matcher.group(2);
            if (dataSourceCache.get(resourceLocation) == null) {
                dataSource = this.getDataSourceResolver().resolve(resourceLocation);
                if (dataSource != null) {
                    dataSourceCache.put(resourceLocation, dataSource);
                }
            } else {
                dataSource = (DataSource)dataSourceCache.get(resourceLocation);
            }
            if (dataSource == null) continue;
            String name = dataSource.getName();
            if (EmailUtils.isEmpty(name)) {
                name = resourceLocation;
            }
            if ((cid = (String)cidCache.get(name)) == null) {
                cid = this.embed(dataSource, dataSource.getName());
                cidCache.put(name, cid);
            }
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(matcher.group(1) + "cid:" + cid + matcher.group(3)));
        }
        matcher.appendTail(stringBuffer);
        cidCache.clear();
        dataSourceCache.clear();
        return stringBuffer.toString();
    }
}

