/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.parameter.AbstractParameter;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.parameter.Importance;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;

public class ImportanceImpl
extends AbstractParameter
implements Importance {
    private byte importance = 0;

    public ImportanceImpl() {
    }

    public ImportanceImpl(byte importance) {
        this.importance = (byte)(importance & 7);
    }

    @Override
    public int getValue() {
        return this.importance;
    }

    @Override
    public void decode(byte[] buffer, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        this.importance = (byte)(buffer[0] & 7);
    }

    @Override
    public byte[] encode(boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        return new byte[]{(byte)(this.importance & 7)};
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            if (in.read() != 1) {
                throw new ParseException();
            }
            this.importance = (byte)(in.read() & 7);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void encode(OutputStream os, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            os.write(1);
            os.write(this.importance & 7);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.importance;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportanceImpl other = (ImportanceImpl)obj;
        return this.importance == other.importance;
    }
}

