/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.restcomm.protocols.ss7.indicator.GlobalTitleIndicator;
import org.restcomm.protocols.ss7.indicator.NumberingPlan;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.parameter.AbstractGlobalTitle;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ParameterFactoryImpl;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.parameter.EncodingScheme;
import org.restcomm.protocols.ss7.sccp.parameter.GlobalTitle0011;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;

public class GlobalTitle0011Impl
extends AbstractGlobalTitle
implements GlobalTitle0011 {
    private NumberingPlan numberingPlan;
    private int translationType;
    protected static final XMLFormat<GlobalTitle0011Impl> XML = new XMLFormat<GlobalTitle0011Impl>(GlobalTitle0011Impl.class){
        private final ParameterFactoryImpl factory = new ParameterFactoryImpl();

        @Override
        public void write(GlobalTitle0011Impl ai, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("tt", ai.translationType);
            xml.setAttribute("es", ai.encodingScheme.getSchemeCode());
            xml.setAttribute("np", ai.numberingPlan.getValue());
            xml.setAttribute("digits", ai.digits);
        }

        @Override
        public void read(XMLFormat.InputElement xml, GlobalTitle0011Impl ai) throws XMLStreamException {
            try {
                ai.translationType = xml.getAttribute("tt").toInt();
                byte esCode = (byte)xml.getAttribute("es").toInt();
                ai.encodingScheme = this.factory.createEncodingScheme(esCode);
                ai.numberingPlan = NumberingPlan.valueOf(xml.getAttribute("np").toInt());
                ai.digits = xml.getAttribute("digits").toString();
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    };

    public GlobalTitle0011Impl() {
    }

    public GlobalTitle0011Impl(String digits, int translationType, EncodingScheme encodingScheme, NumberingPlan numberingPlan) {
        if (digits == null) {
            throw new IllegalArgumentException();
        }
        if (encodingScheme == null) {
            throw new IllegalArgumentException();
        }
        if (numberingPlan == null) {
            throw new IllegalArgumentException();
        }
        this.encodingScheme = encodingScheme;
        this.numberingPlan = numberingPlan;
        this.translationType = translationType;
        this.digits = digits;
    }

    @Override
    public GlobalTitleIndicator getGlobalTitleIndicator() {
        return GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME;
    }

    @Override
    public EncodingScheme getEncodingScheme() {
        return this.encodingScheme;
    }

    @Override
    public NumberingPlan getNumberingPlan() {
        return this.numberingPlan;
    }

    @Override
    public int getTranslationType() {
        return this.translationType;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            this.translationType = in.read() & 0xFF;
            int b = in.read() & 0xFF;
            this.encodingScheme = factory.createEncodingScheme((byte)(b & 0xF));
            this.numberingPlan = NumberingPlan.valueOf((b & 0xF0) >> 4);
            this.digits = this.encodingScheme.decode(in);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void encode(OutputStream out, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            if (this.digits == null) {
                throw new IllegalStateException();
            }
            out.write(this.translationType);
            out.write(this.numberingPlan.getValue() << 4 | this.encodingScheme.getSchemeCode());
            this.encodingScheme.encode(this.digits, out);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.numberingPlan == null ? 0 : this.numberingPlan.hashCode());
        result = 31 * result + this.translationType;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalTitle0011Impl other = (GlobalTitle0011Impl)obj;
        if (this.numberingPlan != other.numberingPlan) {
            return false;
        }
        return this.translationType == other.translationType;
    }

    public String toString() {
        return "GlobalTitle0011Impl [digits=" + this.digits + ",numberingPlan=" + (Object)((Object)this.numberingPlan) + ", translationType=" + this.translationType + ", encodingScheme=" + this.encodingScheme + "]";
    }
}

