/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl;

import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.restcomm.protocols.ss7.sccp.RemoteSignalingPointCode;
import org.restcomm.protocols.ss7.sccp.impl.RemoteSignalingPointCodeExt;
import org.restcomm.protocols.ss7.sccp.impl.Ss7ExtSccpDetailedInterface;

public class RemoteSignalingPointCodeImpl
implements XMLSerializable,
RemoteSignalingPointCode {
    private static final String REMOTE_SPC = "remoteSpc";
    private static final String REMOTE_SPC_FLAG = "remoteSpcFlag";
    private static final String MASK = "mask";
    private int remoteSpc;
    private int remoteSpcFlag;
    private int mask;
    protected boolean remoteSpcProhibited;
    protected boolean remoteSccpProhibited;
    protected int rl;
    protected int rsl;
    private RemoteSignalingPointCodeExt remoteSignalingPointCodeExt;
    protected static final XMLFormat<RemoteSignalingPointCodeImpl> XML = new XMLFormat<RemoteSignalingPointCodeImpl>(RemoteSignalingPointCodeImpl.class){

        @Override
        public void write(RemoteSignalingPointCodeImpl ai, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(RemoteSignalingPointCodeImpl.REMOTE_SPC, ai.remoteSpc);
            xml.setAttribute(RemoteSignalingPointCodeImpl.REMOTE_SPC_FLAG, ai.remoteSpcFlag);
            xml.setAttribute(RemoteSignalingPointCodeImpl.MASK, ai.mask);
        }

        @Override
        public void read(XMLFormat.InputElement xml, RemoteSignalingPointCodeImpl ai) throws XMLStreamException {
            ai.remoteSpc = xml.getAttribute(RemoteSignalingPointCodeImpl.REMOTE_SPC).toInt();
            ai.remoteSpcFlag = xml.getAttribute(RemoteSignalingPointCodeImpl.REMOTE_SPC_FLAG).toInt();
            ai.mask = xml.getAttribute(RemoteSignalingPointCodeImpl.MASK).toInt();
        }
    };

    public RemoteSignalingPointCodeImpl() {
    }

    public RemoteSignalingPointCodeImpl(int remoteSpc, int remoteSpcFlag, int mask, boolean isProhibited) {
        this.remoteSpc = remoteSpc;
        this.remoteSpcFlag = remoteSpcFlag;
        this.mask = mask;
        this.remoteSccpProhibited = isProhibited;
        this.remoteSpcProhibited = isProhibited;
    }

    public void createRemoteSignalingPointCodeExt(Ss7ExtSccpDetailedInterface ss7ExtSccpDetailedInterface) {
        this.remoteSignalingPointCodeExt = ss7ExtSccpDetailedInterface.createRemoteSignalingPointCodeExt(this);
    }

    public RemoteSignalingPointCodeExt getRemoteSignalingPointCodeExt() {
        return this.remoteSignalingPointCodeExt;
    }

    @Override
    public int getRemoteSpc() {
        return this.remoteSpc;
    }

    @Override
    public int getRemoteSpcFlag() {
        return this.remoteSpcFlag;
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    @Override
    public boolean isRemoteSpcProhibited() {
        return this.remoteSpcProhibited;
    }

    @Override
    public boolean isRemoteSccpProhibited() {
        return this.remoteSccpProhibited;
    }

    protected void setProhibitedState(boolean remoteSpcProhibited, boolean remoteSccpProhibited) {
        this.remoteSpcProhibited = remoteSpcProhibited;
        this.remoteSccpProhibited = remoteSccpProhibited;
    }

    protected void setRemoteSpcProhibited(boolean remoteSpcProhibited) {
        this.remoteSpcProhibited = remoteSpcProhibited;
    }

    protected void setRemoteSccpProhibited(boolean remoteSccpProhibited) {
        this.remoteSccpProhibited = remoteSccpProhibited;
    }

    protected void setRemoteSpc(int remoteSpc) {
        this.remoteSpc = remoteSpc;
    }

    protected void setRemoteSpcFlag(int remoteSpcFlag) {
        this.remoteSpcFlag = remoteSpcFlag;
    }

    protected void setMask(int mask) {
        this.mask = mask;
    }

    @Override
    public int getCurrentRestrictionLevel() {
        return this.rl;
    }

    public int getCurrentRestrictionSubLevel() {
        return this.rsl;
    }

    void clearCongLevel() {
        this.remoteSignalingPointCodeExt.clearCongLevel();
    }

    void increaseCongLevel(int level) {
        this.remoteSignalingPointCodeExt.increaseCongLevel(level);
    }

    public void setCurrentRestrictionLevel(int value) {
        this.rl = value;
        this.rsl = 0;
    }

    public void setRl(int val) {
        this.rl = val;
    }

    public void setRsl(int val) {
        this.rsl = val;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("rsp=").append(this.remoteSpc).append(" rsp-flag=").append(this.remoteSpcFlag).append(" mask=").append(this.mask).append(" rsp-prohibited=").append(this.remoteSpcProhibited).append(" rsccp-prohibited=").append(this.remoteSccpProhibited).append(" rl=").append(this.rl).append(" rsl=").append(this.rsl);
        return sb.toString();
    }
}

