/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPMessageType;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.datacoding.CBSDataCodingScheme;
import org.restcomm.protocols.ss7.map.api.primitives.USSDString;
import org.restcomm.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSResponse;
import org.restcomm.protocols.ss7.map.datacoding.CBSDataCodingSchemeImpl;
import org.restcomm.protocols.ss7.map.primitives.USSDStringImpl;
import org.restcomm.protocols.ss7.map.service.supplementary.SupplementaryMessageImpl;

public class ProcessUnstructuredSSResponseImpl
extends SupplementaryMessageImpl
implements ProcessUnstructuredSSResponse {
    protected static final XMLFormat<ProcessUnstructuredSSResponseImpl> PROCESS_UNSTRUCTURED_SS_RESPONSE_XML = new XMLFormat<ProcessUnstructuredSSResponseImpl>(ProcessUnstructuredSSResponseImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, ProcessUnstructuredSSResponseImpl ussdMessage) throws XMLStreamException {
            SupplementaryMessageImpl.USSD_MESSAGE_XML.read(xml, ussdMessage);
        }

        @Override
        public void write(ProcessUnstructuredSSResponseImpl ussdMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            SupplementaryMessageImpl.USSD_MESSAGE_XML.write(ussdMessage, xml);
        }
    };

    public ProcessUnstructuredSSResponseImpl() {
    }

    public ProcessUnstructuredSSResponseImpl(CBSDataCodingScheme ussdDataCodingSch, USSDString ussdString) {
        super(ussdDataCodingSch, ussdString);
    }

    @Override
    public MAPMessageType getMessageType() {
        return MAPMessageType.processUnstructuredSSRequest_Response;
    }

    @Override
    public int getOperationCode() {
        return 59;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ProcessUnstructuredSSResponseIndication: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ProcessUnstructuredSSResponseIndication: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ProcessUnstructuredSSResponseIndication: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ProcessUnstructuredSSResponseIndication: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding ProcessUnstructuredSSResponseIndication: Parameter ussd-DataCodingScheme bad tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int length1 = ais.readLength();
        this.ussdDataCodingSch = new CBSDataCodingSchemeImpl(ais.readOctetStringData(length1)[0]);
        tag = ais.readTag();
        if (ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding ProcessUnstructuredSSResponseIndication: Parameter ussd-String bad tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.ussdString = new USSDStringImpl(this.ussdDataCodingSch);
        ((USSDStringImpl)this.ussdString).decodeAll(ais);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ProcessUnstructuredSSResponseIndication", e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.ussdString == null) {
            throw new MAPException("ussdString must not be null");
        }
        try {
            asnOs.writeOctetString(new byte[]{(byte)this.ussdDataCodingSch.getCode()});
            ((USSDStringImpl)this.ussdString).encodeAll(asnOs);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding ProcessUnstructuredSSResponseIndication", e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ProcessUnstructuredSSResponseIndication", e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProcessUnstructuredSSResponse [");
        if (this.getMAPDialog() != null) {
            sb.append("DialogId=").append(this.getMAPDialog().getLocalDialogId());
        }
        sb.append(super.toString());
        sb.append("]");
        return sb.toString();
    }
}

