/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.scheduler;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.scheduler.Clock;
import org.mobicents.protocols.ss7.scheduler.ConcurrentLinkedList;
import org.mobicents.protocols.ss7.scheduler.OrderedTaskQueue;
import org.mobicents.protocols.ss7.scheduler.Task;

public class Scheduler {
    public static final Integer MANAGEMENT_QUEUE = 0;
    public static final Integer L2READ_QUEUE = 1;
    public static final Integer L3READ_QUEUE = 2;
    public static final Integer L4READ_QUEUE = 3;
    public static final Integer TCAPREAD_QUEUE = 4;
    public static final Integer APPREAD_QUEUE = 5;
    public static final Integer APPWRITE_QUEUE = 6;
    public static final Integer TCAPWRITE_QUEUE = 7;
    public static final Integer L4WRITE_QUEUE = 8;
    public static final Integer L3WRITE_QUEUE = 9;
    public static final Integer L2WRITE_QUEUE = 10;
    public static final Integer INTERNETWORKING_QUEUE = 3;
    public static final Integer HEARTBEAT_QUEUE = -1;
    private Clock clock;
    protected OrderedTaskQueue[] taskQueues = new OrderedTaskQueue[11];
    protected OrderedTaskQueue heartBeatQueue;
    private CpuThread cpuThread;
    private boolean isActive;
    private Logger logger = Logger.getLogger(Scheduler.class);

    public Scheduler() {
        for (int i = 0; i < this.taskQueues.length; ++i) {
            this.taskQueues[i] = new OrderedTaskQueue();
        }
        this.heartBeatQueue = new OrderedTaskQueue();
        this.cpuThread = new CpuThread(String.format("Scheduler", new Object[0]));
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void submit(Task task, Integer index) {
        task.activate(false);
        this.taskQueues[index].accept(task);
    }

    public void submitHeatbeat(Task task) {
        task.activate(true);
        this.heartBeatQueue.accept(task);
    }

    public void start() {
        if (this.isActive) {
            return;
        }
        if (this.clock == null) {
            throw new IllegalStateException("Clock is not set");
        }
        this.isActive = true;
        this.logger.info("Starting ");
        this.cpuThread.activate();
        this.logger.info("Started ");
    }

    public void stop() {
        if (!this.isActive) {
            return;
        }
        this.cpuThread.shutdown();
        try {
            Thread.sleep(40L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (int i = 0; i < this.taskQueues.length; ++i) {
            this.taskQueues[i].clear();
        }
        this.heartBeatQueue.clear();
    }

    public double getMissRate() {
        return 0.0;
    }

    public long getWorstExecutionTime() {
        return 0L;
    }

    public void notifyCompletion() {
        this.cpuThread.notifyCompletion();
    }

    private class CpuThread
    extends Thread {
        private volatile boolean active;
        private int currQueue;
        private AtomicInteger activeTasksCount;
        private long cycleStart;
        private int runIndex;
        private ExecutorService eservice;
        private Object LOCK;

        public CpuThread(String name) {
            super(name);
            this.currQueue = MANAGEMENT_QUEUE;
            this.activeTasksCount = new AtomicInteger();
            this.cycleStart = 0L;
            this.runIndex = 0;
            this.LOCK = new Object();
            int size = Runtime.getRuntime().availableProcessors() * 2;
            this.eservice = new ThreadPoolExecutor(size, size, 0L, TimeUnit.MILLISECONDS, new ConcurrentLinkedList<Runnable>());
        }

        public void activate() {
            this.active = true;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyCompletion() {
            int newValue = this.activeTasksCount.decrementAndGet();
            if (newValue == 0 && this.active) {
                Object object = this.LOCK;
                synchronized (object) {
                    this.LOCK.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.cycleStart = System.nanoTime();
            while (this.active) {
                long cycleDuration;
                Object object;
                while (this.currQueue <= L2WRITE_QUEUE) {
                    object = this.LOCK;
                    synchronized (object) {
                        if (this.executeQueue(Scheduler.this.taskQueues[this.currQueue])) {
                            try {
                                this.LOCK.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                    ++this.currQueue;
                }
                this.runIndex = (this.runIndex + 1) % 25;
                if (this.runIndex == 0) {
                    object = this.LOCK;
                    synchronized (object) {
                        if (this.executeQueue(Scheduler.this.heartBeatQueue)) {
                            try {
                                this.LOCK.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                if ((cycleDuration = System.nanoTime() - this.cycleStart) < 4000000L) {
                    try {
                        CpuThread.sleep(4L - cycleDuration / 1000000L, (int)((4000000L - cycleDuration) % 1000000L));
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.cycleStart += 4000000L;
                this.currQueue = MANAGEMENT_QUEUE;
            }
        }

        private boolean executeQueue(OrderedTaskQueue currQueue) {
            currQueue.changePool();
            int currQueueSize = currQueue.size();
            this.activeTasksCount.set(currQueueSize);
            Task t = currQueue.poll();
            while (t != null) {
                this.eservice.execute(t);
                t = currQueue.poll();
            }
            return currQueueSize != 0;
        }

        private void shutdown() {
            this.active = false;
        }
    }
}

