/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.linkset.oam;

import javolution.util.FastCollection;
import javolution.util.FastMap;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.scheduler.Scheduler;
import org.mobicents.ss7.linkset.oam.Link;
import org.mobicents.ss7.linkset.oam.LinksetSelectorKey;
import org.mobicents.ss7.linkset.oam.LinksetStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Linkset
implements XMLSerializable {
    protected static final int NAME_SIZE = 10;
    protected static final String LINKSET_NAME = "name";
    protected static final String LINKSET_STATE = "state";
    protected static final String LINKSET_MODE = "mode";
    protected static final String LINKSET_OPC = "opc";
    protected static final String LINKSET_APC = "apc";
    protected static final String LINKSET_NI = "ni";
    protected static final String LINKS = "links";
    protected static final String LINK = "link";
    protected String linksetName = null;
    protected int apc;
    protected int opc;
    protected int ni = 2;
    protected int state = 1;
    protected int mode = 1;
    protected LinksetSelectorKey selectorKey = null;
    protected LinksetStream linksetStream = null;
    protected FastMap<String, Link> links = new FastMap();
    protected FastMap<String, Link> loadedLinks = new FastMap();
    protected Scheduler scheduler;
    protected static final XMLFormat<Linkset> LINKSET_XML = new XMLFormat<Linkset>(Linkset.class){

        @Override
        public void read(XMLFormat.InputElement xml, Linkset linkSet) throws XMLStreamException {
            linkSet.linksetName = xml.getAttribute(Linkset.LINKSET_NAME).toString();
            linkSet.state = xml.getAttribute(Linkset.LINKSET_STATE, 1);
            linkSet.mode = xml.getAttribute(Linkset.LINKSET_MODE, 1);
            linkSet.opc = xml.getAttribute(Linkset.LINKSET_OPC, -1);
            linkSet.apc = xml.getAttribute(Linkset.LINKSET_APC, -1);
            linkSet.ni = xml.getAttribute(Linkset.LINKSET_NI, 2);
            int linksCount = xml.getAttribute(Linkset.LINKS, 0);
            for (int i = 0; i < linksCount; ++i) {
                Link link = (Link)xml.get(Linkset.LINK);
                link.setLinkSet(linkSet);
                link.setScheduler(linkSet.getScheduler());
                linkSet.loadedLinks.put(link.getName(), link);
            }
        }

        @Override
        public void write(Linkset linkSet, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(Linkset.LINKSET_NAME, linkSet.linksetName);
            xml.setAttribute(Linkset.LINKSET_STATE, 1);
            xml.setAttribute(Linkset.LINKSET_MODE, linkSet.mode);
            xml.setAttribute(Linkset.LINKSET_OPC, linkSet.opc);
            xml.setAttribute(Linkset.LINKSET_APC, linkSet.apc);
            xml.setAttribute(Linkset.LINKSET_NI, linkSet.ni);
            xml.setAttribute(Linkset.LINKS, linkSet.links.size());
            FastCollection.Record e = linkSet.getLinks().head();
            FastMap.Entry<String, Link> end = linkSet.getLinks().tail();
            while ((e = ((FastMap.Entry)e).getNext()) != end) {
                Link value = (Link)((FastMap.Entry)e).getValue();
                xml.add(value, Linkset.LINK);
            }
        }
    };

    public Linkset() {
        this.initialize();
    }

    public Linkset(String linksetName, int opc, int apc, int ni) {
        this();
        this.linksetName = linksetName;
        this.opc = opc;
        this.apc = apc;
        this.ni = ni;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        Link link;
        this.scheduler = scheduler;
        FastCollection.Record e = this.links.head();
        FastMap.Entry<String, Link> end = this.links.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            link = (Link)((FastMap.Entry)e).getValue();
            link.setScheduler(scheduler);
        }
        e = this.loadedLinks.head();
        end = this.loadedLinks.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            link = (Link)((FastMap.Entry)e).getValue();
            link.setScheduler(scheduler);
        }
    }

    protected abstract void initialize();

    protected abstract void configure() throws Exception;

    public LinksetStream getLinksetStream() {
        return this.linksetStream;
    }

    public int getApc() {
        return this.apc;
    }

    public void setApc(int dpc) {
        this.apc = dpc;
    }

    public int getOpc() {
        return this.opc;
    }

    public void setOpc(int opc) {
        this.opc = opc;
    }

    public int getNi() {
        return this.ni;
    }

    public void setNi(int ni) {
        this.ni = ni;
    }

    public String getName() {
        return this.linksetName;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getMode() {
        return this.mode;
    }

    public FastMap<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(FastMap<String, Link> links) {
        this.links = links;
    }

    public Link getLink(String linkName) {
        return this.links.get(linkName);
    }

    public abstract void createLink(String[] var1) throws Exception;

    public abstract void deleteLink(String var1) throws Exception;

    public abstract void activate() throws Exception;

    public abstract void deactivate() throws Exception;

    public abstract void activateLink(String var1) throws Exception;

    public void activateLinks() {
        this.links.putAll(this.loadedLinks);
    }

    public abstract void deactivateLink(String var1) throws Exception;

    public abstract void print(StringBuffer var1, int var2, int var3);
}

