/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.oam.common.statistics;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javolution.text.TextBuilder;
import javolution.util.FastMap;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanHost;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanType;
import org.mobicents.protocols.ss7.oam.common.statistics.CounterCampaignImpl;
import org.mobicents.protocols.ss7.oam.common.statistics.CounterCampaignMap;
import org.mobicents.protocols.ss7.oam.common.statistics.CounterLayer;
import org.mobicents.protocols.ss7.oam.common.statistics.CounterProviderManagementMBean;
import org.mobicents.protocols.ss7.oam.common.statistics.CounterValueImpl;
import org.mobicents.protocols.ss7.oam.common.statistics.CounterValueSetImpl;
import org.mobicents.protocols.ss7.oam.common.statistics.StatsPrinter;
import org.mobicents.protocols.ss7.oam.common.statistics.api.ComplexValue;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterCampaign;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterDef;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterDefSet;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterMediator;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterType;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterValueSet;
import org.mobicents.protocols.ss7.oam.common.statistics.api.SourceValueCounter;
import org.mobicents.protocols.ss7.oam.common.statistics.api.SourceValueObject;
import org.mobicents.protocols.ss7.oam.common.statistics.api.SourceValueSet;

public class CounterProviderManagement
implements CounterProviderManagementMBean {
    protected final Logger logger;
    protected static final String COUNTER_PROVIDER_PERSIST_DIR_KEY = "counterprovider.persist.dir";
    protected static final String USER_DIR_KEY = "user.dir";
    protected static final String PERSIST_FILE_NAME = "CounterProvider.xml";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final String TAB_INDENT = "\t";
    private static final String COUNTER_CAMPAIGNS = "counterCampaigns";
    private static final String COUNTER_CAMPAIGN = "counterCampaign";
    private static final XMLBinding binding = new XMLBinding();
    private final MBeanHost beanHost;
    private String name = "CounterHost";
    protected final TextBuilder persistFile = TextBuilder.newInstance();
    protected String persistDir = null;
    private boolean isStarted;
    private int minuteProcessed;
    private int secondProcessed;
    private final StatsPrinter statsPrinter;
    protected FastMap<String, CounterMediator> lstCounterMediator = new FastMap();
    private FastMap<String, CounterMediator> lstCounterDefSet = new FastMap();
    protected CounterCampaignMap<String, CounterCampaignImpl> lstCounterCampaign = new CounterCampaignMap();

    public CounterProviderManagement(MBeanHost beanHost) {
        this.beanHost = beanHost;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        binding.setAlias(CounterCampaignImpl.class, COUNTER_CAMPAIGN);
        binding.setAlias(String.class, "String");
        this.logger = Logger.getLogger(CounterProviderManagement.class.getCanonicalName() + "-" + this.name);
        this.statsPrinter = new StatsPrinter();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String val) {
        this.name = val;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.logger.info("Starting ...");
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty(COUNTER_PROVIDER_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        this.logger.info(String.format("CounterManagement configuration file path %s", this.persistFile.toString()));
        this.lstCounterCampaign.clear();
        this.load();
        CounterProviderManagement counterProviderManagement = this;
        synchronized (counterProviderManagement) {
            this.isStarted = true;
            this.lstCounterMediator.clear();
            this.lstCounterDefSet.clear();
            this.beanHost.registerMBean(CounterLayer.COUNTER, CounterManagementType.MANAGEMENT, this.name, this);
            this.secondProcessed = -1;
            this.minuteProcessed = -1;
            Thread t1 = new Thread(new CouterProcessingClass(true));
            t1.start();
            Thread t2 = new Thread(new CouterProcessingClass(false));
            t2.start();
        }
        this.logger.info("Started ...");
    }

    public void stop() {
        this.logger.info("Stopping ...");
        this.isStarted = false;
        this.logger.info("Stopped ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCounterMediator(CounterMediator val) {
        CounterProviderManagement counterProviderManagement = this;
        synchronized (counterProviderManagement) {
            this.lstCounterMediator.put(val.getCounterMediatorName(), val);
            String[] ss = val.getCounterDefSetList();
            if (ss != null) {
                for (String s : ss) {
                    this.lstCounterDefSet.put(s, val);
                    for (CounterCampaignImpl cc : this.lstCounterCampaign.values()) {
                        if (!cc.getCounterSetName().equals(s)) continue;
                        cc.setCounterSet(val.getCounterDefSet(s));
                    }
                }
            }
            this.logger.info("Registered CounterMediator: " + val.getCounterMediatorName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterCounterMediator(CounterMediator val) {
        CounterProviderManagement counterProviderManagement = this;
        synchronized (counterProviderManagement) {
            this.lstCounterMediator.remove(val.getCounterMediatorName());
            ArrayList<String> toDel = new ArrayList<String>();
            for (String s : this.lstCounterDefSet.keySet()) {
                if (!this.lstCounterDefSet.get(s).getCounterMediatorName().equals(val.getCounterMediatorName())) continue;
                toDel.add(s);
            }
            for (String s : toDel) {
                this.lstCounterDefSet.remove(s);
            }
            this.logger.info("Unregistered CounterMediator: " + val.getCounterMediatorName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCounterDefSetList() {
        String[] ress = new String[this.lstCounterDefSet.size()];
        int i1 = 0;
        CounterProviderManagement counterProviderManagement = this;
        synchronized (counterProviderManagement) {
            for (String s : this.lstCounterDefSet.keySet()) {
                ress[i1++] = s;
            }
        }
        return ress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CounterDefSet getCounterDefSet(String counterDefSetName) {
        CounterProviderManagement counterProviderManagement = this;
        synchronized (counterProviderManagement) {
            CounterMediator cm = this.lstCounterDefSet.get(counterDefSetName);
            if (cm != null) {
                return cm.getCounterDefSet(counterDefSetName);
            }
        }
        return null;
    }

    public void createCampaign(String campaignName, String counterSetName, int duration) throws Exception {
        this.doCreateCampaign(campaignName, counterSetName, duration, false);
    }

    public void createShortCampaign(String campaignName, String counterSetName, int duration) throws Exception {
        this.doCreateCampaign(campaignName, counterSetName, duration, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCreateCampaign(String campaignName, String counterSetName, int duration, boolean shortCampaign) throws Exception {
        if (campaignName == null) {
            throw new Exception("Campaign Name cannot be null");
        }
        if (counterSetName == null) {
            throw new Exception("CounterSet Name cannot be null");
        }
        if (this.lstCounterCampaign.containsKey(campaignName)) {
            throw new Exception("Campaign " + campaignName + " already exists");
        }
        if (duration != 5 && duration != 10 && duration != 15 && duration != 20 && duration != 30 && duration != 60) {
            throw new Exception("Duration may be only 5, 10, 15, 20, 30 or 60 minutes/seconds");
        }
        CounterMediator cm = this.lstCounterDefSet.get(counterSetName);
        if (cm == null) {
            throw new Exception("CounterMediator is null for counterSetName=" + counterSetName);
        }
        CounterProviderManagement counterProviderManagement = this;
        synchronized (counterProviderManagement) {
            CounterDefSet counterSet = cm.getCounterDefSet(counterSetName);
            CounterCampaignImpl camp = new CounterCampaignImpl(campaignName, counterSetName, counterSet, duration, shortCampaign);
            this.lstCounterCampaign.put(campaignName, camp);
            this.store();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Created campaign: name=" + campaignName + ", counterSetName=" + counterSetName + ", duration=" + duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCampaign(String campaignName) throws Exception {
        if (!this.lstCounterCampaign.containsKey(campaignName)) {
            throw new Exception("Campaign " + campaignName + " not found");
        }
        CounterProviderManagement counterProviderManagement = this;
        synchronized (counterProviderManagement) {
            this.lstCounterCampaign.remove(campaignName);
            this.store();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Campaign destroyed: name=" + campaignName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCampaignsList() {
        CounterProviderManagement counterProviderManagement = this;
        synchronized (counterProviderManagement) {
            String[] res = new String[this.lstCounterCampaign.size()];
            int i1 = 0;
            for (String s : this.lstCounterCampaign.keySet()) {
                res[i1++] = s;
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CounterCampaign getCampaign(String campaignName) {
        CounterProviderManagement counterProviderManagement = this;
        synchronized (counterProviderManagement) {
            return (CounterCampaign)this.lstCounterCampaign.get(campaignName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CounterValueSet getLastCounterValues(String campaignName) {
        CounterProviderManagement counterProviderManagement = this;
        synchronized (counterProviderManagement) {
            CounterCampaign camp = (CounterCampaign)this.lstCounterCampaign.get(campaignName);
            if (camp != null) {
                return camp.getLastCounterValueSet();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processCampaign(CounterCampaignImpl cc, Date endTime) {
        if (cc.isShortCampaign()) {
            this.logger.debug("Campaign processing: name=" + cc.getName());
        } else {
            this.logger.info("Campaign processing: name=" + cc.getName());
        }
        try {
            CounterMediator cm = null;
            CounterProviderManagement counterProviderManagement = this;
            synchronized (counterProviderManagement) {
                cm = this.lstCounterDefSet.get(cc.getCounterSetName());
            }
            if (cm != null) {
                int durationSeconds;
                int duration;
                Date startTime;
                SourceValueSet svs1 = cc.getLastSourceValueSet();
                this.statsPrinter.printStats(cc);
                int durationInSeconds = cc.getDuration();
                if (!cc.isShortCampaign()) {
                    durationInSeconds *= 60;
                }
                SourceValueSet svs2 = cm.getSourceValueSet(cc.getCounterSetName(), cc.getName(), durationInSeconds);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("svs1 = " + svs1 + " svs2 = " + svs2);
                }
                cc.setLastSourceValueSet(svs2);
                cc.setCounterValueSet(null);
                if (svs1 == null || svs2 == null || !svs1.getSessionId().equals(svs2.getSessionId())) {
                    return;
                }
                if (cc.isShortCampaign()) {
                    startTime = new Date(endTime.getTime() - (long)(cc.getDuration() * 1000));
                    duration = cc.getDuration();
                    durationSeconds = cc.getDuration() * 60;
                } else {
                    startTime = new Date(endTime.getTime() - (long)(cc.getDuration() * 60 * 1000));
                    duration = cc.getDuration();
                    durationSeconds = 0;
                }
                CounterValueSetImpl res = new CounterValueSetImpl(startTime, endTime, duration, durationSeconds);
                for (SourceValueCounter sv2 : svs2.getCounters().values()) {
                    CounterDef cd1;
                    CounterDef cd2 = sv2.getCounterDef();
                    SourceValueCounter sv1 = svs1.getCounters().get(sv2.getCounterDef().getCounterName());
                    if (sv1 == null || (cd1 = sv1.getCounterDef()).getCounterType() != cd2.getCounterType()) continue;
                    for (SourceValueObject obj2 : sv2.getObjects().values()) {
                        SourceValueObject obj1 = sv1.getObjects().get(obj2.getObjectName());
                        if (obj1 == null && cd2.getCounterType() != CounterType.Minimal && cd2.getCounterType() != CounterType.Maximal && cd2.getCounterType() != CounterType.ComplexValue) continue;
                        CounterValueImpl val = null;
                        switch (cd2.getCounterType()) {
                            case Summary_Cumulative: {
                                long valr = obj2.getValue();
                                val = new CounterValueImpl(cd2, obj2.getObjectName(), valr);
                                break;
                            }
                            case Summary: {
                                long valr = obj2.getValue() - obj1.getValue();
                                val = new CounterValueImpl(cd2, obj2.getObjectName(), valr);
                                break;
                            }
                            case SummaryDouble: {
                                double vald = obj2.getValueA() - obj1.getValueA();
                                val = new CounterValueImpl(cd2, obj2.getObjectName(), 0L);
                                val.setDoubleValue(vald);
                                break;
                            }
                            case Minimal: {
                                val = new CounterValueImpl(cd2, obj2.getObjectName(), obj2.getValue());
                                break;
                            }
                            case Maximal: {
                                val = new CounterValueImpl(cd2, obj2.getObjectName(), obj2.getValue());
                                break;
                            }
                            case Average: {
                                double d1 = obj2.getValueA() - obj1.getValueA();
                                double d2 = obj2.getValueB() - obj1.getValueB();
                                val = new CounterValueImpl(cd2, obj2.getObjectName(), 0L);
                                if (d2 == 0.0) break;
                                val.setDoubleValue(d1 / d2);
                                break;
                            }
                            case ComplexValue: {
                                val = new CounterValueImpl(cd2, obj2.getObjectName(), 0L);
                                for (ComplexValue cv : obj2.getComplexValue()) {
                                    val.addComplexValue(cv);
                                }
                                break;
                            }
                        }
                        if (val == null) continue;
                        res.addCounterValue(val);
                    }
                }
                cc.setCounterValueSet(res);
            } else {
                this.logger.error("CounterMediator not found for " + cc.getCounterSetName());
            }
        }
        catch (Throwable e) {
            this.logger.info("Exception when campaign processing: name=" + cc.getName() + " - " + e.getMessage(), e);
        }
        if (cc.isShortCampaign()) {
            this.logger.debug("Campaign processed: name=" + cc.getName());
        } else {
            this.logger.info("Campaign processed: name=" + cc.getName());
        }
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance(new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.lstCounterCampaign, COUNTER_CAMPAIGNS, CounterCampaignMap.class);
            writer.close();
        }
        catch (Exception e) {
            this.logger.error("Error while persisting the CounterProvider state in file", e);
        }
    }

    private void load() {
        try {
            File f = new File(this.persistFile.toString());
            if (f.exists()) {
                XMLObjectReader reader = XMLObjectReader.newInstance(new FileInputStream(this.persistFile.toString()));
                reader.setBinding(binding);
                this.lstCounterCampaign = reader.read(COUNTER_CAMPAIGNS, CounterCampaignMap.class);
                reader.close();
            }
        }
        catch (XMLStreamException ex) {
            this.logger.error(String.format("Failed to load the CounterProvider configuration file. \n%s", ex.getMessage()));
        }
        catch (FileNotFoundException e) {
            this.logger.warn(String.format("Failed to load the CounterProvider configuration file. \n%s", e.getMessage()));
        }
        catch (IOException e) {
            this.logger.error(String.format("Failed to load the CounterProvider configuration file. \n%s", e.getMessage()));
        }
    }

    static /* synthetic */ boolean access$000(CounterProviderManagement x0) {
        return x0.isStarted;
    }

    static /* synthetic */ int access$100(CounterProviderManagement x0) {
        return x0.secondProcessed;
    }

    static /* synthetic */ int access$102(CounterProviderManagement x0, int x1) {
        x0.secondProcessed = x1;
        return x0.secondProcessed;
    }

    static /* synthetic */ int access$200(CounterProviderManagement x0) {
        return x0.minuteProcessed;
    }

    static /* synthetic */ int access$202(CounterProviderManagement x0, int x1) {
        x0.minuteProcessed = x1;
        return x0.minuteProcessed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CounterManagementType implements MBeanType
    {
        MANAGEMENT("Management");

        private final String name;
        public static final String NAME_MANAGEMENT = "Management";

        private CounterManagementType(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public static CounterManagementType getInstance(String name) {
            if (NAME_MANAGEMENT.equals(name)) {
                return MANAGEMENT;
            }
            return null;
        }
    }

    private class CouterProcessingClass
    implements Runnable {
        private boolean shortCampaign;

        public CouterProcessingClass(boolean shortCampaign) {
            this.shortCampaign = shortCampaign;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block5: while (true) {
                if (!CounterProviderManagement.access$000(CounterProviderManagement.this)) {
                    return;
                }
                try {
                    Thread.sleep(this.shortCampaign != false ? 200L : 1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                dt = new Date();
                if (this.shortCampaign) {
                    sc = dt.getSeconds();
                    if (sc != 0 && sc != 5 && sc != 10 && sc != 15 && sc != 20 && sc != 25 && sc != 30 && sc != 35 && sc != 40 && sc != 45 && sc != 50 && sc != 55 || sc == CounterProviderManagement.access$100(CounterProviderManagement.this)) continue;
                    CounterProviderManagement.access$102(CounterProviderManagement.this, sc);
                    minuteSecond = sc;
                    endTime = new Date(dt.getYear(), dt.getMonth(), dt.getDate(), dt.getHours(), dt.getMinutes(), dt.getSeconds());
                } else {
                    if (dt.getSeconds() > 30 || (mn = dt.getMinutes()) != 0 && mn != 5 && mn != 10 && mn != 15 && mn != 20 && mn != 25 && mn != 30 && mn != 35 && mn != 40 && mn != 45 && mn != 50 && mn != 55 || mn == CounterProviderManagement.access$200(CounterProviderManagement.this)) continue;
                    CounterProviderManagement.access$202(CounterProviderManagement.this, mn);
                    minuteSecond = mn;
                    endTime = new Date(dt.getYear(), dt.getMonth(), dt.getDate(), dt.getHours(), dt.getMinutes(), 0);
                }
                var5_7 = this;
                synchronized (var5_7) {
                    ccc = new CounterCampaignImpl[CounterProviderManagement.this.lstCounterCampaign.size()];
                    i1 = 0;
                    for (CounterCampaignImpl cc : CounterProviderManagement.this.lstCounterCampaign.values()) {
                        ccc[i1++] = cc;
                    }
                }
                arr$ = ccc;
                len$ = arr$.length;
                i$ = 0;
                while (true) {
                    if (i$ < len$) ** break;
                    continue block5;
                    cc = arr$[i$];
                    if (this.shortCampaign == cc.isShortCampaign() && minuteSecond % cc.getDuration() == 0) {
                        CounterProviderManagement.this.processCampaign(cc, endTime);
                    }
                    ++i$;
                }
                break;
            }
        }
    }
}

