/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.oam.common.alarm;

import java.util.List;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javolution.util.FastList;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmLayer;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmListener;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmMediator;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmMessage;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmNotification;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmProviderMBean;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmProviderStandardMBean;
import org.mobicents.protocols.ss7.oam.common.alarm.CurrentAlarmList;
import org.mobicents.protocols.ss7.oam.common.alarm.CurrentAlarmListImpl;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanHost;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanType;

public class AlarmProvider
extends NotificationBroadcasterSupport
implements AlarmProviderMBean,
AlarmListener {
    public static String ALARM_EVENT = "Alarm_Event";
    private final MBeanHost beanHost;
    private final AlarmMediator alarmMediator;
    private List<AlarmMediator> alarmMediators = new FastList<AlarmMediator>();
    private long sequenceNumber = 0L;
    private String alarmProviderObjectPath;
    private String alarmProviderObjectPathWithSlash;
    private String name = "AlarmHost";

    public AlarmProvider(MBeanHost beanHost, AlarmMediator alarmMediator) {
        this.beanHost = beanHost;
        this.alarmMediator = alarmMediator;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String val) {
        this.name = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AlarmProvider alarmProvider = this;
        synchronized (alarmProvider) {
            try {
                AlarmProviderStandardMBean sbean = new AlarmProviderStandardMBean(this, AlarmProviderMBean.class, (NotificationEmitter)this);
                this.beanHost.registerMBean(AlarmLayer.ALARM, AlarmManagementType.MANAGEMENT, this.name, sbean);
            }
            catch (NotCompliantMBeanException e) {
                e.printStackTrace();
            }
            this.alarmMediator.registerAlarmListener(this);
            this.registerAlarmMediator(this.alarmMediator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AlarmProvider alarmProvider = this;
        synchronized (alarmProvider) {
            this.alarmMediator.unregisterAlarmListener(this);
            this.unregisterAlarmMediator(this.alarmMediator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAlarmMediator(AlarmMediator am) {
        List<AlarmMediator> list = this.alarmMediators;
        synchronized (list) {
            this.alarmMediators.add(am);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAlarmMediator(AlarmMediator am) {
        List<AlarmMediator> list = this.alarmMediators;
        synchronized (list) {
            this.alarmMediators.remove(am);
        }
    }

    public String getAlarmProviderObjectPath() {
        return this.alarmProviderObjectPath;
    }

    public void setAlarmProviderObjectPath(String value) {
        this.alarmProviderObjectPath = value;
        this.alarmProviderObjectPathWithSlash = this.alarmProviderObjectPath != null && !this.alarmProviderObjectPath.equals("") ? "/" + this.alarmProviderObjectPath : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CurrentAlarmList getCurrentAlarmList() {
        CurrentAlarmListImpl al = new CurrentAlarmListImpl();
        List<AlarmMediator> list = this.alarmMediators;
        synchronized (list) {
            for (AlarmMediator amr : this.alarmMediators) {
                CurrentAlarmList temp = amr.getCurrentAlarmList();
                for (AlarmMessage alm : temp.getCurrentAlarmList()) {
                    if (this.alarmProviderObjectPath != null) {
                        alm.addPrefixToAlarmSource(this.alarmProviderObjectPath);
                    }
                    al.addAlarm(alm);
                }
            }
        }
        al.sortAlarms();
        return al;
    }

    public void onAlarm(AlarmMessage alarm) {
        if (this.alarmProviderObjectPath != null) {
            alarm.addPrefixToAlarmSource(this.alarmProviderObjectPath);
        }
        this.doSendNotif(alarm);
    }

    private synchronized void doSendNotif(AlarmMessage alarm) {
        AlarmNotification notif = new AlarmNotification(ALARM_EVENT + "-" + this.alarmProviderObjectPath, "AlarmProvider", ++this.sequenceNumber, System.currentTimeMillis(), null, alarm);
        this.sendNotification(notif);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AlarmManagementType implements MBeanType
    {
        MANAGEMENT("Management");

        private final String name;
        public static final String NAME_MANAGEMENT = "Management";

        private AlarmManagementType(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public static AlarmManagementType getInstance(String name) {
            if (NAME_MANAGEMENT.equals(name)) {
                return MANAGEMENT;
            }
            return null;
        }
    }
}

