/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.UpdateGprsLocationResponse;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MobilityMessageImpl;

public class UpdateGprsLocationResponseImpl
extends MobilityMessageImpl
implements UpdateGprsLocationResponse {
    private static final int TAG_sgsnMmeSeparationSupported = 0;
    public static final String _PrimitiveName = "UpdateGprsLocationResponse";
    private ISDNAddressString hlrNumber;
    private MAPExtensionContainer extensionContainer;
    private boolean addCapability;
    private boolean sgsnMmeSeparationSupported;

    public UpdateGprsLocationResponseImpl() {
    }

    public UpdateGprsLocationResponseImpl(ISDNAddressString hlrNumber, MAPExtensionContainer extensionContainer, boolean addCapability, boolean sgsnMmeSeparationSupported) {
        this.hlrNumber = hlrNumber;
        this.extensionContainer = extensionContainer;
        this.addCapability = addCapability;
        this.sgsnMmeSeparationSupported = sgsnMmeSeparationSupported;
    }

    public ISDNAddressString getHlrNumber() {
        return this.hlrNumber;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public boolean getAddCapability() {
        return this.addCapability;
    }

    public boolean getSgsnMmeSeparationSupported() {
        return this.sgsnMmeSeparationSupported;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.updateGprsLocation_Request;
    }

    public int getOperationCode() {
        return 23;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding UpdateGprsLocationResponse: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding UpdateGprsLocationResponse: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding UpdateGprsLocationResponse: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding UpdateGprsLocationResponse: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.hlrNumber = null;
        this.extensionContainer = null;
        this.addCapability = false;
        this.sgsnMmeSeparationSupported = false;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationResponse.hlrNumber: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.hlrNumber = new ISDNAddressStringImpl();
                    ((ISDNAddressStringImpl)this.hlrNumber).decodeAll(ais);
                    break;
                }
                default: {
                    if (ais.getTagClass() == 0) {
                        switch (tag) {
                            case 16: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationResponse.extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.extensionContainer = new MAPExtensionContainerImpl();
                                ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                break block0;
                            }
                            case 5: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationResponse.addCapability: Parameter is  not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.addCapability = true;
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    if (ais.getTagClass() == 2) {
                        switch (tag) {
                            case 0: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationResponse.sgsnMmeSeparationSupported: Parameter is  not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.sgsnMmeSeparationSupported = true;
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (this.hlrNumber == null) {
            throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationResponse: hlrNumber is null ", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        try {
            this.encodeAll(asnOs, this.getTagClass(), this.getTag());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MAPException(e);
        }
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            e.printStackTrace();
            throw new MAPException("AsnException when encoding UpdateGprsLocationResponse: " + e.getMessage(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MAPException("AsnException when encoding UpdateGprsLocationResponse: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.hlrNumber == null) {
                throw new MAPException("hlrNumber parameter must not be null");
            }
            ((ISDNAddressStringImpl)this.hlrNumber).encodeAll(asnOs);
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
            if (this.addCapability) {
                asnOs.writeNull();
            }
            if (this.sgsnMmeSeparationSupported) {
                asnOs.writeNull(2, 0);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding UpdateGprsLocationResponse: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding UpdateGprsLocationResponse: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.hlrNumber != null) {
            sb.append("hlrNumber=");
            sb.append(this.hlrNumber.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.addCapability) {
            sb.append("addCapability, ");
        }
        if (this.sgsnMmeSeparationSupported) {
            sb.append("sgsnMmeSeparationSupported, ");
        }
        sb.append("]");
        return sb.toString();
    }
}

