/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl;

import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.m3ua.ExchangeType;
import org.mobicents.protocols.ss7.m3ua.Functionality;
import org.mobicents.protocols.ss7.m3ua.IPSPType;
import org.mobicents.protocols.ss7.m3ua.impl.AsImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspImpl;
import org.mobicents.protocols.ss7.m3ua.impl.MessageHandler;
import org.mobicents.protocols.ss7.m3ua.impl.TransitionState;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSM;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.UnknownTransitionException;
import org.mobicents.protocols.ss7.m3ua.message.mgmt.Error;
import org.mobicents.protocols.ss7.m3ua.message.mgmt.Notify;
import org.mobicents.protocols.ss7.m3ua.parameter.ErrorCode;
import org.mobicents.protocols.ss7.m3ua.parameter.RoutingContext;

public class ManagementMessageHandler
extends MessageHandler {
    private static final Logger logger = Logger.getLogger(ManagementMessageHandler.class);

    public ManagementMessageHandler(AspFactoryImpl aspFactoryImpl) {
        super(aspFactoryImpl);
    }

    public void handleNotify(Notify notify) {
        RoutingContext rc = notify.getRoutingContext();
        if (this.aspFactoryImpl.getFunctionality() == Functionality.AS || this.aspFactoryImpl.getFunctionality() == Functionality.SGW && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.SE && this.aspFactoryImpl.getIpspType() == IPSPType.CLIENT) {
            if (rc == null) {
                AspImpl aspImpl = this.getAspForNullRc();
                if (aspImpl == null) {
                    logger.error(String.format("Rx : NTFY=%s with null RC for Aspfactory=%s. But no ASP configured for null RC. Sending back Error", notify, this.aspFactoryImpl.getName()));
                    return;
                }
                try {
                    FSM fsm = ((AsImpl)aspImpl.getAs()).getPeerFSM();
                    if (fsm == null) {
                        logger.error(String.format("Received NTFY=%s for ASP=%s. But Peer FSM is null.", notify, this.aspFactoryImpl.getName()));
                        return;
                    }
                    fsm.setAttribute("asp", aspImpl);
                    fsm.signal(TransitionState.getTransition(notify));
                }
                catch (UnknownTransitionException e) {
                    logger.error(e.getMessage(), e);
                }
            } else {
                long[] rcs = notify.getRoutingContext().getRoutingContexts();
                for (int count = 0; count < rcs.length; ++count) {
                    AspImpl aspImpl = this.aspFactoryImpl.getAsp(rcs[count]);
                    if (aspImpl == null) {
                        RoutingContext rcObj = this.aspFactoryImpl.parameterFactory.createRoutingContext(new long[]{rcs[count]});
                        ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(25);
                        this.sendError(rcObj, errorCodeObj);
                        logger.error(String.format("Rx : NTFY=%s with RC=%d for Aspfactory=%s. But no ASP configured for this RC. Sending back Error", notify, rcs[count], this.aspFactoryImpl.getName()));
                        continue;
                    }
                    try {
                        FSM fsm = ((AsImpl)aspImpl.getAs()).getPeerFSM();
                        if (fsm == null) {
                            logger.error(String.format("Received NTFY=%s for ASP=%s. But Peer FSM is null.", notify, this.aspFactoryImpl.getName()));
                            return;
                        }
                        fsm.setAttribute("asp", aspImpl);
                        fsm.signal(TransitionState.getTransition(notify));
                        continue;
                    }
                    catch (UnknownTransitionException e) {
                        logger.error(e.getMessage(), e);
                    }
                }
            }
        } else {
            ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(6);
            this.sendError(rc, errorCodeObj);
        }
    }

    public void handleError(Error error) {
        logger.error(error);
    }
}

