/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.isup.Digits;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.VariablePart;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.VariablePartDate;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.VariablePartPrice;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.VariablePartTime;
import org.mobicents.protocols.ss7.cap.isup.DigitsImpl;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.VariablePartDateImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.VariablePartPriceImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.VariablePartTimeImpl;

public class VariablePartImpl
implements VariablePart,
CAPAsnPrimitive {
    public static final int _ID_integer = 0;
    public static final int _ID_number = 1;
    public static final int _ID_time = 2;
    public static final int _ID_date = 3;
    public static final int _ID_price = 4;
    public static final String _PrimitiveName = "VariablePart";
    private static final String INTEGER = "integer";
    private static final String NUMBER = "number";
    private static final String TIME = "time";
    private static final String DATE = "date";
    private static final String PRICE = "price";
    private Integer integer;
    private Digits number;
    private VariablePartTime time;
    private VariablePartDate date;
    private VariablePartPrice price;
    protected static final XMLFormat<VariablePartImpl> VARIABLE_PART_XML = new XMLFormat<VariablePartImpl>(VariablePartImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, VariablePartImpl variablePart) throws XMLStreamException {
            variablePart.integer = xml.get(VariablePartImpl.INTEGER, Integer.class);
            variablePart.number = xml.get(VariablePartImpl.NUMBER, DigitsImpl.class);
            variablePart.time = xml.get(VariablePartImpl.TIME, VariablePartTimeImpl.class);
            variablePart.date = xml.get(VariablePartImpl.DATE, VariablePartDateImpl.class);
            variablePart.price = xml.get(VariablePartImpl.PRICE, VariablePartPriceImpl.class);
            int choiceCount = 0;
            if (variablePart.integer != null) {
                ++choiceCount;
            }
            if (variablePart.number != null) {
                ++choiceCount;
            }
            if (variablePart.time != null) {
                ++choiceCount;
            }
            if (variablePart.date != null) {
                ++choiceCount;
            }
            if (variablePart.price != null) {
                ++choiceCount;
            }
            if (choiceCount != 1) {
                throw new XMLStreamException("VariablePart decoding error: there must be one choice selected, found: " + choiceCount);
            }
        }

        @Override
        public void write(VariablePartImpl variablePart, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (variablePart.integer != null) {
                xml.add(variablePart.integer, VariablePartImpl.INTEGER, Integer.class);
            }
            if (variablePart.number != null) {
                xml.add((DigitsImpl)variablePart.number, VariablePartImpl.NUMBER, DigitsImpl.class);
            }
            if (variablePart.time != null) {
                xml.add((VariablePartTimeImpl)variablePart.time, VariablePartImpl.TIME, VariablePartTimeImpl.class);
            }
            if (variablePart.date != null) {
                xml.add((VariablePartDateImpl)variablePart.date, VariablePartImpl.DATE, VariablePartDateImpl.class);
            }
            if (variablePart.price != null) {
                xml.add((VariablePartPriceImpl)variablePart.price, VariablePartImpl.PRICE, VariablePartPriceImpl.class);
            }
        }
    };

    public VariablePartImpl() {
    }

    public VariablePartImpl(Integer integer) {
        this.integer = integer;
    }

    public VariablePartImpl(Digits number) {
        this.number = number;
    }

    public VariablePartImpl(VariablePartTime time) {
        this.time = time;
    }

    public VariablePartImpl(VariablePartDate date) {
        this.date = date;
    }

    public VariablePartImpl(VariablePartPrice price) {
        this.price = price;
    }

    public Integer getInteger() {
        return this.integer;
    }

    public Digits getNumber() {
        return this.number;
    }

    public VariablePartTime getTime() {
        return this.time;
    }

    public VariablePartDate getDate() {
        return this.date;
    }

    public VariablePartPrice getPrice() {
        return this.price;
    }

    public int getTag() throws CAPException {
        if (this.integer != null) {
            return 0;
        }
        if (this.number != null) {
            return 1;
        }
        if (this.time != null) {
            return 2;
        }
        if (this.date != null) {
            return 3;
        }
        if (this.price != null) {
            return 4;
        }
        throw new CAPException("Error while encoding VariablePart: no of choices has been definite");
    }

    public int getTagClass() {
        return 2;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding VariablePart: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding VariablePart: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding VariablePart: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding VariablePart: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.integer = null;
        this.number = null;
        this.time = null;
        this.date = null;
        this.price = null;
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding VariablePart: bad tagClass or is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (ais.getTag()) {
            case 0: {
                this.integer = (int)ais.readIntegerData(length);
                break;
            }
            case 1: {
                this.number = new DigitsImpl();
                ((DigitsImpl)this.number).decodeData(ais, length);
                this.number.setIsGenericDigits();
                break;
            }
            case 2: {
                this.time = new VariablePartTimeImpl();
                ((VariablePartTimeImpl)this.time).decodeData(ais, length);
                break;
            }
            case 3: {
                this.date = new VariablePartDateImpl();
                ((VariablePartDateImpl)this.date).decodeData(ais, length);
                break;
            }
            case 4: {
                this.price = new VariablePartPriceImpl();
                ((VariablePartPriceImpl)this.price).decodeData(ais, length);
                break;
            }
            default: {
                throw new CAPParsingComponentException("Error while decoding VariablePart: bad tag: " + ais.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding VariablePart: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        int choiceCnt = 0;
        if (this.integer != null) {
            ++choiceCnt;
        }
        if (this.number != null) {
            ++choiceCnt;
        }
        if (this.time != null) {
            ++choiceCnt;
        }
        if (this.date != null) {
            ++choiceCnt;
        }
        if (this.price != null) {
            ++choiceCnt;
        }
        if (choiceCnt != 1) {
            throw new CAPException("Error while encoding VariablePart: only one choice must be definite, found: " + choiceCnt);
        }
        try {
            if (this.integer != null) {
                asnOs.writeIntegerData(this.integer.intValue());
            }
            if (this.number != null) {
                ((DigitsImpl)this.number).encodeData(asnOs);
            }
            if (this.time != null) {
                ((VariablePartTimeImpl)this.time).encodeData(asnOs);
            }
            if (this.date != null) {
                ((VariablePartDateImpl)this.date).encodeData(asnOs);
            }
            if (this.price != null) {
                ((VariablePartPriceImpl)this.price).encodeData(asnOs);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding VariablePart: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.integer != null) {
            sb.append("integer=");
            sb.append(this.integer);
        }
        if (this.number != null) {
            sb.append(" number=");
            sb.append(this.number.toString());
        }
        if (this.time != null) {
            sb.append(" time=");
            sb.append(this.time.toString());
        }
        if (this.date != null) {
            sb.append(" date=");
            sb.append(this.date.toString());
        }
        if (this.price != null) {
            sb.append(" price=");
            sb.append(this.price.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

