/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.congestion;

import javolution.util.FastCollection;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.ss7.congestion.CongestionListener;
import org.mobicents.ss7.congestion.CongestionMonitor;

public class MemoryCongestionMonitor
implements CongestionMonitor {
    private static final Logger logger = Logger.getLogger(MemoryCongestionMonitor.class);
    private static final String SOURCE = "MEMORY";
    private final FastList<CongestionListener> listeners = new FastList();
    private double maxMemory = (double)Runtime.getRuntime().maxMemory() / 1024.0;
    private volatile double percentageOfMemoryUsed;
    private volatile boolean memoryTooHigh = false;
    private int backToNormalMemoryThreshold;
    private int memoryThreshold;

    public void setBackToNormalMemoryThreshold(int backToNormalMemoryThreshold) {
        this.backToNormalMemoryThreshold = backToNormalMemoryThreshold;
        if (logger.isInfoEnabled()) {
            logger.info("Back To Normal Memory threshold set to " + backToNormalMemoryThreshold + "%");
        }
    }

    public int getBackToNormalMemoryThreshold() {
        return this.backToNormalMemoryThreshold;
    }

    public void setMemoryThreshold(int memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
        if (logger.isInfoEnabled()) {
            logger.info("Memory threshold set to " + this.memoryThreshold + "%");
        }
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void monitor() {
        block4: {
            block3: {
                Runtime runtime = Runtime.getRuntime();
                double allocatedMemory = (double)runtime.totalMemory() / 1024.0;
                double freeMemory = (double)runtime.freeMemory() / 1024.0;
                double totalFreeMemory = freeMemory + (this.maxMemory - allocatedMemory);
                this.percentageOfMemoryUsed = 100.0 - totalFreeMemory / this.maxMemory * 100.0;
                if (!this.memoryTooHigh) break block3;
                if (!(this.percentageOfMemoryUsed < (double)this.backToNormalMemoryThreshold)) break block4;
                logger.warn("Memory used: " + this.percentageOfMemoryUsed + "% < to the back to normal memory threshold : " + this.backToNormalMemoryThreshold);
                this.memoryTooHigh = false;
                FastCollection.Record n = this.listeners.head();
                FastCollection.Record end = this.listeners.tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    CongestionListener listener = (CongestionListener)((FastList.Node)n).getValue();
                    listener.onCongestionFinish(SOURCE);
                }
                break block4;
            }
            if (this.percentageOfMemoryUsed > (double)this.memoryThreshold) {
                logger.warn("Memory used: " + this.percentageOfMemoryUsed + "% > to the memory threshold : " + this.memoryThreshold);
                this.memoryTooHigh = true;
                FastCollection.Record n = this.listeners.head();
                FastCollection.Record end = this.listeners.tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    CongestionListener listener = (CongestionListener)((FastList.Node)n).getValue();
                    listener.onCongestionStart(SOURCE);
                }
            }
        }
    }

    public void addCongestionListener(CongestionListener listener) {
        this.listeners.add(listener);
    }

    public void removeCongestionListener(CongestionListener listener) {
        this.listeners.remove(listener);
    }

    public String getSource() {
        return SOURCE;
    }
}

