/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ForwardingFeature;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ForwardingInfo;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSCode;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.supplementary.ForwardingFeatureImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSCodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardingInfoImpl
extends SequenceBase
implements ForwardingInfo {
    private SSCode ssCode;
    private ArrayList<ForwardingFeature> forwardingFeatureList;

    public ForwardingInfoImpl() {
        super("ForwardingInfo");
    }

    public ForwardingInfoImpl(SSCode ssCode, ArrayList<ForwardingFeature> forwardingFeatureList) {
        super("ForwardingInfo");
        this.ssCode = ssCode;
        this.forwardingFeatureList = forwardingFeatureList;
    }

    @Override
    public SSCode getSsCode() {
        return this.ssCode;
    }

    @Override
    public ArrayList<ForwardingFeature> getForwardingFeatureList() {
        return this.forwardingFeatureList;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.ssCode = null;
        this.forwardingFeatureList = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 0) {
                switch (tag) {
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " ssCode: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.ssCode = new SSCodeImpl();
                        ((SSCodeImpl)this.ssCode).decodeAll(ais);
                        continue block4;
                    }
                    case 16: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".forwardingFeatureList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        AsnInputStream ais2 = ais.readSequenceStream();
                        this.forwardingFeatureList = new ArrayList();
                        while (ais2.available() != 0) {
                            ais2.readTag();
                            ForwardingFeatureImpl forwardingFeature = new ForwardingFeatureImpl();
                            forwardingFeature.decodeAll(ais2);
                            this.forwardingFeatureList.add(forwardingFeature);
                        }
                        if (this.forwardingFeatureList.size() >= 1 && this.forwardingFeatureList.size() <= 13) continue block4;
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter forwardingFeatureList size must be from 1 to 13, found: " + this.forwardingFeatureList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (this.forwardingFeatureList == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": forwardingFeatureList parameter is mandatory but has not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.forwardingFeatureList == null) {
            throw new MAPException("forwardingFeatureList parameter must not be null");
        }
        if (this.ssCode != null) {
            ((SSCodeImpl)this.ssCode).encodeAll(asnOs);
        }
        try {
            asnOs.writeTag(0, false, 16);
            int pos = asnOs.StartContentDefiniteLength();
            for (ForwardingFeature item : this.forwardingFeatureList) {
                ((ForwardingFeatureImpl)item).encodeAll(asnOs);
            }
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ".forwardingFeatureList: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.ssCode != null) {
            sb.append("ssCode=");
            sb.append(this.ssCode);
        }
        if (this.forwardingFeatureList != null) {
            sb.append("forwardingFeatureList=[");
            boolean firstItem = true;
            for (ForwardingFeature be : this.forwardingFeatureList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("], ");
        }
        sb.append("]");
        return sb.toString();
    }
}

