/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.LCSInformation;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.LCSPrivacyClass;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.MOLRClass;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.LCSPrivacyClassImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.MOLRClassImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LCSInformationImpl
extends SequenceBase
implements LCSInformation {
    public static final int _TAG_gmlcList = 0;
    public static final int _TAG_lcsPrivacyExceptionList = 1;
    public static final int _TAG_molrList = 2;
    public static final int _TAG_addLcsPrivacyExceptionList = 3;
    private ArrayList<ISDNAddressString> gmlcList;
    private ArrayList<LCSPrivacyClass> lcsPrivacyExceptionList;
    private ArrayList<MOLRClass> molrList;
    private ArrayList<LCSPrivacyClass> addLcsPrivacyExceptionList;

    public LCSInformationImpl() {
        super("LCSInformation");
    }

    public LCSInformationImpl(ArrayList<ISDNAddressString> gmlcList, ArrayList<LCSPrivacyClass> lcsPrivacyExceptionList, ArrayList<MOLRClass> molrList, ArrayList<LCSPrivacyClass> addLcsPrivacyExceptionList) {
        super("LCSInformation");
        this.gmlcList = gmlcList;
        this.lcsPrivacyExceptionList = lcsPrivacyExceptionList;
        this.molrList = molrList;
        this.addLcsPrivacyExceptionList = addLcsPrivacyExceptionList;
    }

    @Override
    public ArrayList<ISDNAddressString> getGmlcList() {
        return this.gmlcList;
    }

    @Override
    public ArrayList<LCSPrivacyClass> getLcsPrivacyExceptionList() {
        return this.lcsPrivacyExceptionList;
    }

    @Override
    public ArrayList<MOLRClass> getMOLRList() {
        return this.molrList;
    }

    @Override
    public ArrayList<LCSPrivacyClass> getAddLcsPrivacyExceptionList() {
        return this.addLcsPrivacyExceptionList;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.gmlcList = null;
        this.lcsPrivacyExceptionList = null;
        this.molrList = null;
        this.addLcsPrivacyExceptionList = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block9: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 2: {
                    switch (tag) {
                        case 0: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".gmlcList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            ISDNAddressStringImpl isdnAddressString = null;
                            AsnInputStream ais2 = ais.readSequenceStream();
                            this.gmlcList = new ArrayList();
                            while (ais2.available() != 0) {
                                int tag2 = ais2.readTag();
                                if (tag2 != 4 || ais2.getTagClass() != 0 || !ais2.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + "ISDNAddressString: bad tag or tagClass or is not primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                isdnAddressString = new ISDNAddressStringImpl();
                                isdnAddressString.decodeAll(ais2);
                                this.gmlcList.add(isdnAddressString);
                            }
                            if (this.gmlcList.size() >= 1 && this.gmlcList.size() <= 5) continue block9;
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter gmlcList size must be from 1 to 5, found: " + this.gmlcList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        case 1: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".lcsPrivacyExceptionList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            LCSPrivacyClassImpl lcsPrivacyClass = null;
                            AsnInputStream ais3 = ais.readSequenceStream();
                            this.lcsPrivacyExceptionList = new ArrayList();
                            while (ais3.available() != 0) {
                                int tag2 = ais3.readTag();
                                if (tag2 != 16 || ais3.getTagClass() != 0 || ais3.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + "LCSPrivacyClass: bad tag or tagClass or is primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                lcsPrivacyClass = new LCSPrivacyClassImpl();
                                lcsPrivacyClass.decodeAll(ais3);
                                this.lcsPrivacyExceptionList.add(lcsPrivacyClass);
                            }
                            if (this.lcsPrivacyExceptionList.size() >= 1 && this.lcsPrivacyExceptionList.size() <= 4) continue block9;
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter lcsPrivacyExceptionList size must be from 1 to 4, found: " + this.lcsPrivacyExceptionList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        case 2: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".molrList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            MOLRClassImpl molrClass = null;
                            AsnInputStream ais4 = ais.readSequenceStream();
                            this.molrList = new ArrayList();
                            while (ais4.available() != 0) {
                                int tag2 = ais4.readTag();
                                if (tag2 != 16 || ais4.getTagClass() != 0 || ais4.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + "molrClass: bad tag or tagClass or is primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                molrClass = new MOLRClassImpl();
                                molrClass.decodeAll(ais4);
                                this.molrList.add(molrClass);
                            }
                            if (this.molrList.size() >= 1 && this.molrList.size() <= 3) continue block9;
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter molrList size must be from 1 to 3, found: " + this.molrList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        case 3: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".specificAPNInfoList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            LCSPrivacyClassImpl addLcsPrivacyClass = null;
                            AsnInputStream ais5 = ais.readSequenceStream();
                            this.addLcsPrivacyExceptionList = new ArrayList();
                            while (ais5.available() != 0) {
                                int tag2 = ais5.readTag();
                                if (tag2 != 16 || ais5.getTagClass() != 0 || ais5.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + "addLcsPrivacyClass: bad tag or tagClass or is primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                addLcsPrivacyClass = new LCSPrivacyClassImpl();
                                addLcsPrivacyClass.decodeAll(ais5);
                                this.addLcsPrivacyExceptionList.add(addLcsPrivacyClass);
                            }
                            if (this.addLcsPrivacyExceptionList.size() >= 1 && this.addLcsPrivacyExceptionList.size() <= 4) continue block9;
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter addLcsPrivacyExceptionList size must be from 1 to 4, found: " + this.addLcsPrivacyExceptionList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                    }
                    ais.advanceElement();
                    continue block9;
                }
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.gmlcList != null && (this.gmlcList.size() < 1 || this.gmlcList.size() > 5)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter gmlcList size must be from 1 to 5, found: " + this.gmlcList.size());
        }
        if (this.lcsPrivacyExceptionList != null && (this.lcsPrivacyExceptionList.size() < 1 || this.lcsPrivacyExceptionList.size() > 4)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter lcsPrivacyExceptionList size must be from 1 to 4, found: " + this.lcsPrivacyExceptionList.size());
        }
        if (this.molrList != null && (this.molrList.size() < 1 || this.molrList.size() > 3)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter molrList size must be from 1 to 3, found: " + this.molrList.size());
        }
        if (this.addLcsPrivacyExceptionList != null && (this.addLcsPrivacyExceptionList.size() < 1 || this.addLcsPrivacyExceptionList.size() > 4)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter addLcsPrivacyExceptionList size must be from 1 to 4, found: " + this.addLcsPrivacyExceptionList.size());
        }
        if (this.addLcsPrivacyExceptionList != null && (this.lcsPrivacyExceptionList == null || this.lcsPrivacyExceptionList.size() != 4)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": addLcsPrivacyExceptionList may be sent only if" + " lcsPrivacyExceptionList is present and contains four instances of LCSPrivacyClass");
        }
        try {
            int pos;
            if (this.gmlcList != null) {
                asnOs.writeTag(2, false, 0);
                pos = asnOs.StartContentDefiniteLength();
                for (ISDNAddressString isdnAddressString : this.gmlcList) {
                    ((ISDNAddressStringImpl)isdnAddressString).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
            if (this.lcsPrivacyExceptionList != null) {
                asnOs.writeTag(2, false, 1);
                pos = asnOs.StartContentDefiniteLength();
                for (LCSPrivacyClass lcsPrivacyClass : this.lcsPrivacyExceptionList) {
                    ((LCSPrivacyClassImpl)lcsPrivacyClass).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
            if (this.molrList != null) {
                asnOs.writeTag(2, false, 2);
                pos = asnOs.StartContentDefiniteLength();
                for (MOLRClass molrClass : this.molrList) {
                    ((MOLRClassImpl)molrClass).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
            if (this.addLcsPrivacyExceptionList != null) {
                asnOs.writeTag(2, false, 3);
                pos = asnOs.StartContentDefiniteLength();
                for (LCSPrivacyClass lcsPrivacyClass : this.addLcsPrivacyExceptionList) {
                    ((LCSPrivacyClassImpl)lcsPrivacyClass).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        boolean firstItem;
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.gmlcList != null) {
            sb.append("gmlcList=[");
            firstItem = true;
            for (ISDNAddressString iSDNAddressString : this.gmlcList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(iSDNAddressString.toString());
            }
            sb.append("], ");
        }
        if (this.lcsPrivacyExceptionList != null) {
            sb.append("lcsPrivacyExceptionList=[");
            firstItem = true;
            for (LCSPrivacyClass lCSPrivacyClass : this.lcsPrivacyExceptionList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(lCSPrivacyClass.toString());
            }
            sb.append("], ");
        }
        if (this.molrList != null) {
            sb.append("molrList=[");
            firstItem = true;
            for (MOLRClass mOLRClass : this.molrList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(mOLRClass.toString());
            }
            sb.append("], ");
        }
        if (this.addLcsPrivacyExceptionList != null) {
            sb.append("addLcsPrivacyExceptionList=[");
            firstItem = true;
            for (LCSPrivacyClass lCSPrivacyClass : this.addLcsPrivacyExceptionList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(lCSPrivacyClass.toString());
            }
            sb.append("] ");
        }
        sb.append("]");
        return sb.toString();
    }
}

