/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.EMLPPPriority;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.LMSI;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.ProvideSubscriberInfoRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.RequestedInfo;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.LMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MobilityMessageImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.RequestedInfoImpl;

public class ProvideSubscriberInfoRequestImpl
extends MobilityMessageImpl
implements ProvideSubscriberInfoRequest {
    protected static final int _TAG_imsi = 0;
    protected static final int _TAG_lmsi = 1;
    protected static final int _TAG_requestedInfo = 2;
    protected static final int _TAG_extensionContainer = 3;
    protected static final int _TAG_callPriority = 4;
    public static final String _PrimitiveName = "ProvideSubscriberInfoRequest";
    private IMSI imsi;
    private LMSI lmsi;
    private RequestedInfo requestedInfo;
    private MAPExtensionContainer extensionContainer;
    private EMLPPPriority callPriority;

    public ProvideSubscriberInfoRequestImpl() {
    }

    public ProvideSubscriberInfoRequestImpl(IMSI imsi, LMSI lmsi, RequestedInfo requestedInfo, MAPExtensionContainer extensionContainer, EMLPPPriority callPriority) {
        this.imsi = imsi;
        this.lmsi = lmsi;
        this.requestedInfo = requestedInfo;
        this.extensionContainer = extensionContainer;
        this.callPriority = callPriority;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.provideSubscriberInfo_Request;
    }

    public int getOperationCode() {
        return 70;
    }

    public IMSI getImsi() {
        return this.imsi;
    }

    public LMSI getLmsi() {
        return this.lmsi;
    }

    public RequestedInfo getRequestedInfo() {
        return this.requestedInfo;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public EMLPPPriority getCallPriority() {
        return this.callPriority;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ProvideSubscriberInfoRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ProvideSubscriberInfoRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ProvideSubscriberInfoRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ProvideSubscriberInfoRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imsi = null;
        this.lmsi = null;
        this.requestedInfo = null;
        this.extensionContainer = null;
        this.callPriority = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberInfoRequest.imsi: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.imsi = new IMSIImpl();
                        ((IMSIImpl)this.imsi).decodeAll(ais);
                        break;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberInfoRequest.lmsi: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.lmsi = new LMSIImpl();
                        ((LMSIImpl)this.lmsi).decodeAll(ais);
                        break;
                    }
                    case 2: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberInfoRequest.requestedInfo: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.requestedInfo = new RequestedInfoImpl();
                        ((RequestedInfoImpl)this.requestedInfo).decodeAll(ais);
                        break;
                    }
                    case 3: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberInfoRequest.extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        break;
                    }
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberInfoRequest.callPriority: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.callPriority = EMLPPPriority.getEMLPPPriority(i1);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
            } else {
                ais.advanceElement();
            }
            ++num;
        }
        if (this.imsi == null) {
            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberInfoRequest: Parameter imsi is mandator but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.requestedInfo == null) {
            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberInfoRequest: Parameter requestedInfo is mandator but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ProvideSubscriberInfoRequest: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.imsi == null) {
                throw new MAPException("IMSI parameter must not be null");
            }
            if (this.requestedInfo == null) {
                throw new MAPException("requestedInfo parameter must not be null");
            }
            ((IMSIImpl)this.imsi).encodeAll(asnOs, 2, 0);
            if (this.lmsi != null) {
                ((LMSIImpl)this.lmsi).encodeAll(asnOs, 2, 1);
            }
            ((RequestedInfoImpl)this.requestedInfo).encodeAll(asnOs, 2, 2);
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 3);
            }
            if (this.callPriority != null) {
                asnOs.writeInteger(2, 4, this.callPriority.getCode());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding ProvideSubscriberInfoRequest: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ProvideSubscriberInfoRequest: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.imsi != null) {
            sb.append("imsi=");
            sb.append(this.imsi);
            sb.append(", ");
        }
        if (this.lmsi != null) {
            sb.append("lmsi=");
            sb.append(this.lmsi);
            sb.append(", ");
        }
        if (this.requestedInfo != null) {
            sb.append("requestedInfo=");
            sb.append(this.requestedInfo);
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer);
            sb.append(", ");
        }
        if (this.callPriority != null) {
            sb.append("callPriority=");
            sb.append((Object)this.callPriority);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

