/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.isup.CauseCap;
import org.mobicents.protocols.ss7.cap.api.primitives.DateAndTime;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.RequestedInformation;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.RequestedInformationType;
import org.mobicents.protocols.ss7.cap.isup.CauseCapImpl;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.cap.primitives.DateAndTimeImpl;

public class RequestedInformationImpl
implements RequestedInformation,
CAPAsnPrimitive {
    public static final int _ID_requestedInformationType = 0;
    public static final int _ID_requestedInformationValue = 1;
    public static final int _ID_callAttemptElapsedTimeValue = 0;
    public static final int _ID_callStopTimeValue = 1;
    public static final int _ID_callConnectedElapsedTimeValue = 2;
    public static final int _ID_releaseCauseValue = 30;
    public static final String _PrimitiveName = "RequestedInformation";
    private RequestedInformationType requestedInformationType;
    private Integer callAttemptElapsedTimeValue;
    private DateAndTime callStopTimeValue;
    private Integer callConnectedElapsedTimeValue;
    private CauseCap releaseCauseValue;

    public RequestedInformationImpl() {
    }

    public RequestedInformationImpl(RequestedInformationType requestedInformationType, int intValue) {
        if (requestedInformationType == RequestedInformationType.callAttemptElapsedTime) {
            this.requestedInformationType = RequestedInformationType.callAttemptElapsedTime;
            this.callAttemptElapsedTimeValue = intValue;
        } else {
            this.requestedInformationType = RequestedInformationType.callConnectedElapsedTime;
            this.callConnectedElapsedTimeValue = intValue;
        }
    }

    public RequestedInformationImpl(DateAndTime callStopTimeValue) {
        this.requestedInformationType = RequestedInformationType.callStopTime;
        this.callStopTimeValue = callStopTimeValue;
    }

    public RequestedInformationImpl(CauseCap releaseCauseValue) {
        this.requestedInformationType = RequestedInformationType.releaseCause;
        this.releaseCauseValue = releaseCauseValue;
    }

    public RequestedInformationType getRequestedInformationType() {
        return this.requestedInformationType;
    }

    public Integer getCallAttemptElapsedTimeValue() {
        return this.callAttemptElapsedTimeValue;
    }

    public DateAndTime getCallStopTimeValue() {
        return this.callStopTimeValue;
    }

    public Integer getCallConnectedElapsedTimeValue() {
        return this.callConnectedElapsedTimeValue;
    }

    public CauseCap getReleaseCauseValue() {
        return this.releaseCauseValue;
    }

    public int getTag() throws CAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding RequestedInformation: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding RequestedInformation: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding RequestedInformation: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding RequestedInformation: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.requestedInformationType = null;
        this.callAttemptElapsedTimeValue = null;
        this.callStopTimeValue = null;
        this.callConnectedElapsedTimeValue = null;
        this.releaseCauseValue = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        boolean valueReceived = false;
        block10: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                block0 : switch (tag) {
                    case 0: {
                        int i1 = (int)ais.readInteger();
                        this.requestedInformationType = RequestedInformationType.getInstance(i1);
                        break;
                    }
                    case 1: {
                        valueReceived = true;
                        AsnInputStream ais2 = ais.readSequenceStream();
                        int tag2 = ais2.readTag();
                        if (ais2.getTagClass() != 2) {
                            throw new CAPParsingComponentException("Error while decoding RequestedInformation: bad RequestedInformationValue tagClass", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        switch (tag2) {
                            case 0: {
                                this.callAttemptElapsedTimeValue = (int)ais2.readInteger();
                                break block0;
                            }
                            case 1: {
                                this.callStopTimeValue = new DateAndTimeImpl();
                                ((DateAndTimeImpl)this.callStopTimeValue).decodeAll(ais2);
                                break block0;
                            }
                            case 2: {
                                this.callConnectedElapsedTimeValue = (int)ais2.readInteger();
                                break block0;
                            }
                            case 30: {
                                this.releaseCauseValue = new CauseCapImpl();
                                ((CauseCapImpl)this.releaseCauseValue).decodeAll(ais2);
                                break block0;
                            }
                        }
                        if (ais2.getTagClass() == 2) continue block10;
                        throw new CAPParsingComponentException("Error while decoding RequestedInformation: bad RequestedInformationValue tag", CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.requestedInformationType == null || !valueReceived) {
            throw new CAPParsingComponentException("Error while decoding RequestedInformation: requestedInformationType and requestedInformationValue are mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding RequestedInformation: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.requestedInformationType == null) {
            throw new CAPException("Error while encoding RequestedInformation: requestedInformationType must not be null");
        }
        try {
            aos.writeInteger(2, 0, this.requestedInformationType.getCode());
            aos.writeTag(2, false, 1);
            int pos = aos.StartContentDefiniteLength();
            switch (this.requestedInformationType) {
                case callAttemptElapsedTime: {
                    if (this.callAttemptElapsedTimeValue == null) {
                        throw new CAPException("Error while encoding RequestedInformation: callAttemptElapsedTimeValue must not be null for " + this.requestedInformationType.toString() + " requestedInformationType");
                    }
                    aos.writeInteger(2, 0, this.callAttemptElapsedTimeValue.intValue());
                    break;
                }
                case callStopTime: {
                    if (this.callStopTimeValue == null) {
                        throw new CAPException("Error while encoding RequestedInformation: callStopTimeValue must not be null for " + this.requestedInformationType.toString() + " requestedInformationType");
                    }
                    ((DateAndTimeImpl)this.callStopTimeValue).encodeAll(aos, 2, 1);
                    break;
                }
                case callConnectedElapsedTime: {
                    if (this.callConnectedElapsedTimeValue == null) {
                        throw new CAPException("Error while encoding RequestedInformation: callConnectedElapsedTimeValue must not be null for " + this.requestedInformationType.toString() + " requestedInformationType");
                    }
                    aos.writeInteger(2, 2, this.callConnectedElapsedTimeValue.intValue());
                    break;
                }
                case releaseCause: {
                    if (this.releaseCauseValue == null) {
                        throw new CAPException("Error while encoding RequestedInformation: releaseCauseValue must not be null for " + this.requestedInformationType.toString() + " requestedInformationType");
                    }
                    ((CauseCapImpl)this.releaseCauseValue).encodeAll(aos, 2, 30);
                    break;
                }
                default: {
                    throw new CAPException("Error while encoding RequestedInformation: bad requestedInformationType value");
                }
            }
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding RequestedInformation: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding RequestedInformation: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.requestedInformationType != null) {
            sb.append("requestedInformationType=");
            sb.append((Object)this.requestedInformationType);
        }
        if (this.callAttemptElapsedTimeValue != null) {
            sb.append(", callAttemptElapsedTimeValue=");
            sb.append(this.callAttemptElapsedTimeValue);
        }
        if (this.callStopTimeValue != null) {
            sb.append(", callStopTimeValue=");
            sb.append(this.callStopTimeValue.toString());
        }
        if (this.callConnectedElapsedTimeValue != null) {
            sb.append(", callConnectedElapsedTimeValue=");
            sb.append(this.callConnectedElapsedTimeValue);
        }
        if (this.releaseCauseValue != null) {
            sb.append(", releaseCauseValue=");
            sb.append(this.releaseCauseValue.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

