/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.ErrorTreatment;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.CollectedDigits;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ByteArrayContainer;

public class CollectedDigitsImpl
extends SequenceBase
implements CollectedDigits {
    public static final int _ID_minimumNbOfDigits = 0;
    public static final int _ID_maximumNbOfDigits = 1;
    public static final int _ID_endOfReplyDigit = 2;
    public static final int _ID_cancelDigit = 3;
    public static final int _ID_startDigit = 4;
    public static final int _ID_firstDigitTimeOut = 5;
    public static final int _ID_interDigitTimeOut = 6;
    public static final int _ID_errorTreatment = 7;
    public static final int _ID_interruptableAnnInd = 8;
    public static final int _ID_voiceInformation = 9;
    public static final int _ID_voiceBack = 10;
    private static final String MINIMUM_NB_OF_DIGITS = "minimumNbOfDigits";
    private static final String MAXIMUM_NB_OF_DIGITS = "maximumNbOfDigits";
    private static final String END_OF_REPLY_DIGIT = "endOfReplyDigit";
    private static final String CANCEL_DIGIT = "cancelDigit";
    private static final String START_DIGIT = "startDigit";
    private static final String FIRST_DIGIT_TIME_OUT = "firstDigitTimeOut";
    private static final String INTER_DIGIT_TIME_OUT = "interDigitTimeOut";
    private static final String ERROR_TREATMENT = "errorTreatment";
    private static final String INTERRUPTABLE_ANN_IND = "interruptableAnnInd";
    private static final String VOICE_INFORMATION = "voiceInformation";
    private static final String VOICE_BACK = "voiceBack";
    private Integer minimumNbOfDigits;
    private int maximumNbOfDigits;
    private byte[] endOfReplyDigit;
    private byte[] cancelDigit;
    private byte[] startDigit;
    private Integer firstDigitTimeOut;
    private Integer interDigitTimeOut;
    private ErrorTreatment errorTreatment;
    private Boolean interruptableAnnInd;
    private Boolean voiceInformation;
    private Boolean voiceBack;
    protected static final XMLFormat<CollectedDigitsImpl> COLLECTED_DIGITS_XML = new XMLFormat<CollectedDigitsImpl>(CollectedDigitsImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, CollectedDigitsImpl collectedDigits) throws XMLStreamException {
            ByteArrayContainer bc;
            String vals;
            int vali = xml.getAttribute(CollectedDigitsImpl.MINIMUM_NB_OF_DIGITS, -1);
            if (vali != -1) {
                collectedDigits.minimumNbOfDigits = vali;
            }
            collectedDigits.maximumNbOfDigits = xml.getAttribute(CollectedDigitsImpl.MAXIMUM_NB_OF_DIGITS, 1);
            vali = xml.getAttribute(CollectedDigitsImpl.FIRST_DIGIT_TIME_OUT, -1);
            if (vali != -1) {
                collectedDigits.firstDigitTimeOut = vali;
            }
            if ((vali = xml.getAttribute(CollectedDigitsImpl.INTER_DIGIT_TIME_OUT, -1)) != -1) {
                collectedDigits.interDigitTimeOut = vali;
            }
            if ((vals = xml.getAttribute(CollectedDigitsImpl.ERROR_TREATMENT, "")) != null && vals.length() > 0) {
                collectedDigits.errorTreatment = Enum.valueOf(ErrorTreatment.class, vals);
            }
            if ((vals = xml.getAttribute(CollectedDigitsImpl.INTERRUPTABLE_ANN_IND, "")) != null && vals.length() > 0) {
                collectedDigits.interruptableAnnInd = Boolean.valueOf(vals);
            }
            if ((vals = xml.getAttribute(CollectedDigitsImpl.VOICE_INFORMATION, "")) != null && vals.length() > 0) {
                collectedDigits.voiceInformation = Boolean.valueOf(vals);
            }
            if ((vals = xml.getAttribute(CollectedDigitsImpl.VOICE_BACK, "")) != null && vals.length() > 0) {
                collectedDigits.voiceBack = Boolean.valueOf(vals);
            }
            if ((bc = xml.get(CollectedDigitsImpl.END_OF_REPLY_DIGIT, ByteArrayContainer.class)) != null) {
                CollectedDigitsImpl.access$802(collectedDigits, bc.getData());
            }
            if ((bc = xml.get(CollectedDigitsImpl.CANCEL_DIGIT, ByteArrayContainer.class)) != null) {
                CollectedDigitsImpl.access$902(collectedDigits, bc.getData());
            }
            if ((bc = xml.get(CollectedDigitsImpl.START_DIGIT, ByteArrayContainer.class)) != null) {
                CollectedDigitsImpl.access$1002(collectedDigits, bc.getData());
            }
        }

        @Override
        public void write(CollectedDigitsImpl collectedDigits, XMLFormat.OutputElement xml) throws XMLStreamException {
            ByteArrayContainer bac;
            if (collectedDigits.minimumNbOfDigits != null) {
                xml.setAttribute(CollectedDigitsImpl.MINIMUM_NB_OF_DIGITS, collectedDigits.minimumNbOfDigits);
            }
            xml.setAttribute(CollectedDigitsImpl.MAXIMUM_NB_OF_DIGITS, collectedDigits.maximumNbOfDigits);
            if (collectedDigits.firstDigitTimeOut != null) {
                xml.setAttribute(CollectedDigitsImpl.FIRST_DIGIT_TIME_OUT, collectedDigits.firstDigitTimeOut);
            }
            if (collectedDigits.interDigitTimeOut != null) {
                xml.setAttribute(CollectedDigitsImpl.INTER_DIGIT_TIME_OUT, collectedDigits.interDigitTimeOut);
            }
            if (collectedDigits.errorTreatment != null) {
                xml.setAttribute(CollectedDigitsImpl.ERROR_TREATMENT, collectedDigits.errorTreatment.toString());
            }
            if (collectedDigits.interruptableAnnInd != null) {
                xml.setAttribute(CollectedDigitsImpl.INTERRUPTABLE_ANN_IND, collectedDigits.interruptableAnnInd);
            }
            if (collectedDigits.voiceInformation != null) {
                xml.setAttribute(CollectedDigitsImpl.VOICE_INFORMATION, collectedDigits.voiceInformation);
            }
            if (collectedDigits.voiceBack != null) {
                xml.setAttribute(CollectedDigitsImpl.VOICE_BACK, collectedDigits.voiceBack);
            }
            if (collectedDigits.endOfReplyDigit != null) {
                bac = new ByteArrayContainer(collectedDigits.endOfReplyDigit);
                xml.add(bac, CollectedDigitsImpl.END_OF_REPLY_DIGIT, ByteArrayContainer.class);
            }
            if (collectedDigits.cancelDigit != null) {
                bac = new ByteArrayContainer(collectedDigits.cancelDigit);
                xml.add(bac, CollectedDigitsImpl.CANCEL_DIGIT, ByteArrayContainer.class);
            }
            if (collectedDigits.startDigit != null) {
                bac = new ByteArrayContainer(collectedDigits.startDigit);
                xml.add(bac, CollectedDigitsImpl.START_DIGIT, ByteArrayContainer.class);
            }
        }
    };

    public CollectedDigitsImpl() {
        super("CollectedDigits");
    }

    public CollectedDigitsImpl(Integer minimumNbOfDigits, int maximumNbOfDigits, byte[] endOfReplyDigit, byte[] cancelDigit, byte[] startDigit, Integer firstDigitTimeOut, Integer interDigitTimeOut, ErrorTreatment errorTreatment, Boolean interruptableAnnInd, Boolean voiceInformation, Boolean voiceBack) {
        super("CollectedDigits");
        this.minimumNbOfDigits = minimumNbOfDigits;
        this.maximumNbOfDigits = maximumNbOfDigits;
        this.endOfReplyDigit = endOfReplyDigit;
        this.cancelDigit = cancelDigit;
        this.startDigit = startDigit;
        this.firstDigitTimeOut = firstDigitTimeOut;
        this.interDigitTimeOut = interDigitTimeOut;
        this.errorTreatment = errorTreatment;
        this.interruptableAnnInd = interruptableAnnInd;
        this.voiceInformation = voiceInformation;
        this.voiceBack = voiceBack;
    }

    public Integer getMinimumNbOfDigits() {
        return this.minimumNbOfDigits;
    }

    public int getMaximumNbOfDigits() {
        return this.maximumNbOfDigits;
    }

    public byte[] getEndOfReplyDigit() {
        return this.endOfReplyDigit;
    }

    public byte[] getCancelDigit() {
        return this.cancelDigit;
    }

    public byte[] getStartDigit() {
        return this.startDigit;
    }

    public Integer getFirstDigitTimeOut() {
        return this.firstDigitTimeOut;
    }

    public Integer getInterDigitTimeOut() {
        return this.interDigitTimeOut;
    }

    public ErrorTreatment getErrorTreatment() {
        return this.errorTreatment;
    }

    public Boolean getInterruptableAnnInd() {
        return this.interruptableAnnInd;
    }

    public Boolean getVoiceInformation() {
        return this.voiceInformation;
    }

    public Boolean getVoiceBack() {
        return this.voiceBack;
    }

    protected void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.minimumNbOfDigits = null;
        this.maximumNbOfDigits = -1;
        this.endOfReplyDigit = null;
        this.cancelDigit = null;
        this.startDigit = null;
        this.firstDigitTimeOut = null;
        this.interDigitTimeOut = null;
        this.errorTreatment = null;
        this.interruptableAnnInd = null;
        this.voiceInformation = null;
        this.voiceBack = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.minimumNbOfDigits = (int)ais.readInteger();
                        break;
                    }
                    case 1: {
                        this.maximumNbOfDigits = (int)ais.readInteger();
                        break;
                    }
                    case 2: {
                        this.endOfReplyDigit = ais.readOctetString();
                        break;
                    }
                    case 3: {
                        this.cancelDigit = ais.readOctetString();
                        break;
                    }
                    case 4: {
                        this.startDigit = ais.readOctetString();
                        break;
                    }
                    case 5: {
                        this.firstDigitTimeOut = (int)ais.readInteger();
                        break;
                    }
                    case 6: {
                        this.interDigitTimeOut = (int)ais.readInteger();
                        break;
                    }
                    case 7: {
                        int i1 = (int)ais.readInteger();
                        this.errorTreatment = ErrorTreatment.getInstance(i1);
                        break;
                    }
                    case 8: {
                        this.interruptableAnnInd = ais.readBoolean();
                        break;
                    }
                    case 9: {
                        this.voiceInformation = ais.readBoolean();
                        break;
                    }
                    case 10: {
                        this.voiceBack = ais.readBoolean();
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.maximumNbOfDigits == -1) {
            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": maximumNbOfDigits is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        try {
            if (this.minimumNbOfDigits != null) {
                if (this.minimumNbOfDigits < 1 || this.minimumNbOfDigits > 30) {
                    throw new CAPException("Error while encoding " + this._PrimitiveName + ": minimumNbOfDigits must have value from 1 to 30");
                }
                aos.writeInteger(2, 0, this.minimumNbOfDigits.intValue());
            }
            if (this.maximumNbOfDigits < 1 || this.maximumNbOfDigits > 30) {
                throw new CAPException("Error while encoding " + this._PrimitiveName + ": maximumNbOfDigits must have value from 1 to 30");
            }
            aos.writeInteger(2, 1, this.maximumNbOfDigits);
            if (this.endOfReplyDigit != null) {
                if (this.endOfReplyDigit.length < 1 || this.endOfReplyDigit.length > 2) {
                    throw new CAPException("Error while encoding " + this._PrimitiveName + ": endOfReplyDigit length must be from 1 to 2");
                }
                aos.writeOctetString(2, 2, this.endOfReplyDigit);
            }
            if (this.cancelDigit != null) {
                if (this.cancelDigit.length < 1 || this.cancelDigit.length > 2) {
                    throw new CAPException("Error while encoding " + this._PrimitiveName + ": cancelDigit length must be from 1 to 2");
                }
                aos.writeOctetString(2, 3, this.cancelDigit);
            }
            if (this.startDigit != null) {
                if (this.startDigit.length < 1 || this.startDigit.length > 2) {
                    throw new CAPException("Error while encoding " + this._PrimitiveName + ": startDigit length must be from 1 to 2");
                }
                aos.writeOctetString(2, 4, this.startDigit);
            }
            if (this.firstDigitTimeOut != null) {
                if (this.firstDigitTimeOut < 1 || this.firstDigitTimeOut > 127) {
                    throw new CAPException("Error while encoding " + this._PrimitiveName + ": firstDigitTimeOut must have value from 1 to 127");
                }
                aos.writeInteger(2, 5, this.firstDigitTimeOut.intValue());
            }
            if (this.interDigitTimeOut != null) {
                if (this.interDigitTimeOut < 1 || this.interDigitTimeOut > 127) {
                    throw new CAPException("Error while encoding " + this._PrimitiveName + ": interDigitTimeOut must have value from 1 to 127");
                }
                aos.writeInteger(2, 6, this.interDigitTimeOut.intValue());
            }
            if (this.errorTreatment != null) {
                aos.writeInteger(2, 7, this.errorTreatment.getCode());
            }
            if (this.interruptableAnnInd != null) {
                aos.writeBoolean(2, 8, this.interruptableAnnInd);
            }
            if (this.voiceInformation != null) {
                aos.writeBoolean(2, 9, this.voiceInformation);
            }
            if (this.voiceBack != null) {
                aos.writeBoolean(2, 10, this.voiceBack);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.minimumNbOfDigits != null) {
            sb.append("minimumNbOfDigits=");
            sb.append(this.minimumNbOfDigits);
        }
        sb.append(", maximumNbOfDigits=");
        sb.append(this.maximumNbOfDigits);
        if (this.endOfReplyDigit != null) {
            sb.append(", endOfReplyDigit=[");
            sb.append(this.printDataArr(this.endOfReplyDigit));
            sb.append("]");
        }
        if (this.cancelDigit != null) {
            sb.append(", cancelDigit=[");
            sb.append(this.printDataArr(this.cancelDigit));
            sb.append("]");
        }
        if (this.startDigit != null) {
            sb.append(", startDigit=[");
            sb.append(this.printDataArr(this.startDigit));
            sb.append("]");
        }
        if (this.firstDigitTimeOut != null) {
            sb.append(", firstDigitTimeOut=");
            sb.append(this.firstDigitTimeOut);
        }
        if (this.interDigitTimeOut != null) {
            sb.append(", interDigitTimeOut=");
            sb.append(this.interDigitTimeOut);
        }
        if (this.errorTreatment != null) {
            sb.append(", errorTreatment=");
            sb.append(this.errorTreatment.toString());
        }
        if (this.interruptableAnnInd != null) {
            sb.append(", interruptableAnnInd=");
            sb.append(this.interruptableAnnInd);
        }
        if (this.voiceInformation != null) {
            sb.append(", voiceInformation=");
            sb.append(this.voiceInformation);
        }
        if (this.voiceBack != null) {
            sb.append(", voiceBack=");
            sb.append(this.voiceBack);
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }

    static /* synthetic */ byte[] access$802(CollectedDigitsImpl x0, byte[] x1) {
        x0.endOfReplyDigit = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$902(CollectedDigitsImpl x0, byte[] x1) {
        x0.cancelDigit = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$1002(CollectedDigitsImpl x0, byte[] x1) {
        x0.startDigit = x1;
        return x1;
    }
}

