/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.router;

import java.util.Comparator;
import org.restcomm.protocols.ss7.sccp.OriginationType;
import org.restcomm.protocols.ss7.sccp.impl.router.RuleImpl;

public class RuleComparator
implements Comparator<RuleImpl> {
    private static final String SECTION_SEPARTOR = "/";
    private static final char WILDCARD_ANY = '*';
    private static final String WILDCARD_ANY_STRING = "*";
    private static final char WILDCARD_SINGLE = '?';

    @Override
    public int compare(RuleImpl o1, RuleImpl o2) {
        String digits1 = o1.getPattern().getGlobalTitle().getDigits();
        String digits2 = o2.getPattern().getGlobalTitle().getDigits();
        digits1 = digits1.replaceAll(SECTION_SEPARTOR, "");
        digits2 = digits2.replaceAll(SECTION_SEPARTOR, "");
        if (o1.getOriginationType() != OriginationType.ALL && o2.getOriginationType() == OriginationType.ALL) {
            return -1;
        }
        if (o1.getOriginationType() == OriginationType.ALL && o2.getOriginationType() != OriginationType.ALL) {
            return 1;
        }
        if (digits1.equals(digits2) && (o1.getPatternCallingAddress() != null || o2.getPatternCallingAddress() != null)) {
            if (o1.getPatternCallingAddress() != null && o2.getPatternCallingAddress() == null) {
                return -1;
            }
            if (o1.getPatternCallingAddress() == null && o2.getPatternCallingAddress() != null) {
                return 1;
            }
            digits1 = o1.getPatternCallingAddress().getGlobalTitle().getDigits();
            digits2 = o2.getPatternCallingAddress().getGlobalTitle().getDigits();
            digits1 = digits1.replaceAll(SECTION_SEPARTOR, "");
            digits2 = digits2.replaceAll(SECTION_SEPARTOR, "");
            return this.compareDigits(digits1, digits2);
        }
        return this.compareDigits(digits1, digits2);
    }

    private int compareDigits(String digits1, String digits2) {
        int asterisksFound2;
        if (digits1.equals(WILDCARD_ANY_STRING)) {
            return 1;
        }
        if (digits2.equals(WILDCARD_ANY_STRING)) {
            return -1;
        }
        int asterisksFound1 = this.numberOfAsterisks(digits1);
        if (asterisksFound1 == (asterisksFound2 = this.numberOfAsterisks(digits2))) {
            return this.compareQuestionMarks(digits1, digits2);
        }
        if (asterisksFound1 < asterisksFound2) {
            return -1;
        }
        return digits1.compareTo(digits2);
    }

    private int compareQuestionMarks(String digits1, String digits2) {
        int questionMarksFound2;
        int questionMarksFound1 = this.numberOfQuestionMarks(digits1);
        if (questionMarksFound1 == (questionMarksFound2 = this.numberOfQuestionMarks(digits2))) {
            return this.compareQuestionMarksIndex(digits1, 0, digits2, 0);
        }
        if (questionMarksFound1 < questionMarksFound2) {
            return -1;
        }
        return 1;
    }

    private int compareQuestionMarksIndex(String digits1, int fromIndex1, String digits2, int fromIndex2) {
        int index1 = digits1.indexOf(63, fromIndex1);
        int index2 = digits2.indexOf(63, fromIndex2);
        if (index1 == -1 && index2 == -1) {
            return this.comapreLength(digits1, digits2);
        }
        if (index1 == index2) {
            this.compareQuestionMarksIndex(digits1, index1 + 1, digits2, index2 + 1);
        } else if (index1 < index2) {
            return 1;
        }
        return -1;
    }

    private int comapreLength(String digits1, String digits2) {
        if (digits1.length() == digits2.length()) {
            return 0;
        }
        if (digits1.length() < digits2.length()) {
            return 1;
        }
        if (digits1.length() > digits2.length()) {
            return -1;
        }
        return digits1.compareTo(digits2);
    }

    private int numberOfAsterisks(String digits) {
        int asterisksFound = 0;
        char[] chars = digits.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '*') continue;
            ++asterisksFound;
        }
        return asterisksFound;
    }

    private int numberOfQuestionMarks(String digits) {
        int questionMarksFound = 0;
        char[] chars = digits.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '?') continue;
            ++questionMarksFound;
        }
        return questionMarksFound;
    }
}

