/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.parameter.AbstractParameter;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.parameter.HopCounter;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;

public class HopCounterImpl
extends AbstractParameter
implements HopCounter {
    private int value;

    public HopCounterImpl(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            if (in.read() != 1) {
                throw new ParseException();
            }
            this.value = in.read() & 0xF;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe);
        }
    }

    @Override
    public void encode(OutputStream os, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            os.write(1);
            os.write(this.value & 0xF);
        }
        catch (IOException ioe) {
            throw new ParseException(ioe);
        }
    }

    @Override
    public void decode(byte[] b, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        this.value = b[0] & 0xF;
    }

    @Override
    public byte[] encode(boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        return new byte[]{(byte)(this.value & 0xF)};
    }
}

