/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.smstpdu;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.smstpdu.AddressField;
import org.restcomm.protocols.ss7.map.api.smstpdu.NumberingPlanIdentification;
import org.restcomm.protocols.ss7.map.api.smstpdu.TypeOfNumber;
import org.restcomm.protocols.ss7.map.datacoding.GSMCharset;
import org.restcomm.protocols.ss7.map.datacoding.GSMCharsetDecoder;
import org.restcomm.protocols.ss7.map.datacoding.GSMCharsetDecodingData;
import org.restcomm.protocols.ss7.map.datacoding.GSMCharsetEncoder;
import org.restcomm.protocols.ss7.map.datacoding.Gsm7EncodingStyle;
import org.restcomm.protocols.ss7.map.primitives.TbcdString;

public class AddressFieldImpl
implements AddressField {
    private TypeOfNumber typeOfNumber;
    private NumberingPlanIdentification numberingPlanIdentification;
    private String addressValue;

    private AddressFieldImpl() {
    }

    public AddressFieldImpl(TypeOfNumber typeOfNumber, NumberingPlanIdentification numberingPlanIdentification, String addressValue) {
        this.typeOfNumber = typeOfNumber;
        this.numberingPlanIdentification = numberingPlanIdentification;
        this.addressValue = addressValue;
    }

    public static AddressFieldImpl createMessage(InputStream stm) throws MAPException {
        if (stm == null) {
            throw new MAPException("Error creating AddressField: stream must not be null");
        }
        AddressFieldImpl res = new AddressFieldImpl();
        try {
            int addressLength = stm.read();
            if (addressLength == -1) {
                throw new MAPException("Error creating AddressField: Address-Length field not found");
            }
            if (addressLength < 0 || addressLength > 20) {
                throw new MAPException("Error creating AddressField: Address-Length field must be equal from 0 to 20, found: addressLength");
            }
            int typeOfAddress = stm.read();
            if (typeOfAddress == -1) {
                throw new MAPException("Error creating AddressField: Type-of-Address field not found");
            }
            res.typeOfNumber = TypeOfNumber.getInstance((typeOfAddress & 0x70) >> 4);
            res.numberingPlanIdentification = NumberingPlanIdentification.getInstance(typeOfAddress & 0xF);
            int addressArrayLength = (addressLength + 1) / 2;
            if (res.typeOfNumber == TypeOfNumber.Alphanumeric) {
                byte[] rawAddress = new byte[addressArrayLength];
                int dataRead = stm.read(rawAddress);
                ByteBuffer bb = ByteBuffer.wrap(rawAddress, 0, dataRead);
                GSMCharset cs = new GSMCharset("GSM", new String[0]);
                GSMCharsetDecoder decoder = (GSMCharsetDecoder)cs.newDecoder();
                int totalSeptetCount = addressLength < 14 ? addressArrayLength : addressArrayLength + 1;
                GSMCharsetDecodingData encodingData = new GSMCharsetDecodingData(Gsm7EncodingStyle.bit7_sms_style, totalSeptetCount, 0);
                decoder.setGSMCharsetDecodingData(encodingData);
                CharBuffer bf = decoder.decode(bb);
                res.addressValue = bf.toString();
            } else {
                res.addressValue = TbcdString.decodeString(stm, addressArrayLength);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when creating AddressField: " + e.getMessage(), e);
        }
        catch (MAPParsingComponentException e) {
            throw new MAPException("MAPParsingComponentException when creating AddressField: " + e.getMessage(), e);
        }
        return res;
    }

    @Override
    public TypeOfNumber getTypeOfNumber() {
        return this.typeOfNumber;
    }

    @Override
    public NumberingPlanIdentification getNumberingPlanIdentification() {
        return this.numberingPlanIdentification;
    }

    @Override
    public String getAddressValue() {
        return this.addressValue;
    }

    @Override
    public void encodeData(OutputStream stm) throws MAPException {
        if (this.typeOfNumber == null || this.numberingPlanIdentification == null || this.addressValue == null) {
            throw new MAPException("Error encoding AddressFieldImpl: typeOfNumber, addressValue and numberingPlanIdentification fields must not be null");
        }
        try {
            int addrLen = this.addressValue.length();
            int tpOfAddr = 128 + (this.typeOfNumber.getCode() << 4) + this.numberingPlanIdentification.getCode();
            if (this.typeOfNumber == TypeOfNumber.Alphanumeric) {
                GSMCharset cs = new GSMCharset("GSM", new String[0]);
                GSMCharsetEncoder encoder = (GSMCharsetEncoder)cs.newEncoder();
                ByteBuffer bb = encoder.encode(CharBuffer.wrap(this.addressValue));
                int dataLength = bb.limit();
                byte[] data = new byte[dataLength];
                bb.get(data);
                int semiOct = addrLen * 2 - addrLen / 4;
                stm.write(semiOct);
                stm.write(tpOfAddr);
                stm.write(data);
            } else {
                stm.write(addrLen);
                stm.write(tpOfAddr);
                TbcdString.encodeString(stm, this.addressValue);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AddressField [");
        if (this.typeOfNumber != null) {
            sb.append("typeOfNumber=");
            sb.append((Object)this.typeOfNumber);
        }
        if (this.numberingPlanIdentification != null) {
            sb.append(", numberingPlanIdentification=");
            sb.append((Object)this.numberingPlanIdentification);
        }
        if (this.addressValue != null) {
            sb.append(", addressValue=");
            sb.append(this.addressValue);
        }
        sb.append("]");
        return sb.toString();
    }
}

