/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.MSISDNBS;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtBasicServiceCode;
import org.restcomm.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.ExtBasicServiceCodeImpl;

public class MSISDNBSImpl
extends SequenceBase
implements MSISDNBS {
    private static final int _TAG_BASIC_SERVICE_LIST = 0;
    private static final int _TAG_EXTENSION_CONTAINER = 1;
    private ISDNAddressString msisdn;
    private ArrayList<ExtBasicServiceCode> basicServiceList;
    private MAPExtensionContainer extensionContainer;

    public MSISDNBSImpl() {
        super("MSISDNBS");
    }

    public MSISDNBSImpl(ISDNAddressString msisdn, ArrayList<ExtBasicServiceCode> basicServiceList, MAPExtensionContainer extensionContainer) {
        super("MSISDNBS");
        this.msisdn = msisdn;
        this.basicServiceList = basicServiceList;
        this.extensionContainer = extensionContainer;
    }

    @Override
    public ISDNAddressString getMsisdn() {
        return this.msisdn;
    }

    @Override
    public ArrayList<ExtBasicServiceCode> getBasicServiceList() {
        return this.basicServiceList;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.msisdn = null;
        this.basicServiceList = null;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block11: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 0: {
                    switch (tag) {
                        case 4: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter msisdn is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.msisdn = new ISDNAddressStringImpl();
                            ((ISDNAddressStringImpl)this.msisdn).decodeAll(ais);
                            continue block11;
                        }
                    }
                    ais.advanceElement();
                    continue block11;
                }
                case 2: {
                    switch (tag) {
                        case 0: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".basicServiceList: Parameter basicServiceList is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.basicServiceList = new ArrayList();
                            AsnInputStream ais2 = ais.readSequenceStream();
                            while (ais2.available() != 0) {
                                ais2.readTag();
                                ExtBasicServiceCodeImpl extBasicServiceCode = new ExtBasicServiceCodeImpl();
                                extBasicServiceCode.decodeAll(ais2);
                                this.basicServiceList.add(extBasicServiceCode);
                            }
                            if (this.basicServiceList.size() >= 1 && this.basicServiceList.size() <= 70) continue block11;
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter basicServiceList size must be from 1 to 10, found: " + this.basicServiceList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        case 1: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            continue block11;
                        }
                    }
                    ais.advanceElement();
                    continue block11;
                }
            }
            ais.advanceElement();
        }
        if (this.msisdn == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + "msisdn is mandatory but it is absent", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.msisdn == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter msisdn is not defined");
        }
        ((ISDNAddressStringImpl)this.msisdn).encodeAll(asnOs);
        try {
            if (this.basicServiceList != null) {
                if (this.basicServiceList.size() < 1 || this.basicServiceList.size() > 70) {
                    throw new MAPException("Error while encoding " + this._PrimitiveName + " size basicServiceList is out of range (1..70). Actual size: " + this.basicServiceList.size());
                }
                asnOs.writeTag(2, false, 0);
                int pos = asnOs.StartContentDefiniteLength();
                for (ExtBasicServiceCode extBasicServiceCode : this.basicServiceList) {
                    ((ExtBasicServiceCodeImpl)extBasicServiceCode).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
        }
        catch (AsnException ae) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + ae.getMessage(), ae);
        }
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 1);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.msisdn != null) {
            sb.append("msisdn=");
            sb.append(this.msisdn);
            sb.append(", ");
        }
        if (this.basicServiceList != null) {
            sb.append("basicServiceList=[");
            boolean firstItem = true;
            for (ExtBasicServiceCode extCwFeature : this.basicServiceList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(extCwFeature);
            }
            sb.append("], ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

