/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPMessageType;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.GSNAddress;
import org.restcomm.protocols.ss7.map.api.primitives.IMSI;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.primitives.LMSI;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.ADDInfo;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.PagingArea;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.UpdateLocationRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.VLRCapability;
import org.restcomm.protocols.ss7.map.primitives.GSNAddressImpl;
import org.restcomm.protocols.ss7.map.primitives.IMSIImpl;
import org.restcomm.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.LMSIImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.service.mobility.MobilityMessageImpl;
import org.restcomm.protocols.ss7.map.service.mobility.locationManagement.ADDInfoImpl;
import org.restcomm.protocols.ss7.map.service.mobility.locationManagement.PagingAreaImpl;
import org.restcomm.protocols.ss7.map.service.mobility.locationManagement.VLRCapabilityImpl;

public class UpdateLocationRequestImpl
extends MobilityMessageImpl
implements UpdateLocationRequest {
    protected static final int _TAG_mscNumber = 1;
    protected static final int _TAG_roamingNumber = 0;
    protected static final int _TAG_lmsi = 10;
    protected static final int _TAG_vlrCapability = 6;
    protected static final int _TAG_informPreviousNetworkEntity = 11;
    protected static final int _TAG_csLCSNotSupportedByUE = 12;
    protected static final int _TAG_vGmlcAddress = 2;
    protected static final int _TAG_addInfo = 13;
    protected static final int _TAG_pagingArea = 14;
    protected static final int _TAG_skipSubscriberDataUpdate = 15;
    protected static final int _TAG_restorationIndicator = 16;
    public static final String _PrimitiveName = "UpdateLocationRequest";
    private IMSI imsi;
    private ISDNAddressString mscNumber;
    private ISDNAddressString roamingNumber;
    private ISDNAddressString vlrNumber;
    private LMSI lmsi;
    private MAPExtensionContainer extensionContainer;
    private VLRCapability vlrCapability;
    private boolean informPreviousNetworkEntity;
    private boolean csLCSNotSupportedByUE;
    private GSNAddress vGmlcAddress;
    private ADDInfo addInfo;
    private PagingArea pagingArea;
    private boolean skipSubscriberDataUpdate;
    private boolean restorationIndicator;
    private long mapProtocolVersion;

    public UpdateLocationRequestImpl(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public UpdateLocationRequestImpl(long mapProtocolVersion, IMSI imsi, ISDNAddressString mscNumber, ISDNAddressString roamingNumber, ISDNAddressString vlrNumber, LMSI lmsi, MAPExtensionContainer extensionContainer, VLRCapability vlrCapability, boolean informPreviousNetworkEntity, boolean csLCSNotSupportedByUE, GSNAddress vGmlcAddress, ADDInfo addInfo, PagingArea pagingArea, boolean skipSubscriberDataUpdate, boolean restorationIndicator) {
        this.mapProtocolVersion = mapProtocolVersion;
        this.imsi = imsi;
        this.mscNumber = mscNumber;
        this.roamingNumber = roamingNumber;
        this.vlrNumber = vlrNumber;
        this.lmsi = lmsi;
        this.extensionContainer = extensionContainer;
        this.vlrCapability = vlrCapability;
        this.informPreviousNetworkEntity = informPreviousNetworkEntity;
        this.csLCSNotSupportedByUE = csLCSNotSupportedByUE;
        this.vGmlcAddress = vGmlcAddress;
        this.addInfo = addInfo;
        this.pagingArea = pagingArea;
        this.skipSubscriberDataUpdate = skipSubscriberDataUpdate;
        this.restorationIndicator = restorationIndicator;
    }

    @Override
    public MAPMessageType getMessageType() {
        return MAPMessageType.updateLocation_Request;
    }

    @Override
    public int getOperationCode() {
        return 2;
    }

    @Override
    public IMSI getImsi() {
        return this.imsi;
    }

    @Override
    public ISDNAddressString getMscNumber() {
        return this.mscNumber;
    }

    @Override
    public ISDNAddressString getRoamingNumber() {
        return this.roamingNumber;
    }

    @Override
    public ISDNAddressString getVlrNumber() {
        return this.vlrNumber;
    }

    @Override
    public LMSI getLmsi() {
        return this.lmsi;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    public VLRCapability getVlrCapability() {
        return this.vlrCapability;
    }

    @Override
    public boolean getInformPreviousNetworkEntity() {
        return this.informPreviousNetworkEntity;
    }

    @Override
    public boolean getCsLCSNotSupportedByUE() {
        return this.csLCSNotSupportedByUE;
    }

    @Override
    public GSNAddress getVGmlcAddress() {
        return this.vGmlcAddress;
    }

    @Override
    public ADDInfo getADDInfo() {
        return this.addInfo;
    }

    @Override
    public PagingArea getPagingArea() {
        return this.pagingArea;
    }

    @Override
    public boolean getSkipSubscriberDataUpdate() {
        return this.skipSubscriberDataUpdate;
    }

    @Override
    public boolean getRestorationIndicator() {
        return this.restorationIndicator;
    }

    @Override
    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding UpdateLocationRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding UpdateLocationRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding UpdateLocationRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding UpdateLocationRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imsi = null;
        this.mscNumber = null;
        this.roamingNumber = null;
        this.vlrNumber = null;
        this.lmsi = null;
        this.extensionContainer = null;
        this.vlrCapability = null;
        this.informPreviousNetworkEntity = false;
        this.csLCSNotSupportedByUE = false;
        this.vGmlcAddress = null;
        this.addInfo = null;
        this.pagingArea = null;
        this.skipSubscriberDataUpdate = false;
        this.restorationIndicator = false;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding UpdateLocationRequest.imsi: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.imsi = new IMSIImpl();
                    ((IMSIImpl)this.imsi).decodeAll(ais);
                    break;
                }
                case 1: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 1 && (tag != 0 || this.mapProtocolVersion != 1L)) {
                        throw new MAPParsingComponentException("Error while decoding UpdateLocationRequest.mscNumber or roamingNumber: Parameter 1 bad tag class or tag or not primitive or unsupported in the incoming message version", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    if (tag == 1) {
                        this.mscNumber = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.mscNumber).decodeAll(ais);
                        break;
                    }
                    this.roamingNumber = new ISDNAddressStringImpl();
                    ((ISDNAddressStringImpl)this.roamingNumber).decodeAll(ais);
                    break;
                }
                case 2: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding UpdateLocationRequest.vlrNumber: Parameter 2 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.vlrNumber = new ISDNAddressStringImpl();
                    ((ISDNAddressStringImpl)this.vlrNumber).decodeAll(ais);
                    break;
                }
                default: {
                    if (ais.getTagClass() == 2) {
                        switch (tag) {
                            case 10: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateLocationRequest.lmsi: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.lmsi = new LMSIImpl();
                                ((LMSIImpl)this.lmsi).decodeAll(ais);
                                break block0;
                            }
                            case 6: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateLocationRequest.vlrCapability: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.vlrCapability = new VLRCapabilityImpl();
                                ((VLRCapabilityImpl)this.vlrCapability).decodeAll(ais);
                                break block0;
                            }
                            case 11: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateLocationRequest.informPreviousNetworkEntity: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.informPreviousNetworkEntity = true;
                                break block0;
                            }
                            case 12: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateLocationRequest.csLCSNotSupportedByUE: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.csLCSNotSupportedByUE = true;
                                break block0;
                            }
                            case 2: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateLocationRequest.vGmlcAddress: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.vGmlcAddress = new GSNAddressImpl();
                                ((GSNAddressImpl)this.vGmlcAddress).decodeAll(ais);
                                break block0;
                            }
                            case 13: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateLocationRequest.addInfo: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.addInfo = new ADDInfoImpl();
                                ((ADDInfoImpl)this.addInfo).decodeAll(ais);
                                break block0;
                            }
                            case 14: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateLocationRequest.pagingArea: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.pagingArea = new PagingAreaImpl();
                                ((PagingAreaImpl)this.pagingArea).decodeAll(ais);
                                break block0;
                            }
                            case 15: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateLocationRequest.skipSubscriberDataUpdate: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.skipSubscriberDataUpdate = true;
                                break block0;
                            }
                            case 16: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateLocationRequest.restorationIndicator: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.restorationIndicator = true;
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    if (ais.getTagClass() == 0) {
                        switch (tag) {
                            case 16: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateLocationRequest.extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.extensionContainer = new MAPExtensionContainerImpl();
                                ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 3) {
            throw new MAPParsingComponentException("Error while decoding UpdateLocationRequest: Needs at least 3 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding UpdateLocationRequest: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.imsi == null || this.mscNumber == null && (this.roamingNumber == null || this.mapProtocolVersion > 1L) || this.vlrNumber == null) {
                throw new MAPException("IMSI, mscNumber (roamingNumber) and vlrNumber parameter must not be null");
            }
            ((IMSIImpl)this.imsi).encodeAll(asnOs);
            if (this.mscNumber != null) {
                ((ISDNAddressStringImpl)this.mscNumber).encodeAll(asnOs, 2, 1);
            } else {
                ((ISDNAddressStringImpl)this.roamingNumber).encodeAll(asnOs, 2, 0);
            }
            ((ISDNAddressStringImpl)this.vlrNumber).encodeAll(asnOs);
            if (this.lmsi != null) {
                ((LMSIImpl)this.lmsi).encodeAll(asnOs, 2, 10);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
            if (this.vlrCapability != null) {
                ((VLRCapabilityImpl)this.vlrCapability).encodeAll(asnOs, 2, 6);
            }
            if (this.informPreviousNetworkEntity) {
                asnOs.writeNull(2, 11);
            }
            if (this.csLCSNotSupportedByUE) {
                asnOs.writeNull(2, 12);
            }
            if (this.vGmlcAddress != null) {
                ((GSNAddressImpl)this.vGmlcAddress).encodeAll(asnOs, 2, 2);
            }
            if (this.addInfo != null) {
                ((ADDInfoImpl)this.addInfo).encodeAll(asnOs, 2, 13);
            }
            if (this.pagingArea != null) {
                ((PagingAreaImpl)this.pagingArea).encodeAll(asnOs, 2, 14);
            }
            if (this.skipSubscriberDataUpdate) {
                asnOs.writeNull(2, 15);
            }
            if (this.restorationIndicator) {
                asnOs.writeNull(2, 16);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding UpdateLocationRequest: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding UpdateLocationRequest: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateLocationRequest [");
        if (this.imsi != null) {
            sb.append("imsi=");
            sb.append(this.imsi.toString());
            sb.append(", ");
        }
        if (this.mscNumber != null) {
            sb.append("mscNumber=");
            sb.append(this.mscNumber.toString());
            sb.append(", ");
        }
        if (this.roamingNumber != null) {
            sb.append("roamingNumber=");
            sb.append(this.roamingNumber.toString());
            sb.append(", ");
        }
        if (this.vlrNumber != null) {
            sb.append("vlrNumber=");
            sb.append(this.vlrNumber.toString());
            sb.append(", ");
        }
        if (this.lmsi != null) {
            sb.append("lmsi=");
            sb.append(this.lmsi.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.vlrCapability != null) {
            sb.append("vlrCapability=");
            sb.append(this.vlrCapability.toString());
            sb.append(", ");
        }
        if (this.informPreviousNetworkEntity) {
            sb.append("informPreviousNetworkEntity, ");
        }
        if (this.csLCSNotSupportedByUE) {
            sb.append("csLCSNotSupportedByUE, ");
        }
        if (this.vGmlcAddress != null) {
            sb.append("vGmlcAddress=");
            sb.append(this.vGmlcAddress.toString());
            sb.append(", ");
        }
        if (this.addInfo != null) {
            sb.append("addInfo=");
            sb.append(this.addInfo.toString());
            sb.append(", ");
        }
        if (this.pagingArea != null) {
            sb.append("pagingArea=");
            sb.append(this.pagingArea.toString());
            sb.append(", ");
        }
        if (this.skipSubscriberDataUpdate) {
            sb.append("skipSubscriberDataUpdate, ");
        }
        if (this.restorationIndicator) {
            sb.append("restorationIndicator, ");
        }
        sb.append("mapProtocolVersion=");
        sb.append(this.mapProtocolVersion);
        sb.append("]");
        return sb.toString();
    }
}

