/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPMessageType;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.GSNAddress;
import org.restcomm.protocols.ss7.map.api.primitives.IMSI;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.ADDInfo;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.EPSInfo;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.SGSNCapability;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.UESRVCCCapability;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.UpdateGprsLocationRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.UsedRATType;
import org.restcomm.protocols.ss7.map.primitives.GSNAddressImpl;
import org.restcomm.protocols.ss7.map.primitives.IMSIImpl;
import org.restcomm.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.service.mobility.MobilityMessageImpl;
import org.restcomm.protocols.ss7.map.service.mobility.locationManagement.ADDInfoImpl;
import org.restcomm.protocols.ss7.map.service.mobility.locationManagement.EPSInfoImpl;
import org.restcomm.protocols.ss7.map.service.mobility.locationManagement.SGSNCapabilityImpl;

public class UpdateGprsLocationRequestImpl
extends MobilityMessageImpl
implements UpdateGprsLocationRequest {
    private static final int TAG_sgsnCapability = 0;
    private static final int TAG_informPreviousNetworkEntity = 1;
    private static final int TAG_psLCSNotSupportedByUE = 2;
    private static final int TAG_vGmlcAddress = 3;
    private static final int TAG_addInfo = 4;
    private static final int TAG_epsInfo = 5;
    private static final int TAG_servingNodeTypeIndicator = 6;
    private static final int TAG_skipSubscriberDataUpdate = 7;
    private static final int TAG_usedRATType = 8;
    private static final int TAG_gprsSubscriptionDataNotNeeded = 9;
    private static final int TAG_nodeTypeIndicator = 10;
    private static final int TAG_areaRestricted = 11;
    private static final int TAG_ueReachableIndicator = 12;
    private static final int TAG_epsSubscriptionDataNotNeeded = 13;
    private static final int TAG_uesrvccCapability = 14;
    public static final String _PrimitiveName = "UpdateGprsLocationRequest";
    private IMSI imsi;
    private ISDNAddressString sgsnNumber;
    private GSNAddress sgsnAddress;
    private MAPExtensionContainer extensionContainer;
    private SGSNCapability sgsnCapability;
    private boolean informPreviousNetworkEntity;
    private boolean psLCSNotSupportedByUE;
    private GSNAddress vGmlcAddress;
    private ADDInfo addInfo;
    private EPSInfo epsInfo;
    private boolean servingNodeTypeIndicator;
    private boolean skipSubscriberDataUpdate;
    private UsedRATType usedRATType;
    private boolean gprsSubscriptionDataNotNeeded;
    private boolean nodeTypeIndicator;
    private boolean areaRestricted;
    private boolean ueReachableIndicator;
    private boolean epsSubscriptionDataNotNeeded;
    private UESRVCCCapability uesrvccCapability;

    public UpdateGprsLocationRequestImpl() {
    }

    public UpdateGprsLocationRequestImpl(IMSI imsi, ISDNAddressString sgsnNumber, GSNAddress sgsnAddress, MAPExtensionContainer extensionContainer, SGSNCapability sgsnCapability, boolean informPreviousNetworkEntity, boolean psLCSNotSupportedByUE, GSNAddress vGmlcAddress, ADDInfo addInfo, EPSInfo epsInfo, boolean servingNodeTypeIndicator, boolean skipSubscriberDataUpdate, UsedRATType usedRATType, boolean gprsSubscriptionDataNotNeeded, boolean nodeTypeIndicator, boolean areaRestricted, boolean ueReachableIndicator, boolean epsSubscriptionDataNotNeeded, UESRVCCCapability uesrvccCapability, long mapProtocolVersion) {
        this.imsi = imsi;
        this.sgsnNumber = sgsnNumber;
        this.sgsnAddress = sgsnAddress;
        this.extensionContainer = extensionContainer;
        this.sgsnCapability = sgsnCapability;
        this.informPreviousNetworkEntity = informPreviousNetworkEntity;
        this.psLCSNotSupportedByUE = psLCSNotSupportedByUE;
        this.vGmlcAddress = vGmlcAddress;
        this.addInfo = addInfo;
        this.epsInfo = epsInfo;
        this.servingNodeTypeIndicator = servingNodeTypeIndicator;
        this.skipSubscriberDataUpdate = skipSubscriberDataUpdate;
        this.usedRATType = usedRATType;
        this.gprsSubscriptionDataNotNeeded = gprsSubscriptionDataNotNeeded;
        this.nodeTypeIndicator = nodeTypeIndicator;
        this.areaRestricted = areaRestricted;
        this.ueReachableIndicator = ueReachableIndicator;
        this.epsSubscriptionDataNotNeeded = epsSubscriptionDataNotNeeded;
        this.uesrvccCapability = uesrvccCapability;
    }

    @Override
    public MAPMessageType getMessageType() {
        return MAPMessageType.updateGprsLocation_Request;
    }

    @Override
    public int getOperationCode() {
        return 23;
    }

    @Override
    public IMSI getImsi() {
        return this.imsi;
    }

    @Override
    public ISDNAddressString getSgsnNumber() {
        return this.sgsnNumber;
    }

    @Override
    public GSNAddress getSgsnAddress() {
        return this.sgsnAddress;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    public SGSNCapability getSGSNCapability() {
        return this.sgsnCapability;
    }

    @Override
    public boolean getInformPreviousNetworkEntity() {
        return this.informPreviousNetworkEntity;
    }

    @Override
    public boolean getPsLCSNotSupportedByUE() {
        return this.psLCSNotSupportedByUE;
    }

    @Override
    public GSNAddress getVGmlcAddress() {
        return this.vGmlcAddress;
    }

    @Override
    public ADDInfo getADDInfo() {
        return this.addInfo;
    }

    @Override
    public EPSInfo getEPSInfo() {
        return this.epsInfo;
    }

    @Override
    public boolean getServingNodeTypeIndicator() {
        return this.servingNodeTypeIndicator;
    }

    @Override
    public boolean getSkipSubscriberDataUpdate() {
        return this.skipSubscriberDataUpdate;
    }

    @Override
    public UsedRATType getUsedRATType() {
        return this.usedRATType;
    }

    @Override
    public boolean getGprsSubscriptionDataNotNeeded() {
        return this.gprsSubscriptionDataNotNeeded;
    }

    @Override
    public boolean getNodeTypeIndicator() {
        return this.nodeTypeIndicator;
    }

    @Override
    public boolean getAreaRestricted() {
        return this.areaRestricted;
    }

    @Override
    public boolean getUeReachableIndicator() {
        return this.ueReachableIndicator;
    }

    @Override
    public boolean getEpsSubscriptionDataNotNeeded() {
        return this.epsSubscriptionDataNotNeeded;
    }

    @Override
    public UESRVCCCapability getUESRVCCCapability() {
        return this.uesrvccCapability;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding UpdateGprsLocationRequest: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding UpdateGprsLocationRequest: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding UpdateGprsLocationRequest: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding UpdateGprsLocationRequest: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imsi = null;
        this.sgsnNumber = null;
        this.sgsnAddress = null;
        this.extensionContainer = null;
        this.sgsnCapability = null;
        this.informPreviousNetworkEntity = false;
        this.psLCSNotSupportedByUE = false;
        this.vGmlcAddress = null;
        this.addInfo = null;
        this.epsInfo = null;
        this.servingNodeTypeIndicator = false;
        this.skipSubscriberDataUpdate = false;
        this.usedRATType = null;
        this.gprsSubscriptionDataNotNeeded = false;
        this.nodeTypeIndicator = false;
        this.areaRestricted = false;
        this.ueReachableIndicator = false;
        this.epsSubscriptionDataNotNeeded = false;
        this.uesrvccCapability = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.imsi: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.imsi = new IMSIImpl();
                    ((IMSIImpl)this.imsi).decodeAll(ais);
                    break;
                }
                case 1: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.imsi: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.sgsnNumber = new ISDNAddressStringImpl();
                    ((ISDNAddressStringImpl)this.sgsnNumber).decodeAll(ais);
                    break;
                }
                case 2: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.vlrNumber: Parameter 2 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.sgsnAddress = new GSNAddressImpl();
                    ((GSNAddressImpl)this.sgsnAddress).decodeAll(ais);
                    break;
                }
                default: {
                    if (ais.getTagClass() == 0) {
                        switch (tag) {
                            case 16: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.extensionContainer = new MAPExtensionContainerImpl();
                                ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    if (ais.getTagClass() == 2) {
                        switch (tag) {
                            case 0: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.sgsnCapability: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.sgsnCapability = new SGSNCapabilityImpl();
                                ((SGSNCapabilityImpl)this.sgsnCapability).decodeAll(ais);
                                break block0;
                            }
                            case 1: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.informPreviousNetworkEntity: Parameter is  not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.informPreviousNetworkEntity = true;
                                break block0;
                            }
                            case 2: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.tpsLCSNotSupportedByUE: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.psLCSNotSupportedByUE = true;
                                break block0;
                            }
                            case 3: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.vGmlcAddress: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.vGmlcAddress = new GSNAddressImpl();
                                ((GSNAddressImpl)this.vGmlcAddress).decodeAll(ais);
                                break block0;
                            }
                            case 4: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.addInfo: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.addInfo = new ADDInfoImpl();
                                ((ADDInfoImpl)this.addInfo).decodeAll(ais);
                                break block0;
                            }
                            case 5: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.epsInfo: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                AsnInputStream ais2 = ais.readSequenceStream();
                                ais2.readTag();
                                this.epsInfo = new EPSInfoImpl();
                                ((EPSInfoImpl)this.epsInfo).decodeAll(ais2);
                                break block0;
                            }
                            case 6: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.servingNodeTypeIndicator: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.servingNodeTypeIndicator = true;
                                break block0;
                            }
                            case 7: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.skipSubscriberDataUpdate: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.skipSubscriberDataUpdate = true;
                                break block0;
                            }
                            case 8: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.usedRATType: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                int raType = (int)ais.readInteger();
                                this.usedRATType = UsedRATType.getInstance(raType);
                                break block0;
                            }
                            case 9: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.gprsSubscriptionDataNotNeeded: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.gprsSubscriptionDataNotNeeded = true;
                                break block0;
                            }
                            case 10: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.nodeTypeIndicator: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.nodeTypeIndicator = true;
                                break block0;
                            }
                            case 11: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.areaRestricted: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.areaRestricted = true;
                                break block0;
                            }
                            case 12: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.ueReachableIndicator: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.ueReachableIndicator = true;
                                break block0;
                            }
                            case 13: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.epsSubscriptionDataNotNeeded: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.epsSubscriptionDataNotNeeded = true;
                                break block0;
                            }
                            case 14: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest.uesrvccCapability: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                int vccCapability = (int)ais.readInteger();
                                this.uesrvccCapability = UESRVCCCapability.getInstance(vccCapability);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (this.imsi == null || this.sgsnNumber == null || this.sgsnAddress == null) {
            throw new MAPParsingComponentException("Error while decoding UpdateGprsLocationRequest: imsi or sgsnNumber or sgsnAddress is null ", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        try {
            this.encodeAll(asnOs, this.getTagClass(), this.getTag());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MAPException(e);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            e.printStackTrace();
            throw new MAPException("AsnException when encoding UpdateGprsLocationRequest: " + e.getMessage(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MAPException("AsnException when encoding UpdateGprsLocationRequest: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.imsi == null || this.sgsnNumber == null || this.sgsnAddress == null) {
                throw new MAPException("imsi, sgsnNumber and sgsnAddress parameter must not be null");
            }
            ((IMSIImpl)this.imsi).encodeAll(asnOs);
            ((ISDNAddressStringImpl)this.sgsnNumber).encodeAll(asnOs);
            ((GSNAddressImpl)this.sgsnAddress).encodeAll(asnOs);
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
            if (this.sgsnCapability != null) {
                ((SGSNCapabilityImpl)this.sgsnCapability).encodeAll(asnOs, 2, 0);
            }
            if (this.informPreviousNetworkEntity) {
                asnOs.writeNull(2, 1);
            }
            if (this.psLCSNotSupportedByUE) {
                asnOs.writeNull(2, 2);
            }
            if (this.vGmlcAddress != null) {
                ((GSNAddressImpl)this.vGmlcAddress).encodeAll(asnOs, 2, 3);
            }
            if (this.addInfo != null) {
                ((ADDInfoImpl)this.addInfo).encodeAll(asnOs, 2, 4);
            }
            if (this.epsInfo != null) {
                asnOs.writeTag(2, false, 5);
                int pos = asnOs.StartContentDefiniteLength();
                ((EPSInfoImpl)this.epsInfo).encodeAll(asnOs);
                asnOs.FinalizeContent(pos);
            }
            if (this.servingNodeTypeIndicator) {
                asnOs.writeNull(2, 6);
            }
            if (this.skipSubscriberDataUpdate) {
                asnOs.writeNull(2, 7);
            }
            if (this.usedRATType != null) {
                asnOs.writeInteger(2, 8, this.usedRATType.getCode());
            }
            if (this.gprsSubscriptionDataNotNeeded) {
                asnOs.writeNull(2, 9);
            }
            if (this.nodeTypeIndicator) {
                asnOs.writeNull(2, 10);
            }
            if (this.areaRestricted) {
                asnOs.writeNull(2, 11);
            }
            if (this.ueReachableIndicator) {
                asnOs.writeNull(2, 12);
            }
            if (this.epsSubscriptionDataNotNeeded) {
                asnOs.writeNull(2, 13);
            }
            if (this.uesrvccCapability != null) {
                asnOs.writeInteger(2, 14, this.uesrvccCapability.getCode());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding UpdateGprsLocationRequest: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding UpdateGprsLocationRequest: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.imsi != null) {
            sb.append("imsi=");
            sb.append(this.imsi.toString());
            sb.append(", ");
        }
        if (this.sgsnNumber != null) {
            sb.append("sgsnNumber=");
            sb.append(this.sgsnNumber.toString());
            sb.append(", ");
        }
        if (this.sgsnAddress != null) {
            sb.append("sgsnAddress=");
            sb.append(this.sgsnAddress.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.sgsnCapability != null) {
            sb.append("sgsnCapability=");
            sb.append(this.sgsnCapability.toString());
            sb.append(", ");
        }
        if (this.informPreviousNetworkEntity) {
            sb.append("informPreviousNetworkEntity, ");
        }
        if (this.psLCSNotSupportedByUE) {
            sb.append("psLCSNotSupportedByUE, ");
        }
        if (this.vGmlcAddress != null) {
            sb.append("vGmlcAddress=");
            sb.append(this.vGmlcAddress.toString());
            sb.append(", ");
        }
        if (this.addInfo != null) {
            sb.append("addInfo=");
            sb.append(this.addInfo.toString());
            sb.append(", ");
        }
        if (this.epsInfo != null) {
            sb.append("epsInfo=");
            sb.append(this.epsInfo.toString());
            sb.append(", ");
        }
        if (this.servingNodeTypeIndicator) {
            sb.append("servingNodeTypeIndicator, ");
        }
        if (this.skipSubscriberDataUpdate) {
            sb.append("skipSubscriberDataUpdate, ");
        }
        if (this.usedRATType != null) {
            sb.append("usedRATType=");
            sb.append(this.usedRATType.toString());
            sb.append(", ");
        }
        if (this.gprsSubscriptionDataNotNeeded) {
            sb.append("gprsSubscriptionDataNotNeeded, ");
        }
        if (this.nodeTypeIndicator) {
            sb.append("nodeTypeIndicator, ");
        }
        if (this.areaRestricted) {
            sb.append("areaRestricted, ");
        }
        if (this.ueReachableIndicator) {
            sb.append("ueReachableIndicator, ");
        }
        if (this.epsSubscriptionDataNotNeeded) {
            sb.append("epsSubscriptionDataNotNeeded, ");
        }
        if (this.uesrvccCapability != null) {
            sb.append("uesrvccCapability=");
            sb.append(this.uesrvccCapability.toString());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

