/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl.parameter;

import java.util.Arrays;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.ParameterImpl;
import org.restcomm.protocols.ss7.m3ua.parameter.OPCList;

public class OPCListImpl
extends ParameterImpl
implements OPCList,
XMLSerializable {
    private static final String OPC = "opc";
    private static final String MASK = "mask";
    private static final String ARRAY_SIZE = "size";
    private byte[] value;
    private int[] pointCodes;
    private short[] masks;
    protected static final XMLFormat<OPCListImpl> RC_XML = new XMLFormat<OPCListImpl>(OPCListImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, OPCListImpl opc) throws XMLStreamException {
            int i;
            int size = xml.getAttribute(OPCListImpl.ARRAY_SIZE).toInt();
            OPCListImpl.access$002(opc, new int[size]);
            OPCListImpl.access$102(opc, new short[size]);
            for (i = 0; i < opc.pointCodes.length; ++i) {
                ((OPCListImpl)opc).pointCodes[i] = (Integer)xml.get(OPCListImpl.OPC);
            }
            for (i = 0; i < opc.masks.length; ++i) {
                ((OPCListImpl)opc).masks[i] = (Short)xml.get(OPCListImpl.MASK);
            }
            opc.encode();
        }

        @Override
        public void write(OPCListImpl opc, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(OPCListImpl.ARRAY_SIZE, opc.pointCodes.length);
            for (int n : opc.pointCodes) {
                xml.add(n, OPCListImpl.OPC);
            }
            for (short s : opc.masks) {
                xml.add(s, OPCListImpl.MASK);
            }
        }
    };

    public OPCListImpl() {
        this.tag = (short)526;
    }

    protected OPCListImpl(byte[] value) {
        this.tag = (short)526;
        int count = 0;
        int arrSize = 0;
        this.pointCodes = new int[value.length / 4];
        this.masks = new short[value.length / 4];
        while (count < value.length) {
            this.masks[arrSize] = value[count++];
            this.pointCodes[arrSize] = 0;
            int n = arrSize;
            this.pointCodes[n] = this.pointCodes[n] | value[count++] & 0xFF;
            int n2 = arrSize;
            this.pointCodes[n2] = this.pointCodes[n2] << 8;
            int n3 = arrSize;
            this.pointCodes[n3] = this.pointCodes[n3] | value[count++] & 0xFF;
            int n4 = arrSize;
            this.pointCodes[n4] = this.pointCodes[n4] << 8;
            int n5 = arrSize++;
            this.pointCodes[n5] = this.pointCodes[n5] | value[count++] & 0xFF;
        }
        this.value = value;
    }

    protected OPCListImpl(int[] pointCodes, short[] masks) {
        this.tag = (short)526;
        this.pointCodes = pointCodes;
        this.masks = masks;
        this.encode();
    }

    private void encode() {
        this.value = new byte[this.pointCodes.length * 4];
        int count = 0;
        int arrSize = 0;
        while (count < this.value.length) {
            this.value[count++] = (byte)this.masks[arrSize];
            this.value[count++] = (byte)(this.pointCodes[arrSize] >>> 16);
            this.value[count++] = (byte)(this.pointCodes[arrSize] >>> 8);
            this.value[count++] = (byte)this.pointCodes[arrSize++];
        }
    }

    @Override
    protected byte[] getValue() {
        return this.value;
    }

    @Override
    public short[] getMasks() {
        return this.masks;
    }

    @Override
    public int[] getPointCodes() {
        return this.pointCodes;
    }

    public String toString() {
        return String.format("OPCList pointCode=%s mask=%s", Arrays.toString(this.pointCodes), Arrays.toString(this.masks));
    }

    static /* synthetic */ int[] access$002(OPCListImpl x0, int[] x1) {
        x0.pointCodes = x1;
        return x1;
    }

    static /* synthetic */ short[] access$102(OPCListImpl x0, short[] x1) {
        x0.masks = x1;
        return x1;
    }
}

