/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl;

import javolution.util.FastCollection;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.m3ua.Functionality;
import org.restcomm.protocols.ss7.m3ua.impl.AsImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AspImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AspState;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.FSM;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.FSMState;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.TransitionHandler;
import org.restcomm.protocols.ss7.m3ua.message.mgmt.Notify;
import org.restcomm.protocols.ss7.m3ua.parameter.Status;

public class THLocalAsActToPendRemAspInac
implements TransitionHandler {
    private static final Logger logger = Logger.getLogger(THLocalAsActToPendRemAspInac.class);
    private AsImpl asImpl = null;
    private FSM fsm;
    private int lbCount = 0;

    public THLocalAsActToPendRemAspInac(AsImpl asImpl, FSM fsm) {
        this.asImpl = asImpl;
        this.fsm = fsm;
    }

    @Override
    public boolean process(FSMState state) {
        try {
            Notify notify;
            AspState aspState;
            FSM aspPeerFSM;
            FastCollection.Record end;
            FastCollection.Record n;
            AspImpl remAsp = (AspImpl)this.fsm.getAttribute("asp");
            if (this.asImpl.getTrafficModeType().getMode() == 3) {
                return false;
            }
            if (this.asImpl.getTrafficModeType().getMode() == 2) {
                this.lbCount = 0;
                n = this.asImpl.appServerProcs.head();
                end = this.asImpl.appServerProcs.tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    AspImpl remAspImpl = (AspImpl)((FastList.Node)n).getValue();
                    FSM aspPeerFSM2 = remAspImpl.getPeerFSM();
                    AspState aspState2 = AspState.getState(aspPeerFSM2.getState().getName());
                    if (aspState2 != AspState.ACTIVE) continue;
                    ++this.lbCount;
                }
                if (this.lbCount >= this.asImpl.getMinAspActiveForLb()) {
                    return false;
                }
                if (this.lbCount > 0) {
                    if (this.asImpl.getFunctionality() != Functionality.IPSP) {
                        n = this.asImpl.appServerProcs.head();
                        end = this.asImpl.appServerProcs.tail();
                        while ((n = ((FastList.Node)n).getNext()) != end) {
                            remAsp = (AspImpl)((FastList.Node)n).getValue();
                            aspPeerFSM = remAsp.getPeerFSM();
                            aspState = AspState.getState(aspPeerFSM.getState().getName());
                            if (aspState != AspState.INACTIVE) continue;
                            notify = this.createNotify(remAsp, 2, 1);
                            remAsp.getAspFactory().write(notify);
                        }
                    }
                    return false;
                }
            }
            if (this.asImpl.getFunctionality() != Functionality.IPSP) {
                n = this.asImpl.appServerProcs.head();
                end = this.asImpl.appServerProcs.tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    remAsp = (AspImpl)((FastList.Node)n).getValue();
                    aspPeerFSM = remAsp.getPeerFSM();
                    aspState = AspState.getState(aspPeerFSM.getState().getName());
                    if (aspState != AspState.INACTIVE) continue;
                    notify = this.createNotify(remAsp, 1, 4);
                    remAsp.getAspFactory().write(notify);
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("Error while translating Rem AS to PENDING. %s", this.fsm.toString()), e);
        }
        return true;
    }

    private Notify createNotify(AspImpl remAsp, int type, int info) {
        Notify msg = (Notify)this.asImpl.getMessageFactory().createMessage(0, 1);
        Status status = this.asImpl.getParameterFactory().createStatus(type, info);
        msg.setStatus(status);
        if (remAsp.getASPIdentifier() != null) {
            msg.setASPIdentifier(remAsp.getASPIdentifier());
        }
        if (this.asImpl.getRoutingContext() != null) {
            msg.setRoutingContext(this.asImpl.getRoutingContext());
        }
        return msg;
    }
}

