/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tools.traceparser;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import org.apache.log4j.BasicConfigurator;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.tools.traceparser.ParseDriverType;
import org.mobicents.protocols.ss7.tools.traceparser.ParseProtocol;
import org.mobicents.protocols.ss7.tools.traceparser.SS7TraceParser;
import org.mobicents.protocols.ss7.tools.traceparser.Ss7ParseParameters;
import org.mobicents.protocols.ss7.tools.traceparser.StatisticResultFm;
import org.mobicents.protocols.ss7.tools.traceparser.TraceFileFilter;

public class TraceParserForm {
    private SS7TraceParser task = null;
    private String parseData = "";
    private String persistDir = null;
    private String persistFile = "Ss7ParseParameters.xml";
    protected JFrame frmSsTraceParser;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private JTextField tfFilePath;
    private JTextField tfApplicationContextFilter;
    private JTextField tfDialogIdFilter;
    private JCheckBox cbApplicationContextFilter;
    private JCheckBox cbDialogIdFilter;
    private JRadioButton rdbtnTpActerna;
    private JRadioButton rdbtnTpSimpleSeq;
    private JRadioButton rdbtnTpPcap;
    private JRadioButton rdbtnHexStream;
    private JButton btnStart;
    private JButton btnStop;
    private JPanel pnMsgLog;
    private JCheckBox cbMsgLog;
    private JButton btnMsgLog;
    private Timer timer;
    private int curMsgCount = 0;
    private JCheckBox cbOpcDpcFilter;
    private JCheckBox cbRecordingDialogMessageChain;
    private JButton btnRecordingDialogMessageChain;
    private static Ss7ParseParameters par = null;
    private JTextField tfMsgLog;
    private JLabel lblMessagesPerformed;
    private JTextField tfMsgCnt;
    private JCheckBox cbTcapData;
    private JCheckBox cbDialogDet;
    private JCheckBox cbCompDet;
    private JTextField tfDialogIdFilter2;
    private JPanel panel_3;
    private JRadioButton rdbtnMap;
    private JLabel lblProtocol;
    private JRadioButton rdbtnCap;
    private JRadioButton rdbtnIsup;
    private JRadioButton rdbtnITU;
    private JRadioButton rdbtnANSI;
    private final ButtonGroup buttonGroup_1 = new ButtonGroup();
    private JButton btnGetStatisticInfo;
    private JTextField tfOpcDpcFilter;
    private JTextField tfRecordingDialogMessageChain;
    private final ButtonGroup buttonGroup_2 = new ButtonGroup();

    public static void main(String[] args) {
        TraceParserForm.setupLog4j();
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream("Ss7ParseParameters.xml"));
            XMLDecoder d = new XMLDecoder(bis);
            par = (Ss7ParseParameters)d.readObject();
            d.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    TraceParserForm window = new TraceParserForm(par);
                    window.frmSsTraceParser.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void setupLog4j() {
        BasicConfigurator.configure();
    }

    public TraceParserForm(Ss7ParseParameters par) {
        this.initialize();
        this.setParameters(par);
    }

    private void initialize() {
        this.frmSsTraceParser = new JFrame();
        this.frmSsTraceParser.setTitle("SS7 Trace Parser");
        this.frmSsTraceParser.setResizable(false);
        this.frmSsTraceParser.setBounds(100, 100, 569, 716);
        this.frmSsTraceParser.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        this.frmSsTraceParser.getContentPane().add((Component)panel, "South");
        this.btnStart = new JButton("Start");
        this.btnStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TraceParserForm.this.tfFilePath.getText() == null || TraceParserForm.this.tfFilePath.getText().equals("")) {
                    JOptionPane.showMessageDialog(null, "The FilePath must be set");
                    return;
                }
                Ss7ParseParameters newPar = new Ss7ParseParameters();
                if (TraceParserForm.this.rdbtnTpActerna.isSelected()) {
                    newPar.setFileTypeN(ParseDriverType.Acterna);
                }
                if (TraceParserForm.this.rdbtnTpSimpleSeq.isSelected()) {
                    newPar.setFileTypeN(ParseDriverType.SimpleSeq);
                }
                if (TraceParserForm.this.rdbtnTpPcap.isSelected()) {
                    newPar.setFileTypeN(ParseDriverType.Pcap);
                }
                if (TraceParserForm.this.rdbtnHexStream.isSelected()) {
                    newPar.setFileTypeN(ParseDriverType.HexStream);
                }
                if (TraceParserForm.this.rdbtnMap.isSelected()) {
                    newPar.setParseProtocol(ParseProtocol.Map);
                }
                if (TraceParserForm.this.rdbtnCap.isSelected()) {
                    newPar.setParseProtocol(ParseProtocol.Cap);
                }
                if (TraceParserForm.this.rdbtnIsup.isSelected()) {
                    newPar.setParseProtocol(ParseProtocol.Isup);
                }
                if (TraceParserForm.this.rdbtnITU.isSelected()) {
                    newPar.setSccpProtocolVersion(SccpProtocolVersion.ITU);
                }
                if (TraceParserForm.this.rdbtnANSI.isSelected()) {
                    newPar.setSccpProtocolVersion(SccpProtocolVersion.ANSI);
                }
                newPar.setSourceFilePath(TraceParserForm.this.tfFilePath.getText());
                if (TraceParserForm.this.cbApplicationContextFilter.isSelected()) {
                    try {
                        newPar.setApplicationContextFilter(Integer.parseInt(TraceParserForm.this.tfApplicationContextFilter.getText()));
                    }
                    catch (NumberFormatException ee) {
                        JOptionPane.showMessageDialog(null, "Can not parse ApplicationContextFilter the value. \nIt should be an Integer.\nParsing without ApplicationContextFilter");
                    }
                }
                if (TraceParserForm.this.cbDialogIdFilter.isSelected()) {
                    try {
                        if (!TraceParserForm.this.tfDialogIdFilter.getText().equals("")) {
                            newPar.setDialogIdFilter(Long.parseLong(TraceParserForm.this.tfDialogIdFilter.getText()));
                        }
                    }
                    catch (NumberFormatException ee) {
                        JOptionPane.showMessageDialog(null, "Can not parse ApplicationContextFilter the value. \nIt should be an Integer.\nParsing without ApplicationContextFilter");
                    }
                    try {
                        if (!TraceParserForm.this.tfDialogIdFilter2.getText().equals("")) {
                            newPar.setDialogIdFilter2(Long.parseLong(TraceParserForm.this.tfDialogIdFilter2.getText()));
                        }
                    }
                    catch (NumberFormatException ee) {
                        JOptionPane.showMessageDialog(null, "Can not parse ApplicationContextFilter2 the value. \nIt should be an Integer.\nParsing without ApplicationContextFilter2");
                    }
                }
                if (TraceParserForm.this.cbOpcDpcFilter.isSelected()) {
                    try {
                        String[] ss = TraceParserForm.this.tfOpcDpcFilter.getText().split(",");
                        int ii1 = ss.length;
                        Integer[] ires = new Integer[ii1];
                        for (int i1 = 0; i1 < ii1; ++i1) {
                            String s = ss[i1];
                            s = s.trim();
                            ires[i1] = Integer.parseInt(s);
                        }
                        newPar.setOpcDpcFilter(ires);
                    }
                    catch (NumberFormatException ee) {
                        JOptionPane.showMessageDialog(null, "Can not parse OpcDpcFilter the value. \nIt should be a set of Integers.\nParsing without OpcDpcFilter");
                    }
                }
                if (TraceParserForm.this.cbMsgLog.isSelected()) {
                    newPar.setMsgLogFilePath(TraceParserForm.this.tfMsgLog.getText());
                }
                if (TraceParserForm.this.cbTcapData.isSelected()) {
                    newPar.setTcapMsgData(true);
                }
                if (TraceParserForm.this.cbDialogDet.isSelected()) {
                    newPar.setDetailedDialog(true);
                }
                if (TraceParserForm.this.cbCompDet.isSelected()) {
                    newPar.setDetailedComponents(true);
                }
                if (TraceParserForm.this.cbRecordingDialogMessageChain.isSelected()) {
                    newPar.setMessageChainFilePath(TraceParserForm.this.tfRecordingDialogMessageChain.getText());
                }
                try {
                    BufferedOutputStream bis = new BufferedOutputStream(new FileOutputStream(TraceParserForm.this.persistFile));
                    XMLEncoder d = new XMLEncoder(bis);
                    d.writeObject(newPar);
                    d.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Failed when saving the parameter file Ss7ParseParameters.xml: " + ee.getMessage());
                }
                TraceParserForm.this.btnStart.setEnabled(false);
                TraceParserForm.this.btnGetStatisticInfo.setEnabled(false);
                TraceParserForm.this.btnStop.setEnabled(true);
                TraceParserForm.this.task = new SS7TraceParser(TraceParserForm.this.persistDir, newPar);
                TraceParserForm.this.task.parse();
            }
        });
        panel.add(this.btnStart);
        this.btnStop = new JButton("Stop");
        this.btnStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TraceParserForm.this.task != null) {
                    TraceParserForm.this.task.interrupt();
                }
            }
        });
        this.btnStop.setEnabled(false);
        panel.add(this.btnStop);
        this.btnGetStatisticInfo = new JButton("Get statistic info");
        this.btnGetStatisticInfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TraceParserForm.this.getStatisticInfo();
            }
        });
        panel.add(this.btnGetStatisticInfo);
        JPanel panel_1 = new JPanel();
        this.frmSsTraceParser.getContentPane().add((Component)panel_1, "Center");
        panel_1.setLayout(null);
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new LineBorder(new Color(0, 0, 0)));
        panel_2.setBounds(10, 11, 543, 58);
        panel_1.add(panel_2);
        panel_2.setLayout(null);
        this.rdbtnTpActerna = new JRadioButton("Acterna");
        this.rdbtnTpActerna.setSelected(true);
        this.buttonGroup.add(this.rdbtnTpActerna);
        this.rdbtnTpActerna.setBounds(6, 28, 109, 23);
        panel_2.add(this.rdbtnTpActerna);
        JLabel lblSelectAFile = new JLabel("Trace file type");
        lblSelectAFile.setBounds(15, 11, 154, 14);
        panel_2.add(lblSelectAFile);
        this.rdbtnTpSimpleSeq = new JRadioButton("Simple sequence");
        this.buttonGroup.add(this.rdbtnTpSimpleSeq);
        this.rdbtnTpSimpleSeq.setBounds(137, 28, 126, 23);
        panel_2.add(this.rdbtnTpSimpleSeq);
        this.rdbtnTpPcap = new JRadioButton("Pcap");
        this.buttonGroup.add(this.rdbtnTpPcap);
        this.rdbtnTpPcap.setBounds(275, 28, 101, 23);
        panel_2.add(this.rdbtnTpPcap);
        this.rdbtnHexStream = new JRadioButton("Hex stream");
        this.buttonGroup.add(this.rdbtnHexStream);
        this.rdbtnHexStream.setBounds(380, 27, 127, 25);
        panel_2.add(this.rdbtnHexStream);
        this.tfFilePath = new JTextField();
        this.tfFilePath.setBounds(20, 187, 481, 20);
        panel_1.add(this.tfFilePath);
        this.tfFilePath.setColumns(10);
        JButton btnFilePath = new JButton(". . .");
        btnFilePath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                String filterName = null;
                if (TraceParserForm.this.rdbtnTpActerna.isSelected()) {
                    filterName = "Acterna";
                }
                if (TraceParserForm.this.rdbtnTpSimpleSeq.isSelected()) {
                    filterName = "Simple";
                }
                if (TraceParserForm.this.rdbtnTpPcap.isSelected()) {
                    filterName = "Pcap";
                }
                if (TraceParserForm.this.rdbtnHexStream.isSelected()) {
                    filterName = "HexStream";
                }
                TraceFileFilter filter = new TraceFileFilter(filterName);
                chooser.setFileFilter(filter);
                chooser.addChoosableFileFilter(filter);
                File f = new File(TraceParserForm.this.tfFilePath.getText());
                chooser.setSelectedFile(f);
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(TraceParserForm.this.frmSsTraceParser);
                if (returnVal == 0) {
                    File f2 = chooser.getSelectedFile();
                    if (f2 != null && f2.exists()) {
                        TraceParserForm.this.tfFilePath.setText(f2.getPath());
                    } else {
                        JOptionPane.showMessageDialog(null, "File does not exists - try again");
                    }
                }
            }
        });
        btnFilePath.setBounds(511, 186, 52, 23);
        panel_1.add(btnFilePath);
        JLabel lblPathToThe = new JLabel("Trace file path");
        lblPathToThe.setBounds(20, 172, 153, 14);
        panel_1.add(lblPathToThe);
        this.cbApplicationContextFilter = new JCheckBox("ApplicationContext filter");
        this.cbApplicationContextFilter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TraceParserForm.this.tfApplicationContextFilter.setEnabled(TraceParserForm.this.cbApplicationContextFilter.isSelected());
            }
        });
        this.cbApplicationContextFilter.setBounds(20, 216, 210, 23);
        panel_1.add(this.cbApplicationContextFilter);
        this.cbMsgLog = new JCheckBox("Messages logging");
        this.cbMsgLog.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TraceParserForm.this.btnMsgLog.setEnabled(TraceParserForm.this.cbMsgLog.isSelected());
                TraceParserForm.this.tfMsgLog.setEnabled(TraceParserForm.this.cbMsgLog.isSelected());
                TraceParserForm.this.cbTcapData.setEnabled(TraceParserForm.this.cbMsgLog.isSelected());
                TraceParserForm.this.cbDialogDet.setEnabled(TraceParserForm.this.cbMsgLog.isSelected());
                TraceParserForm.this.cbCompDet.setEnabled(TraceParserForm.this.cbMsgLog.isSelected());
            }
        });
        this.cbMsgLog.setBounds(20, 308, 210, 23);
        panel_1.add(this.cbMsgLog);
        this.tfApplicationContextFilter = new JTextField();
        this.tfApplicationContextFilter.setEnabled(false);
        this.tfApplicationContextFilter.setBounds(236, 217, 153, 20);
        panel_1.add(this.tfApplicationContextFilter);
        this.tfApplicationContextFilter.setColumns(10);
        this.cbDialogIdFilter = new JCheckBox("DialogId filter");
        this.cbDialogIdFilter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TraceParserForm.this.tfDialogIdFilter.setEnabled(TraceParserForm.this.cbDialogIdFilter.isSelected());
                TraceParserForm.this.tfDialogIdFilter2.setEnabled(TraceParserForm.this.cbDialogIdFilter.isSelected());
            }
        });
        this.cbDialogIdFilter.setBounds(20, 247, 210, 23);
        panel_1.add(this.cbDialogIdFilter);
        this.tfDialogIdFilter = new JTextField();
        this.tfDialogIdFilter.setEnabled(false);
        this.tfDialogIdFilter.setColumns(10);
        this.tfDialogIdFilter.setBounds(236, 248, 153, 20);
        panel_1.add(this.tfDialogIdFilter);
        this.pnMsgLog = new JPanel();
        this.pnMsgLog.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.pnMsgLog.setBounds(10, 338, 553, 136);
        panel_1.add(this.pnMsgLog);
        this.pnMsgLog.setLayout(null);
        this.tfMsgLog = new JTextField();
        this.tfMsgLog.setBounds(10, 27, 433, 20);
        this.pnMsgLog.add(this.tfMsgLog);
        this.tfMsgLog.setEnabled(false);
        this.tfMsgLog.setColumns(10);
        JLabel lblMessageLogFile = new JLabel("Message log file path");
        lblMessageLogFile.setBounds(10, 11, 153, 14);
        this.pnMsgLog.add(lblMessageLogFile);
        this.timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TraceParserForm.this.task != null) {
                    if (TraceParserForm.this.curMsgCount != TraceParserForm.this.task.getMsgCount()) {
                        TraceParserForm.this.curMsgCount = TraceParserForm.this.task.getMsgCount();
                        String s1 = Integer.valueOf(TraceParserForm.this.curMsgCount).toString();
                        TraceParserForm.this.tfMsgCnt.setText(s1);
                    }
                    if (TraceParserForm.this.task.isFinished()) {
                        String errorMsg = TraceParserForm.this.task.getErrorMessage();
                        TraceParserForm.this.btnStart.setEnabled(true);
                        TraceParserForm.this.btnGetStatisticInfo.setEnabled(true);
                        TraceParserForm.this.btnStop.setEnabled(false);
                        TraceParserForm.this.parseData = TraceParserForm.this.task.getStatisticData();
                        TraceParserForm.this.task = null;
                        if (errorMsg != null) {
                            JOptionPane.showMessageDialog(null, "Error: " + errorMsg);
                        } else {
                            JOptionPane.showMessageDialog(null, "Success");
                        }
                    }
                }
            }
        });
        this.timer.start();
        this.btnMsgLog = new JButton(". . .");
        this.btnMsgLog.setEnabled(false);
        this.btnMsgLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                File f = new File(TraceParserForm.this.tfMsgLog.getText());
                chooser.setSelectedFile(f);
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(TraceParserForm.this.frmSsTraceParser);
                if (returnVal == 0) {
                    File f2 = chooser.getSelectedFile();
                    TraceParserForm.this.tfMsgLog.setText(f2.getPath());
                }
            }
        });
        this.btnMsgLog.setBounds(453, 26, 52, 23);
        this.pnMsgLog.add(this.btnMsgLog);
        this.cbTcapData = new JCheckBox("Store in the log TCAP message source data");
        this.cbTcapData.setBounds(10, 50, 296, 23);
        this.pnMsgLog.add(this.cbTcapData);
        this.cbDialogDet = new JCheckBox("Write dialog portion details");
        this.cbDialogDet.setBounds(10, 76, 296, 23);
        this.pnMsgLog.add(this.cbDialogDet);
        this.cbCompDet = new JCheckBox("Write components portion details");
        this.cbCompDet.setBounds(10, 102, 296, 23);
        this.pnMsgLog.add(this.cbCompDet);
        this.lblMessagesPerformed = new JLabel("Messages performed");
        this.lblMessagesPerformed.setBounds(10, 592, 140, 14);
        panel_1.add(this.lblMessagesPerformed);
        this.tfMsgCnt = new JTextField();
        this.tfMsgCnt.setEditable(false);
        this.tfMsgCnt.setBounds(160, 589, 86, 20);
        panel_1.add(this.tfMsgCnt);
        this.tfMsgCnt.setColumns(10);
        this.tfDialogIdFilter2 = new JTextField();
        this.tfDialogIdFilter2.setEnabled(false);
        this.tfDialogIdFilter2.setColumns(10);
        this.tfDialogIdFilter2.setBounds(399, 248, 153, 20);
        panel_1.add(this.tfDialogIdFilter2);
        this.panel_3 = new JPanel();
        this.panel_3.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.panel_3.setLayout(null);
        this.panel_3.setBounds(10, 69, 543, 58);
        panel_1.add(this.panel_3);
        this.rdbtnMap = new JRadioButton("MAP");
        this.buttonGroup_1.add(this.rdbtnMap);
        this.rdbtnMap.setSelected(true);
        this.rdbtnMap.setBounds(6, 28, 109, 23);
        this.panel_3.add(this.rdbtnMap);
        this.lblProtocol = new JLabel("Protocol");
        this.lblProtocol.setBounds(15, 11, 154, 14);
        this.panel_3.add(this.lblProtocol);
        this.rdbtnCap = new JRadioButton("CAP");
        this.buttonGroup_1.add(this.rdbtnCap);
        this.rdbtnCap.setBounds(119, 28, 99, 23);
        this.panel_3.add(this.rdbtnCap);
        this.rdbtnIsup = new JRadioButton("ISUP");
        this.buttonGroup_1.add(this.rdbtnIsup);
        this.rdbtnIsup.setBounds(228, 28, 99, 23);
        this.panel_3.add(this.rdbtnIsup);
        this.cbOpcDpcFilter = new JCheckBox("Opc / Dpc filter (Ex: \"120,130\")");
        this.cbOpcDpcFilter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent arg0) {
                TraceParserForm.this.tfOpcDpcFilter.setEnabled(TraceParserForm.this.cbOpcDpcFilter.isSelected());
            }
        });
        this.cbOpcDpcFilter.setBounds(20, 278, 210, 23);
        panel_1.add(this.cbOpcDpcFilter);
        this.tfOpcDpcFilter = new JTextField();
        this.tfOpcDpcFilter.setEnabled(false);
        this.tfOpcDpcFilter.setColumns(10);
        this.tfOpcDpcFilter.setBounds(236, 279, 317, 20);
        panel_1.add(this.tfOpcDpcFilter);
        this.cbRecordingDialogMessageChain = new JCheckBox("Recording of dialog message chains log");
        this.cbRecordingDialogMessageChain.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TraceParserForm.this.tfRecordingDialogMessageChain.setEnabled(TraceParserForm.this.cbRecordingDialogMessageChain.isSelected());
                TraceParserForm.this.btnRecordingDialogMessageChain.setEnabled(TraceParserForm.this.cbRecordingDialogMessageChain.isSelected());
            }
        });
        this.cbRecordingDialogMessageChain.setBounds(20, 486, 338, 23);
        panel_1.add(this.cbRecordingDialogMessageChain);
        JPanel pnDialogMessageMessage = new JPanel();
        pnDialogMessageMessage.setBorder(new LineBorder(new Color(0, 0, 0)));
        pnDialogMessageMessage.setBounds(10, 516, 553, 65);
        panel_1.add(pnDialogMessageMessage);
        pnDialogMessageMessage.setLayout(null);
        JLabel lblDialogMessageMessage = new JLabel("Dialog message message chains log file path");
        lblDialogMessageMessage.setBounds(10, 11, 265, 14);
        pnDialogMessageMessage.add(lblDialogMessageMessage);
        this.tfRecordingDialogMessageChain = new JTextField();
        this.tfRecordingDialogMessageChain.setBounds(10, 27, 433, 20);
        pnDialogMessageMessage.add(this.tfRecordingDialogMessageChain);
        this.tfRecordingDialogMessageChain.setEnabled(false);
        this.tfRecordingDialogMessageChain.setColumns(10);
        this.btnRecordingDialogMessageChain = new JButton(". . .");
        this.btnRecordingDialogMessageChain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser = new JFileChooser();
                File f = new File(TraceParserForm.this.tfRecordingDialogMessageChain.getText());
                chooser.setSelectedFile(f);
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(TraceParserForm.this.frmSsTraceParser);
                if (returnVal == 0) {
                    File f2 = chooser.getSelectedFile();
                    TraceParserForm.this.tfRecordingDialogMessageChain.setText(f2.getPath());
                }
            }
        });
        this.btnRecordingDialogMessageChain.setBounds(453, 26, 52, 23);
        pnDialogMessageMessage.add(this.btnRecordingDialogMessageChain);
        this.btnRecordingDialogMessageChain.setEnabled(false);
        JPanel panel_4 = new JPanel();
        panel_4.setLayout(null);
        panel_4.setBorder(new LineBorder(new Color(0, 0, 0)));
        panel_4.setBounds(10, 128, 543, 37);
        panel_1.add(panel_4);
        this.rdbtnITU = new JRadioButton("ITU-T");
        this.buttonGroup_2.add(this.rdbtnITU);
        this.rdbtnITU.setSelected(true);
        this.rdbtnITU.setBounds(200, 7, 109, 23);
        panel_4.add(this.rdbtnITU);
        JLabel lblProtocolMua = new JLabel("Protocol M3ua / SCCP");
        lblProtocolMua.setBounds(15, 11, 154, 14);
        panel_4.add(lblProtocolMua);
        this.rdbtnANSI = new JRadioButton("ANSI");
        this.buttonGroup_2.add(this.rdbtnANSI);
        this.rdbtnANSI.setBounds(313, 7, 99, 23);
        panel_4.add(this.rdbtnANSI);
    }

    private void getStatisticInfo() {
        StatisticResultFm fm = new StatisticResultFm(this.frmSsTraceParser, this.parseData);
        fm.setVisible(true);
    }

    private void setParameters(Ss7ParseParameters par) {
        if (par != null) {
            switch (par.getFileTypeN()) {
                case Acterna: {
                    this.rdbtnTpActerna.setSelected(true);
                    break;
                }
                case SimpleSeq: {
                    this.rdbtnTpSimpleSeq.setSelected(true);
                    break;
                }
                case Pcap: {
                    this.rdbtnTpPcap.setSelected(true);
                    break;
                }
                case HexStream: {
                    this.rdbtnHexStream.setSelected(true);
                }
            }
            switch (par.getParseProtocol()) {
                case Map: {
                    this.rdbtnMap.setSelected(true);
                    break;
                }
                case Cap: {
                    this.rdbtnCap.setSelected(true);
                    break;
                }
                case Isup: {
                    this.rdbtnIsup.setSelected(true);
                }
            }
            switch (par.getSccpProtocolVersion()) {
                case ITU: {
                    this.rdbtnITU.setSelected(true);
                    break;
                }
                case ANSI: {
                    this.rdbtnANSI.setSelected(true);
                }
            }
            if (par.getSourceFilePath() != null) {
                this.tfFilePath.setText(par.getSourceFilePath());
            }
            if (par.getApplicationContextFilter() != null) {
                this.cbApplicationContextFilter.setSelected(true);
                this.tfApplicationContextFilter.setText(par.getApplicationContextFilter().toString());
            }
            if (par.getDialogIdFilter() != null || par.getDialogIdFilter2() != null) {
                this.cbDialogIdFilter.setSelected(true);
                if (par.getDialogIdFilter() != null) {
                    this.tfDialogIdFilter.setText(par.getDialogIdFilter().toString());
                }
                if (par.getDialogIdFilter2() != null) {
                    this.tfDialogIdFilter2.setText(par.getDialogIdFilter2().toString());
                }
            }
            if (par.getOpcDpcFilter() != null) {
                this.cbOpcDpcFilter.setSelected(true);
                StringBuilder sb = new StringBuilder();
                if (par.getOpcDpcFilter() != null) {
                    boolean nonFirst = false;
                    for (Integer I1 : par.getOpcDpcFilter()) {
                        if (I1 == null) continue;
                        int i1 = I1;
                        if (nonFirst) {
                            sb.append(", ");
                        } else {
                            nonFirst = true;
                        }
                        sb.append(i1);
                    }
                }
                this.tfOpcDpcFilter.setText(sb.toString());
            }
            if (par.getMsgLogFilePath() != null) {
                this.cbMsgLog.setSelected(true);
                this.tfMsgLog.setText(par.getMsgLogFilePath());
            }
            if (par.getTcapMsgData()) {
                this.cbTcapData.setSelected(true);
            }
            if (par.getDetailedDialog()) {
                this.cbDialogDet.setSelected(true);
            }
            if (par.getDetailedComponents()) {
                this.cbCompDet.setSelected(true);
            }
            if (par.getMessageChainFilePath() != null) {
                this.cbRecordingDialogMessageChain.setSelected(true);
                this.tfRecordingDialogMessageChain.setText(par.getMessageChainFilePath());
            }
        }
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
        this.persistFile = persistDir + File.separator + "Ss7ParseParameters.xml";
    }

    private class SwingAction
    extends AbstractAction {
        public SwingAction() {
            this.putValue("Name", "SwingAction");
            this.putValue("ShortDescription", "Some short description");
        }

        public void actionPerformed(ActionEvent e) {
        }
    }
}

