/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.MCSI;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.MMCode;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.MMCodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MCSIImpl
extends SequenceBase
implements MCSI {
    private static final int _TAG_gsmSCFAddress = 0;
    private static final int _TAG_extensionContainer = 1;
    private static final int _TAG_notificationToCSE = 2;
    private static final int _TAG_csiActive = 3;
    private ArrayList<MMCode> mobilityTriggers;
    private long serviceKey;
    private ISDNAddressString gsmSCFAddress;
    private MAPExtensionContainer extensionContainer;
    private boolean notificationToCSE;
    private boolean csiActive;

    public MCSIImpl() {
        super("MCSI");
    }

    public MCSIImpl(ArrayList<MMCode> mobilityTriggers, long serviceKey, ISDNAddressString gsmSCFAddress, MAPExtensionContainer extensionContainer, boolean notificationToCSE, boolean csiActive) {
        super("MCSI");
        this.mobilityTriggers = mobilityTriggers;
        this.serviceKey = serviceKey;
        this.gsmSCFAddress = gsmSCFAddress;
        this.extensionContainer = extensionContainer;
        this.notificationToCSE = notificationToCSE;
        this.csiActive = csiActive;
    }

    @Override
    public ArrayList<MMCode> getMobilityTriggers() {
        return this.mobilityTriggers;
    }

    @Override
    public long getServiceKey() {
        return this.serviceKey;
    }

    @Override
    public ISDNAddressString getGsmSCFAddress() {
        return this.gsmSCFAddress;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    public boolean getNotificationToCSE() {
        return this.notificationToCSE;
    }

    @Override
    public boolean getCsiActive() {
        return this.csiActive;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.mobilityTriggers = null;
        this.gsmSCFAddress = null;
        this.extensionContainer = null;
        this.notificationToCSE = false;
        this.csiActive = false;
        this.serviceKey = -1L;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block14: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 0: {
                    switch (tag) {
                        case 16: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".mobilityTriggers: Parameter mobilityTriggers is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            MMCodeImpl mmCode = null;
                            AsnInputStream ais2 = ais.readSequenceStream();
                            this.mobilityTriggers = new ArrayList();
                            while (ais2.available() != 0) {
                                int tag2 = ais2.readTag();
                                if (tag2 != 4 || ais2.getTagClass() != 0 || !ais2.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + "MMCode: bad tag or tagClass or is not primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                mmCode = new MMCodeImpl();
                                mmCode.decodeAll(ais2);
                                this.mobilityTriggers.add(mmCode);
                            }
                            if (this.mobilityTriggers.size() >= 1 && this.mobilityTriggers.size() <= 10) continue block14;
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter mobilityTriggers size must be from 1 to 10, found: " + this.mobilityTriggers.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        case 2: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".serviceKey: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.serviceKey = ais.readInteger();
                            continue block14;
                        }
                    }
                    ais.advanceElement();
                    continue block14;
                }
                case 2: {
                    switch (tag) {
                        case 0: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".gsmSCFAddress: Parameter not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.gsmSCFAddress = new ISDNAddressStringImpl();
                            ((ISDNAddressStringImpl)this.gsmSCFAddress).decodeAll(ais);
                            continue block14;
                        }
                        case 1: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            continue block14;
                        }
                        case 2: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".notificationToCSE: Parameter not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            ais.readNull();
                            this.notificationToCSE = true;
                            continue block14;
                        }
                        case 3: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".csiActive: Parameter not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            ais.readNull();
                            this.csiActive = true;
                            continue block14;
                        }
                    }
                    ais.advanceElement();
                    continue block14;
                }
            }
            ais.advanceElement();
        }
        if (this.mobilityTriggers == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament mobilityTriggers is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.gsmSCFAddress == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament gsmSCFAddress is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.serviceKey == -1L) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament serviceKey is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.mobilityTriggers == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter mobilityTriggers is not defined");
        }
        if (this.gsmSCFAddress == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter gsmSCFAddress is not defined");
        }
        if (this.mobilityTriggers.size() < 1 || this.mobilityTriggers.size() > 10) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter mobilityTriggers size must be from 1 to 10, found: " + this.mobilityTriggers.size());
        }
        try {
            asnOs.writeTag(0, false, 16);
            int pos = asnOs.StartContentDefiniteLength();
            for (MMCode mmCode : this.mobilityTriggers) {
                ((MMCodeImpl)mmCode).encodeAll(asnOs);
            }
            asnOs.FinalizeContent(pos);
            asnOs.writeInteger(this.serviceKey);
            ((ISDNAddressStringImpl)this.gsmSCFAddress).encodeAll(asnOs, 2, 0);
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 1);
            }
            if (this.notificationToCSE) {
                asnOs.writeNull(2, 2);
            }
            if (this.csiActive) {
                asnOs.writeNull(2, 3);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.mobilityTriggers != null) {
            sb.append("mobilityTriggers=[");
            boolean firstItem = true;
            for (MMCode be : this.mobilityTriggers) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("], ");
        }
        sb.append("serviceKey=");
        sb.append(this.serviceKey);
        sb.append(", ");
        if (this.gsmSCFAddress != null) {
            sb.append("gsmSCFAddress=");
            sb.append(this.gsmSCFAddress.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.notificationToCSE) {
            sb.append("notificationToCSE ");
            sb.append(", ");
        }
        if (this.csiActive) {
            sb.append("csiActive ");
        }
        sb.append("]");
        return sb.toString();
    }
}

