/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.errors;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageSubscriberBusyForMtSms;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;

public class MAPErrorMessageSubscriberBusyForMtSmsImpl
extends MAPErrorMessageImpl
implements MAPErrorMessageSubscriberBusyForMtSms {
    private static final String GPRS_CONNECTION_SUSPENDED = "gprsConnectionSuspended";
    private static final String MAP_EXTENSION_CONTAINER = "mapExtensionContainer";
    private MAPExtensionContainer extensionContainer;
    private Boolean gprsConnectionSuspended;
    protected static final XMLFormat<MAPErrorMessageSubscriberBusyForMtSmsImpl> MAP_ERROR_MESSAGE_SUBSCRIBER_BUSY_FOR_MT_SMS_XML = new XMLFormat<MAPErrorMessageSubscriberBusyForMtSmsImpl>(MAPErrorMessageSubscriberBusyForMtSmsImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, MAPErrorMessageSubscriberBusyForMtSmsImpl errorMessage) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.read(xml, errorMessage);
            errorMessage.gprsConnectionSuspended = xml.get(MAPErrorMessageSubscriberBusyForMtSmsImpl.GPRS_CONNECTION_SUSPENDED, Boolean.class);
            errorMessage.extensionContainer = xml.get(MAPErrorMessageSubscriberBusyForMtSmsImpl.MAP_EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
        }

        @Override
        public void write(MAPErrorMessageSubscriberBusyForMtSmsImpl errorMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.write(errorMessage, xml);
            xml.add(errorMessage.getGprsConnectionSuspended(), MAPErrorMessageSubscriberBusyForMtSmsImpl.GPRS_CONNECTION_SUSPENDED, Boolean.class);
            xml.add((MAPExtensionContainerImpl)errorMessage.extensionContainer, MAPErrorMessageSubscriberBusyForMtSmsImpl.MAP_EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
        }
    };

    public MAPErrorMessageSubscriberBusyForMtSmsImpl(MAPExtensionContainer extensionContainer, Boolean gprsConnectionSuspended) {
        super(31L);
        this.extensionContainer = extensionContainer;
        this.gprsConnectionSuspended = gprsConnectionSuspended;
    }

    public MAPErrorMessageSubscriberBusyForMtSmsImpl() {
        super(31L);
    }

    public boolean isEmSubscriberBusyForMtSms() {
        return true;
    }

    public MAPErrorMessageSubscriberBusyForMtSms getEmSubscriberBusyForMtSms() {
        return this;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public Boolean getGprsConnectionSuspended() {
        return this.gprsConnectionSuspended;
    }

    public void setExtensionContainer(MAPExtensionContainer extensionContainer) {
        this.extensionContainer = extensionContainer;
    }

    public void setGprsConnectionSuspended(Boolean gprsConnectionSuspended) {
        this.gprsConnectionSuspended = gprsConnectionSuspended;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MAPErrorMessageSubscriberBusyForMtSms: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MAPErrorMessageSubscriberBusyForMtSms: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MAPErrorMessageSubscriberBusyForMtSms: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MAPErrorMessageSubscriberBusyForMtSms: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream localAis, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.extensionContainer = null;
        this.gprsConnectionSuspended = null;
        if (localAis.getTagClass() != 0 || localAis.getTag() != 16 || localAis.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error decoding MAPErrorMessageSubscriberBusyForMtSms: bad tag class or tag or parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        AsnInputStream ais = localAis.readSequenceStreamData(length);
        block7: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 0: {
                    switch (tag) {
                        case 16: {
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            continue block7;
                        }
                        case 5: {
                            ais.readNull();
                            this.gprsConnectionSuspended = true;
                            continue block7;
                        }
                    }
                    ais.advanceElement();
                    continue block7;
                }
            }
            ais.advanceElement();
        }
        if (this.gprsConnectionSuspended == null) {
            this.gprsConnectionSuspended = false;
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MAPErrorMessageSubscriberBusyForMtSms: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream aos) throws MAPException {
        if (this.gprsConnectionSuspended == null && this.extensionContainer == null) {
            return;
        }
        try {
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(aos);
            }
            if (this.gprsConnectionSuspended != null && this.gprsConnectionSuspended.booleanValue()) {
                aos.writeNull();
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding MAPErrorMessageSubscriberBusyForMtSms: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MAPErrorMessageSubscriberBusyForMtSms: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MAPErrorMessageSubscriberBusyForMtSms [");
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=" + this.extensionContainer.toString());
        }
        if (this.gprsConnectionSuspended != null && this.gprsConnectionSuspended.booleanValue()) {
            sb.append(", gprsConnectionSuspended=true");
        }
        sb.append("]");
        return sb.toString();
    }
}

