/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl;

import javolution.util.FastCollection;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.m3ua.Functionality;
import org.mobicents.protocols.ss7.m3ua.impl.AsImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspState;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSM;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSMState;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.TransitionHandler;
import org.mobicents.protocols.ss7.m3ua.message.mgmt.Notify;
import org.mobicents.protocols.ss7.m3ua.parameter.Status;

public class THLocalAsActToActRemAspAct
implements TransitionHandler {
    private static final Logger logger = Logger.getLogger(THLocalAsActToActRemAspAct.class);
    private AsImpl asImpl = null;
    private FSM fsm;

    public THLocalAsActToActRemAspAct(AsImpl asImpl, FSM fsm) {
        this.asImpl = asImpl;
        this.fsm = fsm;
    }

    @Override
    public boolean process(FSMState state) {
        try {
            if (this.asImpl.getTrafficModeType().getMode() == 3) {
                return false;
            }
            AspImpl remAsp = (AspImpl)this.fsm.getAttribute("asp");
            if (this.asImpl.getTrafficModeType().getMode() == 2 && this.asImpl.getFunctionality() != Functionality.IPSP) {
                FastCollection.Record n = this.asImpl.appServerProcs.head();
                FastCollection.Record end = this.asImpl.appServerProcs.tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    AspImpl remAspImpl = (AspImpl)((FastList.Node)n).getValue();
                    FSM aspPeerFSM = remAspImpl.getPeerFSM();
                    AspState aspState = AspState.getState(aspPeerFSM.getState().getName());
                    if (aspState != AspState.INACTIVE) continue;
                    Notify msg = this.createNotify(remAspImpl, 1, 3);
                    remAspImpl.getAspFactory().write(msg);
                }
            } else if (this.asImpl.getTrafficModeType().getMode() == 1) {
                FastCollection.Record n = this.asImpl.appServerProcs.head();
                FastCollection.Record end = this.asImpl.appServerProcs.tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    AspImpl remAspImpl = (AspImpl)((FastList.Node)n).getValue();
                    FSM aspPeerFSM = remAspImpl.getPeerFSM();
                    AspState aspState = AspState.getState(aspPeerFSM.getState().getName());
                    if (aspState != AspState.ACTIVE || remAspImpl.getName().equals(remAsp.getName())) continue;
                    if (this.asImpl.getFunctionality() != Functionality.IPSP) {
                        Notify msg = this.createNotify(remAspImpl, 2, 2);
                        remAspImpl.getAspFactory().write(msg);
                    }
                    aspPeerFSM.signal("ntfyaltaspact");
                    break;
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.error(String.format("Error while translating Rem AS to INACTIVE. %s", this.fsm.toString()), e);
            return false;
        }
    }

    private Notify createNotify(AspImpl remAsp, int type, int info) {
        Notify msg = (Notify)this.asImpl.getMessageFactory().createMessage(0, 1);
        Status status = this.asImpl.getParameterFactory().createStatus(type, info);
        msg.setStatus(status);
        if (remAsp.getASPIdentifier() != null) {
            msg.setASPIdentifier(remAsp.getASPIdentifier());
        }
        if (this.asImpl.getRoutingContext() != null) {
            msg.setRoutingContext(this.asImpl.getRoutingContext());
        }
        return msg;
    }
}

