/*
 * Decompiled with CFR 0.152.
 */
package s;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import s.IOUtils;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

class Sign {
    private static final String CERT_SF_NAME = "META-INF/CERT.SF";
    private static final String CERT_RSA_NAME = "META-INF/CERT.RSA";
    private static final String OTACERT_NAME = "META-INF/com/android/otacert";
    private static Pattern stripPattern = Pattern.compile("^META-INF/(.*)[.](SF|RSA|DSA)$");
    private static final byte[] publicBytes = IOUtils.toByteArray(Sign.class.getResourceAsStream("/testkey.x509.pem"));
    private static final byte[] privateBytes = IOUtils.toByteArray(Sign.class.getResourceAsStream("/testkey.pk8"));
    private static Pattern endApk = Pattern.compile("\\.apk$");

    Sign() {
    }

    private static X509Certificate readPublicKey() throws IOException, GeneralSecurityException {
        ByteArrayInputStream publicKeyFileIS = new ByteArrayInputStream(publicBytes);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(publicKeyFileIS);
    }

    private static PrivateKey readPrivateKey() throws IOException, GeneralSecurityException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(privateBytes);
        try {
            return KeyFactory.getInstance("RSA").generatePrivate(spec);
        }
        catch (InvalidKeySpecException ex) {
            return KeyFactory.getInstance("DSA").generatePrivate(spec);
        }
    }

    private static Manifest addDigestsToManifest(JarFile jar) throws IOException, GeneralSecurityException {
        Manifest input = jar.getManifest();
        Manifest output = new Manifest();
        Attributes main = output.getMainAttributes();
        if (input != null) {
            main.putAll((Map<?, ?>)input.getMainAttributes());
        } else {
            main.putValue("Manifest-Version", "1.0");
        }
        Base64.Encoder base64 = Base64.getEncoder().withoutPadding();
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] buffer = new byte[4096];
        TreeMap<String, JarEntry> byName = new TreeMap<String, JarEntry>();
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            byName.put(entry.getName(), entry);
        }
        for (JarEntry entry : byName.values()) {
            int num;
            String name = entry.getName();
            if (entry.isDirectory() || name.equals("META-INF/MANIFEST.MF") || name.equals(CERT_SF_NAME) || name.equals(CERT_RSA_NAME) || name.equals(OTACERT_NAME) || stripPattern != null && stripPattern.matcher(name).matches()) continue;
            InputStream data = jar.getInputStream(entry);
            while ((num = data.read(buffer)) > 0) {
                md.update(buffer, 0, num);
            }
            Attributes attr = null;
            if (input != null) {
                attr = input.getAttributes(name);
            }
            attr = attr != null ? new Attributes(attr) : new Attributes();
            attr.putValue("SHA1-Digest", base64.encodeToString(md.digest()));
            output.getEntries().put(name, attr);
        }
        return output;
    }

    private static void addOtacert(JarOutputStream outputJar, long timestamp, Manifest manifest) throws IOException, GeneralSecurityException {
        int read;
        ByteArrayInputStream input = new ByteArrayInputStream(publicBytes);
        Base64.Encoder base64 = Base64.getEncoder().withoutPadding();
        MessageDigest md = MessageDigest.getInstance("SHA1");
        JarEntry je = new JarEntry(OTACERT_NAME);
        je.setTime(timestamp);
        outputJar.putNextEntry(je);
        byte[] b = new byte[4096];
        while ((read = input.read(b)) != -1) {
            outputJar.write(b, 0, read);
            md.update(b, 0, read);
        }
        ((InputStream)input).close();
        Attributes attr = new Attributes();
        attr.putValue("SHA1-Digest", base64.encodeToString(md.digest()));
        manifest.getEntries().put(OTACERT_NAME, attr);
    }

    private static void writeSignatureFile(Manifest manifest, SignatureOutputStream out) throws IOException, GeneralSecurityException {
        Manifest sf = new Manifest();
        Attributes main = sf.getMainAttributes();
        main.putValue("Signature-Version", "1.0");
        Base64.Encoder base64 = Base64.getEncoder().withoutPadding();
        MessageDigest md = MessageDigest.getInstance("SHA1");
        PrintStream print = new PrintStream((OutputStream)new DigestOutputStream(new ByteArrayOutputStream(), md), true, "UTF-8");
        manifest.write(print);
        print.flush();
        main.putValue("SHA1-Digest-Manifest", base64.encodeToString(md.digest()));
        Map<String, Attributes> entries = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
            print.print("Name: " + entry.getKey() + "\r\n");
            for (Map.Entry<Object, Object> att : entry.getValue().entrySet()) {
                print.print(att.getKey() + ": " + att.getValue() + "\r\n");
            }
            print.print("\r\n");
            print.flush();
            Attributes sfAttr = new Attributes();
            sfAttr.putValue("SHA1-Digest", base64.encodeToString(md.digest()));
            sf.getEntries().put(entry.getKey(), sfAttr);
        }
        sf.write(out);
        if (out.size() % 1024 == 0) {
            out.write(13);
            out.write(10);
        }
    }

    private static void writeSignatureBlock(Signature signature, X509Certificate publicKey, OutputStream out) throws IOException, GeneralSecurityException {
        SignerInfo signerInfo = new SignerInfo(new X500Name(publicKey.getIssuerX500Principal().getName()), publicKey.getSerialNumber(), AlgorithmId.get("SHA1"), AlgorithmId.get("RSA"), signature.sign());
        PKCS7 pkcs7 = new PKCS7(new AlgorithmId[]{AlgorithmId.get("SHA1")}, new ContentInfo(ContentInfo.DATA_OID, null), new X509Certificate[]{publicKey}, new SignerInfo[]{signerInfo});
        pkcs7.encodeSignedData(out);
    }

    private static void signWholeOutputFile(byte[] zipData, OutputStream outputStream, X509Certificate publicKey, PrivateKey privateKey) throws IOException, GeneralSecurityException {
        if (zipData[zipData.length - 22] != 80 || zipData[zipData.length - 21] != 75 || zipData[zipData.length - 20] != 5 || zipData[zipData.length - 19] != 6) {
            throw new IllegalArgumentException("zip data already has an archive comment");
        }
        Signature signature = Signature.getInstance("SHA1withRSA");
        signature.initSign(privateKey);
        signature.update(zipData, 0, zipData.length - 2);
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        byte[] message = "signed by SignApk".getBytes("UTF-8");
        temp.write(message);
        temp.write(0);
        Sign.writeSignatureBlock(signature, publicKey, temp);
        int total_size = temp.size() + 6;
        if (total_size > 65535) {
            throw new IllegalArgumentException("signature is too big for ZIP file comment");
        }
        int signature_start = total_size - message.length - 1;
        temp.write(signature_start & 0xFF);
        temp.write(signature_start >> 8 & 0xFF);
        temp.write(255);
        temp.write(255);
        temp.write(total_size & 0xFF);
        temp.write(total_size >> 8 & 0xFF);
        temp.flush();
        byte[] b = temp.toByteArray();
        for (int i = 0; i < b.length - 3; ++i) {
            if (b[i] != 80 || b[i + 1] != 75 || b[i + 2] != 5 || b[i + 3] != 6) continue;
            throw new IllegalArgumentException("found spurious EOCD header at " + i);
        }
        outputStream.write(zipData, 0, zipData.length - 2);
        outputStream.write(total_size & 0xFF);
        outputStream.write(total_size >> 8 & 0xFF);
        temp.writeTo(outputStream);
    }

    private static void copyFiles(Manifest manifest, JarFile in, JarOutputStream out, long timestamp) throws IOException {
        byte[] buffer = new byte[4096];
        Map<String, Attributes> entries = manifest.getEntries();
        ArrayList<String> names = new ArrayList<String>(entries.keySet());
        Collections.sort(names);
        for (String name : names) {
            int num;
            JarEntry inEntry = in.getJarEntry(name);
            JarEntry outEntry = null;
            outEntry = inEntry.getMethod() == 0 ? new JarEntry(inEntry) : new JarEntry(name);
            outEntry.setTime(timestamp);
            out.putNextEntry(outEntry);
            InputStream data = in.getInputStream(inEntry);
            while ((num = data.read(buffer)) > 0) {
                out.write(buffer, 0, num);
            }
            out.flush();
        }
    }

    public static void delete(File file) {
        if (file == null) {
            return;
        }
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void sign(String inputApkPath, boolean override) {
        block26: {
            FileOutputStream outputFile;
            ZipFile inputJar;
            File renamedInput;
            block25: {
                String outputApkPath = endApk.matcher(inputApkPath).replaceAll("") + ".s.apk";
                File input = new File(inputApkPath);
                if (!input.exists() || !input.isFile()) {
                    throw new RuntimeException("Input is not an existing file. " + inputApkPath);
                }
                renamedInput = null;
                if (override) {
                    outputApkPath = inputApkPath;
                    renamedInput = new File(input.getParentFile(), new Date().getTime() + ".tmp");
                    if (!input.renameTo(renamedInput)) {
                        throw new RuntimeException("Unable to rename input apk. " + inputApkPath);
                    }
                    inputApkPath = renamedInput.getAbsolutePath();
                }
                boolean signWholeFile = false;
                inputJar = null;
                JarOutputStream outputJar = null;
                outputFile = null;
                X509Certificate publicKey = Sign.readPublicKey();
                long timestamp = publicKey.getNotBefore().getTime() + 3600000L;
                PrivateKey privateKey = Sign.readPrivateKey();
                inputJar = new JarFile(new File(inputApkPath), false);
                OutputStream outputStream = null;
                if (signWholeFile) {
                    outputStream = new ByteArrayOutputStream();
                } else {
                    outputFile = new FileOutputStream(new File(outputApkPath));
                    outputStream = outputFile;
                }
                outputJar = new JarOutputStream(outputStream);
                outputJar.setLevel(9);
                Manifest manifest = Sign.addDigestsToManifest((JarFile)inputJar);
                Sign.copyFiles(manifest, (JarFile)inputJar, outputJar, timestamp);
                if (signWholeFile) {
                    Sign.addOtacert(outputJar, timestamp, manifest);
                }
                JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
                je.setTime(timestamp);
                outputJar.putNextEntry(je);
                manifest.write(outputJar);
                Signature signature = Signature.getInstance("SHA1withRSA");
                signature.initSign(privateKey);
                je = new JarEntry(CERT_SF_NAME);
                je.setTime(timestamp);
                outputJar.putNextEntry(je);
                Sign.writeSignatureFile(manifest, new SignatureOutputStream(outputJar, signature));
                je = new JarEntry(CERT_RSA_NAME);
                je.setTime(timestamp);
                outputJar.putNextEntry(je);
                Sign.writeSignatureBlock(signature, publicKey, outputJar);
                outputJar.close();
                outputJar = null;
                outputStream.flush();
                if (!signWholeFile) break block25;
                outputFile = new FileOutputStream(outputApkPath);
                Sign.signWholeOutputFile(((ByteArrayOutputStream)outputStream).toByteArray(), outputFile, publicKey, privateKey);
            }
            try {
                if (renamedInput != null) {
                    Sign.delete(renamedInput);
                }
                if (inputJar != null) {
                    inputJar.close();
                }
                if (outputFile != null) {
                    outputFile.close();
                }
                break block26;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            break block26;
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (Throwable throwable) {
                    try {
                        if (renamedInput != null) {
                            Sign.delete(renamedInput);
                        }
                        if (inputJar != null) {
                            inputJar.close();
                        }
                        if (outputFile != null) {
                            outputFile.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        System.exit(1);
                    }
                    throw throwable;
                }
                try {
                    if (renamedInput != null) {
                        Sign.delete(renamedInput);
                    }
                    if (inputJar != null) {
                        inputJar.close();
                    }
                    if (outputFile != null) {
                        outputFile.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java -jar sign.jar my_1.apk [my_2.apk ...] [--override]");
            System.exit(0);
        }
        boolean override = false;
        for (String arg : args) {
            if (!arg.toLowerCase().equals("--override")) continue;
            override = true;
            break;
        }
        for (String apk : args) {
            if (!apk.toLowerCase().endsWith(".apk")) continue;
            Sign.sign(apk, override);
        }
    }

    private static class SignatureOutputStream
    extends FilterOutputStream {
        private Signature mSignature;
        private int mCount;

        public SignatureOutputStream(OutputStream out, Signature sig) {
            super(out);
            this.mSignature = sig;
            this.mCount = 0;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.mSignature.update((byte)b);
            }
            catch (SignatureException e) {
                throw new IOException("SignatureException: " + e);
            }
            super.write(b);
            ++this.mCount;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.mSignature.update(b, off, len);
            }
            catch (SignatureException e) {
                throw new IOException("SignatureException: " + e);
            }
            super.write(b, off, len);
            this.mCount += len;
        }

        public int size() {
            return this.mCount;
        }
    }
}

