/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package uk.co.pentest.SHELLING;

import burp.BinaryPayloadIssue;
import burp.IBurpCollaboratorClientContext;
import burp.IBurpCollaboratorInteraction;
import burp.IScanIssue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListModel;

/**
 *
 * @author julian
 */
public class ShellingPanel2 extends javax.swing.JPanel {
    protected String byteGeneratorRange = "non-alpha";         
    public String mode = "auto";
    public String targetOS = "all";
    public String feedbackChannel = "DNS"; // "DNS" is the other option atm (also planned: response (echo) and filesystem 
    public boolean scannerChecks = true; // whether to automatically extend the active scanning
    protected boolean verboseOutput = false;    
    
    protected IntruderPayloadGenerator curr_generator;
    protected ArrayList<String> payloads;
    
    //public IntruderPayloadGenerator lastGenerator;
    // these need to  be public
    public static ArrayList<collabSession> collabSessions;      // 
    public static IBurpCollaboratorClientContext collabClient;  //	
    
    protected boolean warningDisplayed=false;
    private static long lastCollabSessionCheck=0;
    private static int collabSessionCheckThreshold=30;          // what is the maximum frequency of checkCollabInteractions in seconds
    
    protected String editorFormat="HEX";
    // this thing can poll the collaborator API multiple times once many scan threads kick in
    // we don't need this check intensivity for asynchronous interactions
    // by the way, maybe this will help us to get rid of the DNS issues being split between sets of payloads (when multiple payloads were successful).
        
    // We want to maintain this structure between the scans/intruder runs. The intention is as follows:    
    // 1. do not miss asynchronous injections, regardless to them being hit by scanner or intruder!
    // 2. thus, we can generate a new collabLoc for every single attack (active scan + intruder check + export - because why not).
    // 
    // The collabLoc will be used to match the collabSession, which in turn will contain more info about the attack (to reconstruct the valid request - we are definitely not going to store all the requests/responses in the memory for the puroose of tracking):
    // it would be, by the way, cool if Collaborator provided a nice way to use subdomains through collaborator API to track payloads
    // otherwise in order to identify a payload we have to assign a separate collabLoc per each one of them, which in our case might be way too many...?
    // I wonder how exactly Burp Scanner does it (match the right request) when using collaborator - cause it's capable of detecting asynchronous stuff, 
    // reverse lookups issued after hours pop up as External DNS interactions/OS command injections ;)
    
    // Per every single attack (Intruder attack/export/Active scan) - if auto mode is enabled - a new collabSession will be created and held until the plugin is unloaded:
    // timestamp of start
    // type of session (intruder/scanner/export)
    // configuration (so it should be easier to make sure we know where PAYLOAD_MARK points at)?
    // collabLoc - the ID generated by the Collaborator Server (the subdomain in burpcollaborator.net)
    // IHttpRequestResponse req - this will either contain the baseRequest provided to doActiveScan - or IIntruderAttack.getTemplateRequest() in case of Intruder, will be null for exports
    // what about including the shellings_raw payload set to it? this would make the payload matching accurate and should not be too mem-greey with reasonable configurations :D
    
    
    PrintWriter stdout;
    /**
     * Creates new form ShellingPanel2
     */
    public ShellingPanel2() 
    {      
        // activate the collaborator client
        this.flushThetracker();

        
        // set extension output
        stdout = new PrintWriter(SHELLING.callbacks.getStdout(), true);
        
        // init the UI
        initComponents();                
        
        // enable "auto" mode for Intruder and export
        this.enableAuto();                                             
    }
    public int getDelay()
    {        
        return Integer.parseInt(this.delayTimeSpinner.getValue().toString());        
    }
    protected void appendListData(JList list, String[] items)
    {
        ArrayList tmp = new ArrayList();

         for (int i=0; i < list.getModel().getSize(); i++) {
            String elem = (String) list.getModel().getElementAt(i);           
            tmp.add(elem);
        }
        for(String item: items)
        {
            if(!tmp.contains(item)) tmp.add(item);
        }
        list.setListData(tmp.toArray());
    }
    private void removeFromListData(JList list, String item)
    {
        ArrayList tmp = new ArrayList();

         for (int i=0; i < list.getModel().getSize(); i++) {
            String elem = (String) list.getModel().getElementAt(i); 
            if(!elem.equals(item)) tmp.add(elem);
        }
        list.setListData(tmp.toArray());
    }
    private void initiateEncodings() // same as clear, no encoding by default
    {
        String empty[] = {"None"};
        encodeList.setListData(empty);
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        buttonGroup2 = new javax.swing.ButtonGroup();
        jCheckBox5 = new javax.swing.JCheckBox();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        targetOSCombo = new javax.swing.JComboBox<>();
        jLabel4 = new javax.swing.JLabel();
        argumentField = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        commandField = new javax.swing.JTextField();
        payloadMarkingBox = new javax.swing.JCheckBox();
        scannerChecksBox = new javax.swing.JCheckBox();
        feedbackChannelCombo = new javax.swing.JComboBox<>();
        jLabel7 = new javax.swing.JLabel();
        delayTimeSpinner = new javax.swing.JSpinner();
        jLabel10 = new javax.swing.JLabel();
        manualModeCheckBox = new javax.swing.JCheckBox();
        stopAllRunningScans = new javax.swing.JCheckBox();
        panel1 = new java.awt.Panel();
        doCommandInjection = new javax.swing.JCheckBox();
        advancedPayloadLabel = new javax.swing.JLabel();
        basePayloadCheckBox = new javax.swing.JCheckBox();
        secondBasePayloadCheckBox = new javax.swing.JCheckBox();
        thirdBasePayloadCheckBox = new javax.swing.JCheckBox();
        fourthBasePayloadCheckBox = new javax.swing.JCheckBox();
        fifthBasePayloadCheckBox = new javax.swing.JCheckBox();
        seventhBasePayloadCheckBox = new javax.swing.JCheckBox();
        sixthBasePayloadCheckBox = new javax.swing.JCheckBox();
        eightBasePayloadCheckBox = new javax.swing.JCheckBox();
        jPanel5 = new javax.swing.JPanel();
        argInjectionCheckBox = new javax.swing.JCheckBox();
        fixedArguments = new javax.swing.JCheckBox();
        bruteArgInjections = new javax.swing.JCheckBox();
        injectHTTPCheckBox = new javax.swing.JCheckBox();
        injectFileCheckBox = new javax.swing.JCheckBox();
        uncPathsCheckBox = new javax.swing.JCheckBox();
        injectSmbCheckBox = new javax.swing.JCheckBox();
        injectUncCheckBox = new javax.swing.JCheckBox();
        jLabel6 = new javax.swing.JLabel();
        injectAdditionalArguments = new javax.swing.JCheckBox();
        jLabel11 = new javax.swing.JLabel();
        defaultArgBruteRange = new javax.swing.JRadioButton();
        customArgBruteRange = new javax.swing.JRadioButton();
        customCharacterRange = new javax.swing.JTextField();
        jPanel6 = new javax.swing.JPanel();
        doTerminalInjection = new javax.swing.JCheckBox();
        jPanel2 = new javax.swing.JPanel();
        jLabel9 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        encodeList = new javax.swing.JList<>();
        encodingsToUse = new javax.swing.JComboBox<>();
        removeEncoding = new javax.swing.JButton();
        jButton4 = new javax.swing.JButton();
        useTerminatorsCheckBox = new javax.swing.JCheckBox();
        includeLiteralWhites = new javax.swing.JCheckBox();
        includeThePooComboBox = new javax.swing.JCheckBox();
        osSpecificTerminators = new javax.swing.JCheckBox();
        jScrollPane3 = new javax.swing.JScrollPane();
        terminatorList = new javax.swing.JList<>();
        removeTerminatorButton = new javax.swing.JButton();
        addTerminatorButton = new javax.swing.JButton();
        addTerminatorField = new javax.swing.JTextField();
        jLabel13 = new javax.swing.JLabel();
        terminatorASCIIFormat = new javax.swing.JRadioButton();
        terminatorHexFormat = new javax.swing.JRadioButton();
        jLabel8 = new javax.swing.JLabel();
        useNullByte = new javax.swing.JCheckBox();
        smart400Avoidance = new javax.swing.JCheckBox();
        jPanel3 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        saveToFileButton = new javax.swing.JButton();
        saveToClipBoardButton = new javax.swing.JButton();
        advancedPanel = new javax.swing.JPanel();
        verboseOutputCheckBox = new javax.swing.JCheckBox();
        checkForInteractions = new javax.swing.JButton();
        flushTheTrackerButton = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        byteGeneratorRangeCombo = new javax.swing.JComboBox<>();

        jCheckBox5.setText("jCheckBox5");

        jLabel3.setText("Command to use");

        targetOSCombo.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "All (default)", "Windows", "Nix" }));
        targetOSCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                targetOSComboActionPerformed(evt);
            }
        });

        jLabel4.setText("Target OS");

        argumentField.setText("PAYLOAD_MARK.BURP_COLLAB_DOMAIN");
        argumentField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                ShellingPanel2.this.keyReleased(evt);
            }
        });

        jLabel5.setText("Argument");

        commandField.setText("nslookup");

        payloadMarkingBox.setSelected(true);
        payloadMarkingBox.setText("Payload marking");
        payloadMarkingBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                payloadMarkingBoxActionPerformed(evt);
            }
        });

        scannerChecksBox.setSelected(true);
        scannerChecksBox.setText("Active scanning");
        scannerChecksBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                scannerChecksBoxActionPerformed(evt);
            }
        });

        feedbackChannelCombo.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "DNS (collaborator)", "Delay (sleep)" }));
        feedbackChannelCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                feedbackChannelComboActionPerformed(evt);
            }
        });

        jLabel7.setText("Feedback channel");

        delayTimeSpinner.setModel(new javax.swing.SpinnerNumberModel(25, 10, null, 1));
        delayTimeSpinner.setEnabled(false);
        delayTimeSpinner.setValue(25);

        jLabel10.setText("Delay [s]");

        manualModeCheckBox.setToolTipText("");
        manualModeCheckBox.setLabel("Manual (non-auto) mode for Intruder & export  (please refer the documentation for details)");
        manualModeCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                manualModeCheckBoxActionPerformed(evt);
            }
        });

        stopAllRunningScans.setText("Stop all running scans");
        stopAllRunningScans.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                stopAllRunningScansActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(manualModeCheckBox, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                        .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, 235, Short.MAX_VALUE)
                                        .addComponent(jLabel5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                                    .addComponent(jLabel4, javax.swing.GroupLayout.PREFERRED_SIZE, 249, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(targetOSCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 292, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(commandField, javax.swing.GroupLayout.PREFERRED_SIZE, 297, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(argumentField, javax.swing.GroupLayout.PREFERRED_SIZE, 564, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(jLabel7, javax.swing.GroupLayout.PREFERRED_SIZE, 374, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(32, 32, 32)
                                .addComponent(feedbackChannelCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 401, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addGap(28, 28, 28)
                        .addComponent(jLabel10, javax.swing.GroupLayout.PREFERRED_SIZE, 138, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(delayTimeSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, 84, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(0, 747, Short.MAX_VALUE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(payloadMarkingBox, javax.swing.GroupLayout.PREFERRED_SIZE, 307, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(107, 107, 107)
                        .addComponent(scannerChecksBox, javax.swing.GroupLayout.PREFERRED_SIZE, 330, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(stopAllRunningScans, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGap(9, 9, 9)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(targetOSCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel4, javax.swing.GroupLayout.PREFERRED_SIZE, 35, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 35, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(commandField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(argumentField)
                    .addComponent(jLabel5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addGap(18, 18, 18)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(payloadMarkingBox)
                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(scannerChecksBox, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(stopAllRunningScans)))
                .addGap(8, 8, 8)
                .addComponent(manualModeCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel10, javax.swing.GroupLayout.PREFERRED_SIZE, 35, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(delayTimeSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                        .addComponent(jLabel7, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(feedbackChannelCombo, javax.swing.GroupLayout.Alignment.LEADING)))
                .addGap(0, 505, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Global settings", jPanel1);

        doCommandInjection.setSelected(true);
        doCommandInjection.setText("Test for command injection");
        doCommandInjection.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                doCommandInjectionActionPerformed(evt);
            }
        });

        advancedPayloadLabel.setText("Use the following syntaxes (see the manual for details on base syntaxes)");

        basePayloadCheckBox.setSelected(true);
        basePayloadCheckBox.setText("COMMAND (this is the base payload (don't uncheck unless you know what you're doing)");

        secondBasePayloadCheckBox.setText("COMMAND + COMMAND_TERMINATOR");

        thirdBasePayloadCheckBox.setText("COMMAND_SEPARATOR + COMMAND");

        fourthBasePayloadCheckBox.setText("COMMAND_SEPARATOR + COMMAND + COMMAND_SEPARATOR");

        fifthBasePayloadCheckBox.setText("COMMAND_SEPARATOR + COMMAND + COMMAND_SEPARATOR + SUFFIX ");

        seventhBasePayloadCheckBox.setSelected(true);
        seventhBasePayloadCheckBox.setText("PREFIX + COMMAND_SEPARATOR + COMMAND + COMMAND_SEPARATOR + SUFFIX");

        sixthBasePayloadCheckBox.setText("PREFIX + COMMAND_SEPARATOR + COMMAND + COMMAND_SEPARATOR");

        eightBasePayloadCheckBox.setText("PREFIX + COMMAND + SUFFIX");

        javax.swing.GroupLayout panel1Layout = new javax.swing.GroupLayout(panel1);
        panel1.setLayout(panel1Layout);
        panel1Layout.setHorizontalGroup(
            panel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(panel1Layout.createSequentialGroup()
                        .addGroup(panel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(basePayloadCheckBox, javax.swing.GroupLayout.DEFAULT_SIZE, 1040, Short.MAX_VALUE)
                            .addComponent(advancedPayloadLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(doCommandInjection, javax.swing.GroupLayout.DEFAULT_SIZE, 1031, Short.MAX_VALUE)
                            .addComponent(secondBasePayloadCheckBox, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(thirdBasePayloadCheckBox, javax.swing.GroupLayout.DEFAULT_SIZE, 1040, Short.MAX_VALUE)
                            .addComponent(fourthBasePayloadCheckBox, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(fifthBasePayloadCheckBox, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addGap(0, 794, Short.MAX_VALUE))
                    .addComponent(seventhBasePayloadCheckBox, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(sixthBasePayloadCheckBox, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(eightBasePayloadCheckBox, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        panel1Layout.setVerticalGroup(
            panel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(doCommandInjection)
                .addGap(18, 18, 18)
                .addComponent(advancedPayloadLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(basePayloadCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(secondBasePayloadCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(thirdBasePayloadCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(fourthBasePayloadCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(fifthBasePayloadCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(sixthBasePayloadCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(seventhBasePayloadCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(eightBasePayloadCheckBox)
                .addContainerGap(417, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Command injection", panel1);

        argInjectionCheckBox.setText("Test for argument injection");
        argInjectionCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                argInjectionCheckBoxActionPerformed(evt);
            }
        });

        fixedArguments.setText("Check known injections");
        fixedArguments.setEnabled(false);
        fixedArguments.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fixedArgumentsActionPerformed(evt);
            }
        });

        bruteArgInjections.setSelected(true);
        bruteArgInjections.setText("Brute force argument flags");
        bruteArgInjections.setEnabled(false);
        bruteArgInjections.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bruteArgInjectionsActionPerformed(evt);
            }
        });

        injectHTTPCheckBox.setSelected(true);
        injectHTTPCheckBox.setText("http://BURP_COLLAB_DOMAIN/a");
        injectHTTPCheckBox.setEnabled(false);
        injectHTTPCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                injectHTTPCheckBoxActionPerformed(evt);
            }
        });

        injectFileCheckBox.setSelected(true);
        injectFileCheckBox.setText("file://BURP_COLLAB_DOMAIN/a");
        injectFileCheckBox.setEnabled(false);

        uncPathsCheckBox.setSelected(true);
        uncPathsCheckBox.setText(">\\\\BURP_COLLAB_DOMAIN\\o");
        uncPathsCheckBox.setEnabled(false);

        injectSmbCheckBox.setText("smb://BURP_COLLAB_DOMAIN/a");
        injectSmbCheckBox.setEnabled(false);

        injectUncCheckBox.setSelected(true);
        injectUncCheckBox.setText("\\\\BURP_COLLAB_DOMAIN\\a");
        injectUncCheckBox.setToolTipText("UNC paths");
        injectUncCheckBox.setEnabled(false);

        jLabel6.setText("Use the following argument values");

        injectAdditionalArguments.setSelected(true);
        injectAdditionalArguments.setText("Inject additional arguments directly (without flags)");
        injectAdditionalArguments.setEnabled(false);
        injectAdditionalArguments.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                injectAdditionalArgumentsActionPerformed(evt);
            }
        });

        jLabel11.setText("win-specific");

        defaultArgBruteRange.setSelected(true);
        defaultArgBruteRange.setText("Default range (a-zA-Z, LOTS of payloads)");
        defaultArgBruteRange.setEnabled(false);
        defaultArgBruteRange.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                defaultArgBruteRangeActionPerformed(evt);
            }
        });

        customArgBruteRange.setText("Custom character range:");
        customArgBruteRange.setEnabled(false);
        customArgBruteRange.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                customArgBruteRangeActionPerformed(evt);
            }
        });

        customCharacterRange.setText("abcdefghijklmnroqprstuvxyzACDEEFGHIJCKLMNROQPRSTUVXYZ");
        customCharacterRange.setEnabled(false);

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel5Layout.createSequentialGroup()
                                .addContainerGap()
                                .addComponent(fixedArguments, javax.swing.GroupLayout.PREFERRED_SIZE, 463, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(jLabel11, javax.swing.GroupLayout.PREFERRED_SIZE, 256, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(37, 37, 37)
                        .addComponent(argInjectionCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, 388, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(uncPathsCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, 467, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(jPanel5Layout.createSequentialGroup()
                                .addGap(486, 486, 486)
                                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(jPanel5Layout.createSequentialGroup()
                                        .addGap(14, 14, 14)
                                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(injectAdditionalArguments, javax.swing.GroupLayout.PREFERRED_SIZE, 626, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addComponent(bruteArgInjections, javax.swing.GroupLayout.PREFERRED_SIZE, 477, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                    .addGroup(jPanel5Layout.createSequentialGroup()
                                        .addGap(18, 18, 18)
                                        .addComponent(defaultArgBruteRange, javax.swing.GroupLayout.PREFERRED_SIZE, 721, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                        .addComponent(injectHTTPCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, 601, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(injectSmbCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, 618, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(injectFileCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, 640, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addGroup(jPanel5Layout.createSequentialGroup()
                                            .addComponent(customArgBruteRange, javax.swing.GroupLayout.PREFERRED_SIZE, 379, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addGap(18, 18, 18)
                                            .addComponent(customCharacterRange, javax.swing.GroupLayout.PREFERRED_SIZE, 283, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addComponent(jLabel6, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(injectUncCheckBox, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))))))
                .addContainerGap(621, Short.MAX_VALUE))
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(argInjectionCheckBox)
                    .addComponent(fixedArguments))
                .addGap(6, 6, 6)
                .addComponent(jLabel11)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(uncPathsCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(injectAdditionalArguments)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(bruteArgInjections)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(defaultArgBruteRange)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(customArgBruteRange)
                    .addComponent(customCharacterRange, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel6)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(injectHTTPCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(injectSmbCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(injectFileCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(injectUncCheckBox)
                .addContainerGap(368, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Argument injection", jPanel5);

        doTerminalInjection.setText("Test for terminal injection");
        doTerminalInjection.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                doTerminalInjectionActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addGap(20, 20, 20)
                .addComponent(doTerminalInjection, javax.swing.GroupLayout.PREFERRED_SIZE, 1091, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(747, Short.MAX_VALUE))
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(doTerminalInjection)
                .addContainerGap(713, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Terminal injection", jPanel6);

        jLabel9.setText("Output encodings to use");

        encodeList.setModel(new javax.swing.AbstractListModel<String>() {
            String[] strings = { "URL" };
            public int getSize() { return strings.length; }
            public String getElementAt(int i) { return strings[i]; }
        });
        jScrollPane1.setViewportView(encodeList);

        encodingsToUse.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "URL (default)", "None", "Double URL" }));
        encodingsToUse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                encodingsToUseActionPerformed(evt);
            }
        });

        removeEncoding.setText("Remove");
        removeEncoding.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeEncodingActionPerformed(evt);
            }
        });

        jButton4.setText("Clear");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });

        useTerminatorsCheckBox.setSelected(true);
        useTerminatorsCheckBox.setText("Try to terminate strings");
        useTerminatorsCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                useTerminatorsCheckBoxActionPerformed(evt);
            }
        });

        includeLiteralWhites.setSelected(true);
        includeLiteralWhites.setText("Include literal space/null/newline/tab");
        includeLiteralWhites.setActionCommand("Include literal white chars (space, tab, newline, nullbyte)");
        includeLiteralWhites.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                includeLiteralWhitesActionPerformed(evt);
            }
        });

        includeThePooComboBox.setText("Include the 💩 (POO) character as terminator");

        osSpecificTerminators.setSelected(true);
        osSpecificTerminators.setText("Include OS-specific terminators (nix \"#', win \"::\") ");

        jScrollPane3.setViewportView(terminatorList);

        removeTerminatorButton.setText("Remove selected");
        removeTerminatorButton.setEnabled(false);
        removeTerminatorButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeTerminatorButtonActionPerformed(evt);
            }
        });

        addTerminatorButton.setText("Add");
        addTerminatorButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addTerminatorButtonActionPerformed(evt);
            }
        });

        jLabel13.setText("List editor display & input format:");

        terminatorASCIIFormat.setText("ASCII");
        terminatorASCIIFormat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                terminatorASCIIFormatActionPerformed(evt);
            }
        });

        terminatorHexFormat.setSelected(true);
        terminatorHexFormat.setText("HEX");
        terminatorHexFormat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                terminatorHexFormatActionPerformed(evt);
            }
        });

        jLabel8.setText("Define custom string terminators:");

        useNullByte.setSelected(true);
        useNullByte.setText("Use NULL byte");

        smart400Avoidance.setSelected(true);
        smart400Avoidance.setText("Use smart 400 Bad request avoidance (Scanner only)");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 679, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(encodingsToUse, javax.swing.GroupLayout.PREFERRED_SIZE, 213, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(29, 29, 29)
                        .addComponent(removeEncoding, javax.swing.GroupLayout.PREFERRED_SIZE, 176, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(77, 77, 77)
                        .addComponent(jButton4, javax.swing.GroupLayout.PREFERRED_SIZE, 174, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jLabel9, javax.swing.GroupLayout.PREFERRED_SIZE, 706, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(includeLiteralWhites, javax.swing.GroupLayout.PREFERRED_SIZE, 672, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(smart400Avoidance, javax.swing.GroupLayout.PREFERRED_SIZE, 663, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(33, 33, 33)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(useNullByte, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(removeTerminatorButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jScrollPane3)
                    .addComponent(osSpecificTerminators, javax.swing.GroupLayout.DEFAULT_SIZE, 785, Short.MAX_VALUE)
                    .addComponent(includeThePooComboBox, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel13, javax.swing.GroupLayout.PREFERRED_SIZE, 554, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(useTerminatorsCheckBox, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(addTerminatorButton)
                        .addGap(18, 18, 18)
                        .addComponent(addTerminatorField, javax.swing.GroupLayout.PREFERRED_SIZE, 505, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(terminatorASCIIFormat)
                        .addGap(18, 18, 18)
                        .addComponent(terminatorHexFormat)))
                .addContainerGap(322, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(useTerminatorsCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, 37, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(includeThePooComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(osSpecificTerminators)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(useNullByte)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel8, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 104, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(removeTerminatorButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(addTerminatorButton)
                    .addComponent(addTerminatorField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel13)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(terminatorASCIIFormat)
                    .addComponent(terminatorHexFormat))
                .addContainerGap(323, Short.MAX_VALUE))
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(jLabel9, javax.swing.GroupLayout.PREFERRED_SIZE, 36, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(13, 13, 13)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 87, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(encodingsToUse, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(removeEncoding)
                    .addComponent(jButton4))
                .addGap(26, 26, 26)
                .addComponent(includeLiteralWhites, javax.swing.GroupLayout.PREFERRED_SIZE, 37, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(smart400Avoidance)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Evasive techniques", jPanel2);

        jLabel2.setText("Instead of feeding the tools, save the result payload set:");

        saveToFileButton.setText("To file");
        saveToFileButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveToFileButtonActionPerformed(evt);
            }
        });

        saveToClipBoardButton.setText("To clipboard");
        saveToClipBoardButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveToClipBoardButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 932, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(saveToFileButton, javax.swing.GroupLayout.PREFERRED_SIZE, 213, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(31, 31, 31)
                        .addComponent(saveToClipBoardButton, javax.swing.GroupLayout.PREFERRED_SIZE, 213, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(914, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGap(21, 21, 21)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(saveToFileButton, javax.swing.GroupLayout.PREFERRED_SIZE, 41, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(saveToClipBoardButton, javax.swing.GroupLayout.PREFERRED_SIZE, 41, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(655, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Save the payloads", jPanel3);

        verboseOutputCheckBox.setText("Verbose extension output");
        verboseOutputCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                verboseOutputCheckBoxActionPerformed(evt);
            }
        });

        checkForInteractions.setText("Check for new collaborator interactions now");
        checkForInteractions.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                checkForInteractionsActionPerformed(evt);
            }
        });

        flushTheTrackerButton.setText("Reset collaborator session tracker (only if you know what you are doing)");
        flushTheTrackerButton.setToolTipText("");
        flushTheTrackerButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                flushTheTrackerButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout advancedPanelLayout = new javax.swing.GroupLayout(advancedPanel);
        advancedPanel.setLayout(advancedPanelLayout);
        advancedPanelLayout.setHorizontalGroup(
            advancedPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(advancedPanelLayout.createSequentialGroup()
                .addGroup(advancedPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, advancedPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(checkForInteractions, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, advancedPanelLayout.createSequentialGroup()
                        .addGap(20, 20, 20)
                        .addComponent(verboseOutputCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, 935, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, advancedPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(flushTheTrackerButton, javax.swing.GroupLayout.DEFAULT_SIZE, 1013, Short.MAX_VALUE)))
                .addContainerGap(833, Short.MAX_VALUE))
        );
        advancedPanelLayout.setVerticalGroup(
            advancedPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(advancedPanelLayout.createSequentialGroup()
                .addGap(28, 28, 28)
                .addComponent(verboseOutputCheckBox)
                .addGap(18, 18, 18)
                .addComponent(checkForInteractions, javax.swing.GroupLayout.PREFERRED_SIZE, 67, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(flushTheTrackerButton, javax.swing.GroupLayout.PREFERRED_SIZE, 66, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(528, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Advanced", advancedPanel);

        jLabel1.setText("Byte range");

        byteGeneratorRangeCombo.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "Non-alphanumeric", "Alphanumeric", "Non-alphanumeric printable", "Non-alphanumeric non-printable", "Non-alphanumeric non-printable <128", "All" }));
        byteGeneratorRangeCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                byteGeneratorRangeComboActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 209, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(byteGeneratorRangeCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 751, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(874, Short.MAX_VALUE))
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(byteGeneratorRangeCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 43, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(695, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Byte generator", jPanel4);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jTabbedPane1)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jTabbedPane1, javax.swing.GroupLayout.Alignment.TRAILING)
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
        
        initiateEncodings();
    }//GEN-LAST:event_jButton4ActionPerformed

    private void targetOSComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_targetOSComboActionPerformed
        // TODO add your handling code here:
        switch(targetOSCombo.getSelectedIndex())
        { 
            case 0 : { this.targetOS="all"; break;}
            case 1 : { this.targetOS="win"; break;}
            case 2 : { this.targetOS="nix"; break;}
        }     
    }//GEN-LAST:event_targetOSComboActionPerformed

    private void feedbackChannelComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_feedbackChannelComboActionPerformed
       
        delayTimeSpinner.setEnabled(false);
        switch(feedbackChannelCombo.getSelectedIndex())
        { 
            case 0 : { this.feedbackChannel="DNS"; break;}
            case 1 : { this.feedbackChannel="time"; delayTimeSpinner.setEnabled(true); break;}  
            // case 2 : { this.feedbackChannel="filesystem"; break; } //
            // there also SHOULD be the 'echo' feedback channel supported
            // case 3 : { this.feedbackChannel="echo"; break; } // no asynchronous payload tracking
        }
    }//GEN-LAST:event_feedbackChannelComboActionPerformed
    private void updatePayloadMarkingHolder()
    {
        String dot="";
        if(this.feedbackChannel=="DNS")
        {
            dot=".";
        }
        if(payloadMarkingBox.isSelected()) 
        {//checkbox has been selected
            if(!this.argumentField.getText().contains("PAYLOAD_MARK"))
            {
                this.argumentField.setText("PAYLOAD_MARK"+dot+argumentField.getText()); 
            }                
        } 
        else
        {
            if(this.argumentField.getText().contains("PAYLOAD_MARK"))
            {
                this.argumentField.setText(argumentField.getText().replace("PAYLOAD_MARK"+dot,""));
            }
        }        
    }
    private void payloadMarkingBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_payloadMarkingBoxActionPerformed
       updatePayloadMarkingHolder();
    }//GEN-LAST:event_payloadMarkingBoxActionPerformed

    private void scannerChecksBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_scannerChecksBoxActionPerformed
        // TODO add your handling code here:
        if(scannerChecksBox.isSelected())
        {
            scannerChecks=true;
        }
        else
        {
            scannerChecks=false;
        }
    }//GEN-LAST:event_scannerChecksBoxActionPerformed

    private void removeEncodingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeEncodingActionPerformed
       
        if(encodeList.getSelectedIndex()!=-1) removeFromListData(encodeList,(String)encodeList.getModel().getElementAt(encodeList.getSelectedIndex()));                                
        if(encodeList.getModel().getSize()==0) this.initiateEncodings();
    }//GEN-LAST:event_removeEncodingActionPerformed

    private void encodingsToUseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_encodingsToUseActionPerformed
        
        switch(encodingsToUse.getSelectedIndex())
        { 
            case 0 : { 
                this.initiateEncodings(); break;
            }
            case 1 : { String n[]={"URL"}; appendListData(encodeList,n); break;}
            case 2 : { String n[]={"Double URL"}; appendListData(encodeList,n);  break;}
        }
    }//GEN-LAST:event_encodingsToUseActionPerformed

    private void byteGeneratorRangeComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_byteGeneratorRangeComboActionPerformed
        // TODO add your handling code here:
        switch (byteGeneratorRangeCombo.getSelectedIndex()) 
        {
            case 0:
            {
                this.byteGeneratorRange = "non-alpha";
                break;
            }
            case 1:
            {
                this.byteGeneratorRange = "alpha";           
                break;
            }
            case 2:
            {
                this.byteGeneratorRange = "non-alpha-print";
                break;
            }
            case 3:
            {
                this.byteGeneratorRange = "non-alpha-non-print";
                break;
            }
            case 4:
            {
                this.byteGeneratorRange = "non-alpha-non-print-low";
                break;
            }
            case 5:
            {
                this.byteGeneratorRange = "all";
                break;
            }
        }
    }//GEN-LAST:event_byteGeneratorRangeComboActionPerformed

    // this method simply runs a new payload generator, runs it and fills this.payloads with its results
    // used by save to file/copy to clipboard features
    protected void generatePayloads()
    {
        // now, for some reason this instance creation hangs burp
        IntruderPayloadGenerator generator = new IntruderPayloadGenerator("cmd", SHELLING.ShellingTab, "export", null, "<export>");               
       // this.lastGenerator  = generator; // 
        payloads = new ArrayList();                
        while(generator.hasMorePayloads())
        {
            byte[] empty={};
            byte[] payload = generator.getNextPayload(empty); 
            // there is no insertion point for this option; the insertion point is the file/clipboard
            // hence the argument is empty, but could be the file name as well                  
            if(payload.length==1) 
            { //payload generation failed, move onto next command
		logOutput("Payload generation failed!");			                        
            }                                        
            payloads.add(SHELLING.callbacks.getHelpers().bytesToString(payload));
            // bytesToString                    
        }
        //jTabbedPane1.setTitleAt(5,"Save "+payloads.size()+" payloads");
    }    
    
    private void saveToFileButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveToFileButtonActionPerformed
        // TODO add your handling code here:
                // save payloads to file
        JFileChooser fileChooser = new JFileChooser();
                     
        if (fileChooser.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) 
        {
            // new generator
            File file = fileChooser.getSelectedFile();
            logOutput("File chosen:"+file.getAbsolutePath());   
            
            this.generatePayloads();            

            logOutput("Generated "+payloads.size()+" payloads, saving..."); 
           
            BufferedWriter writer = null;
            try
            {
                writer = new BufferedWriter( new FileWriter(file.getAbsolutePath()));
                for(int i=0;i<payloads.size();i++)
                {
                    writer.write(payloads.get(i)+"\n"); // payloads with literals like newline characters will break this format, obviously (no such payloads in the set by default)
                }
            }
            catch (IOException e)
            {
                this.logOutput("IOException occurred while trying to open the file: "+file.getAbsolutePath());
            }
            finally
            {
                try
                {
                    if ( writer != null)
                    writer.close( );
                }
                catch ( IOException e)
                {
                    this.logOutput("IOException occurred while writing to the file: "+file.getAbsolutePath());
                }
            }           
        }
    }//GEN-LAST:event_saveToFileButtonActionPerformed

    private void saveToClipBoardButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveToClipBoardButtonActionPerformed
        // TODO add your handling code here:
        if(this.useTerminatorsCheckBox.isSelected()==true&&this.includeLiteralWhites.isSelected()==true)
        {
            JOptionPane.showMessageDialog(null, "Literal NULLBYTE terminators are enabled and this will most likely break the contents copied into the clipboard. To avoid this issue, save into a file instead or disable NULLBYTE terminators in evasive techniques.", "Payload set contains NULL bytes", JOptionPane.INFORMATION_MESSAGE);            
        }
        
        this.generatePayloads();
       
        
        String clipboardS="";
        for(int i=0;i<payloads.size();i++)
        {
            clipboardS+=payloads.get(i)+"\n"; // payloads with literals like newline characters will break this format, obviously (no such payloads in the set by default)
        };
        
        StringSelection selection;
        selection = new StringSelection(clipboardS);
                
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }//GEN-LAST:event_saveToClipBoardButtonActionPerformed

    private void useTerminatorsCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_useTerminatorsCheckBoxActionPerformed
        // TODO add your handling code here:
        if(useTerminatorsCheckBox.isSelected())
        {            
            includeThePooComboBox.setEnabled(true);
            osSpecificTerminators.setEnabled(true);            
            terminatorList.setEnabled(true);
            removeTerminatorButton.setEnabled(true);
            addTerminatorButton.setEnabled(true);
            addTerminatorField.setEnabled(true);
            terminatorASCIIFormat.setEnabled(true);
            terminatorHexFormat.setEnabled(true);
            useNullByte.setEnabled(true);
            
        }
        else
        {
            includeThePooComboBox.setEnabled(false);
            osSpecificTerminators.setEnabled(false);
            terminatorList.setEnabled(false);
            removeTerminatorButton.setEnabled(false);
            addTerminatorButton.setEnabled(false);
            addTerminatorField.setEnabled(false);
            terminatorASCIIFormat.setEnabled(false);
            terminatorHexFormat.setEnabled(false);            
            useNullByte.setEnabled(false);
        }
    }//GEN-LAST:event_useTerminatorsCheckBoxActionPerformed

    private void keyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_keyReleased
        // TODO add your handling code here:
        if(argumentField.getText().matches("^\\d+.*$")&&this.mode=="manual")
        {
            JOptionPane.showMessageDialog(argumentField,"WARNING: It is NOT recommended to use arguments starting with numbers for nix targets (this WILL make all $IFS$9 payloads FAIL)!");
        }
    }//GEN-LAST:event_keyReleased

    public boolean containsBaddies(byte[] payload)
    {
        for(int l=0;l<payload.length;l++)
        { 
            if(payload[l]==(byte)0x00||payload[l]==(byte)0x09||payload[l]==(byte)0x0a||payload[l]==(byte)0x20||payload[l]==(byte)0x1a||payload[l]==(byte)0x0b)
            {
                return true;
            }
        }
        return false;
    }
    private void argInjectionCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_argInjectionCheckBoxActionPerformed
        // TODO add your handling code here:
        if(argInjectionCheckBox.isSelected())
        {
            bruteArgInjections.setEnabled(true);
            fixedArguments.setEnabled(true);      
           // doOnlyArgumentInjection.setEnabled(true);  
            injectAdditionalArguments.setEnabled(true);
            injectHTTPCheckBox.setEnabled(true);
            injectSmbCheckBox.setEnabled(true);
            injectFileCheckBox.setEnabled(true);
            injectUncCheckBox.setEnabled(true);
            //maliciousCommandArgument.setEnabled(true);                        
            
            if(this.fixedArguments.isSelected())
            {
                //injectCSwitchCheckBox.setEnabled(true);
                uncPathsCheckBox.setEnabled(true);            
                //hijackOutputNixCheckBox.setEnabled(true);
                //oOutputFlagHijackCheckBox.setEnabled(true);
                //findExecInjectCheckBox.setEnabled(true);    
            }
            if(this.bruteArgInjections.isSelected())
            {
                // enable the radio buttons 
                // and the text box
                defaultArgBruteRange.setEnabled(true);                
                if(defaultArgBruteRange.isSelected()==false)
                {
                     customCharacterRange.setEnabled(true);
                }
                else
                {
                     customCharacterRange.setEnabled(false);
                }                              
                customArgBruteRange.setEnabled(true);
            }
            else
            {
                defaultArgBruteRange.setEnabled(false);
                customCharacterRange.setEnabled(false);
                customArgBruteRange.setEnabled(false);
            }
        }
        else
        {
            bruteArgInjections.setEnabled(false);
            fixedArguments.setEnabled(false);
            fixedArguments.setEnabled(false);            
            //doOnlyArgumentInjection.setEnabled(false);
            injectAdditionalArguments.setEnabled(false);
            injectHTTPCheckBox.setEnabled(false);
            injectSmbCheckBox.setEnabled(false);
            injectFileCheckBox.setEnabled(false);
            injectUncCheckBox.setEnabled(false);
            
            //injectCSwitchCheckBox.setEnabled(false);
            uncPathsCheckBox.setEnabled(false);            
            //hijackOutputNixCheckBox.setEnabled(false);
            //oOutputFlagHijackCheckBox.setEnabled(false);
            //findExecInjectCheckBox.setEnabled(false);    
            
            defaultArgBruteRange.setEnabled(false);
            customCharacterRange.setEnabled(false);
            customArgBruteRange.setEnabled(false);
            
            //maliciousCommandArgument.setEnabled(false);
        }        
    }//GEN-LAST:event_argInjectionCheckBoxActionPerformed

    private void manualModeCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_manualModeCheckBoxActionPerformed
        // TODO add your handling code here:
        if(manualModeCheckBox.isSelected())
        {            
            this.disableAuto();
        }
        else
        {
            this.enableAuto();
        }        
    }//GEN-LAST:event_manualModeCheckBoxActionPerformed

    private void verboseOutputCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_verboseOutputCheckBoxActionPerformed
        // TODO add your handling code here:
        if(verboseOutputCheckBox.isSelected())
        {
            this.verboseOutput=true;
            logOutput("Verbose mode enabled.");
        }
        else
        {
            this.verboseOutput=false;
            logOutput("Verbose mode disabled.");
        }
    }//GEN-LAST:event_verboseOutputCheckBoxActionPerformed

    private void stopAllRunningScansActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stopAllRunningScansActionPerformed
        // TODO add your handling code here:
        
    }//GEN-LAST:event_stopAllRunningScansActionPerformed

    private void flushTheTrackerButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_flushTheTrackerButtonActionPerformed
        // TODO add your handling code here:
        if(this.collabSessions.size()>0)
        {
            this.collabSessions.get(0).count=0;
        }
        this.collabSessions.clear();         
        this.flushThetracker();
        logOutput("Flushed all the collaborator sessions. All the tracking information of any collaborator sessions and payloads has been lost.");
    }//GEN-LAST:event_flushTheTrackerButtonActionPerformed

    private void checkForInteractionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_checkForInteractionsActionPerformed
        // TODO add your handling code here:
        this.checkCollabInteractions(true);
    }//GEN-LAST:event_checkForInteractionsActionPerformed

    private void fixedArgumentsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fixedArgumentsActionPerformed
        // TODO add your handling code here:
        if(fixedArguments.isSelected())
        {
            //injectCSwitchCheckBox.setEnabled(true);
            uncPathsCheckBox.setEnabled(true);            
            //hijackOutputNixCheckBox.setEnabled(true);
            //oOutputFlagHijackCheckBox.setEnabled(true);
            //findExecInjectCheckBox.setEnabled(true);
            //maliciousCommandArgument.setEnabled(true);
        }
        else
        {
            //injectCSwitchCheckBox.setEnabled(false);
            uncPathsCheckBox.setEnabled(false);            
            //hijackOutputNixCheckBox.setEnabled(false);
            //oOutputFlagHijackCheckBox.setEnabled(false);
            //findExecInjectCheckBox.setEnabled(false);            
            //maliciousCommandArgument.setEnabled(false);
        }
    }//GEN-LAST:event_fixedArgumentsActionPerformed
    private void argInjectArgumentsUI()
    {
        if(bruteArgInjections.isSelected()==false&&this.injectAdditionalArguments.isSelected()==false)
        {
            injectHTTPCheckBox.setEnabled(false);
            injectSmbCheckBox.setEnabled(false);
            injectFileCheckBox.setEnabled(false);
            injectUncCheckBox.setEnabled(false);
           // maliciousCommandArgument.setEnabled(false);
        }
        if(bruteArgInjections.isSelected()==true||this.injectAdditionalArguments.isSelected()==true)
        {
            injectHTTPCheckBox.setEnabled(true);
            injectSmbCheckBox.setEnabled(true);
            injectFileCheckBox.setEnabled(true);
            injectUncCheckBox.setEnabled(true);
           // maliciousCommandArgument.setEnabled(true);
        }
        if(bruteArgInjections.isSelected()==true)
        {
             customArgBruteRange.setEnabled(true);        
             defaultArgBruteRange.setEnabled(true);
             if(defaultArgBruteRange.isSelected()==false)
             {
                 customCharacterRange.setEnabled(true);
             }
             else
             {
                 customCharacterRange.setEnabled(false);
             }
             
        }
        else
        {
             customArgBruteRange.setEnabled(false);        
             defaultArgBruteRange.setEnabled(false);
             customCharacterRange.setEnabled(false);            
        }
    }
    private void injectAdditionalArgumentsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_injectAdditionalArgumentsActionPerformed
        // TODO add your handling code here:
        this.argInjectArgumentsUI();
    }//GEN-LAST:event_injectAdditionalArgumentsActionPerformed

    private void bruteArgInjectionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bruteArgInjectionsActionPerformed
        // TODO add your handling code here:
        this.argInjectArgumentsUI();
    }//GEN-LAST:event_bruteArgInjectionsActionPerformed

    private void injectHTTPCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_injectHTTPCheckBoxActionPerformed
        // TODO add your handling code here:        
        
    }//GEN-LAST:event_injectHTTPCheckBoxActionPerformed

    private void customArgBruteRangeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_customArgBruteRangeActionPerformed
        // TODO add your handling code here:
        if(customArgBruteRange.isSelected()==true)
        {
            defaultArgBruteRange.setSelected(false);
            customCharacterRange.setEnabled(true);
        }
        else
        {
            defaultArgBruteRange.setSelected(true);
            customCharacterRange.setEnabled(false);
        }
    }//GEN-LAST:event_customArgBruteRangeActionPerformed

    private void defaultArgBruteRangeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultArgBruteRangeActionPerformed
        // TODO add your handling code here:
         if(defaultArgBruteRange.isSelected()==true)
        {
            customArgBruteRange.setSelected(false);            
            customCharacterRange.setEnabled(false);
        }
        else
        {
            customArgBruteRange.setSelected(true);
            customCharacterRange.setEnabled(true);
        }
    }//GEN-LAST:event_defaultArgBruteRangeActionPerformed

    private void doTerminalInjectionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_doTerminalInjectionActionPerformed
        // TODO add your handling code here:
        /// http://www.example.com/%1b%5d%32%3b%6f%72%6e%65%65%07%0a
        if(doTerminalInjection.isSelected())
        {
            //onlyDoTerminalInjection.setEnabled(true);
        }
        else
        {
            //onlyDoTerminalInjection.setEnabled(false);
        }       
    }//GEN-LAST:event_doTerminalInjectionActionPerformed

    private void doCommandInjectionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_doCommandInjectionActionPerformed
        // TODO add your handling code here:
        if(doCommandInjection.isSelected()==true)
        {
            this.basePayloadCheckBox.setEnabled(true);
            this.secondBasePayloadCheckBox.setEnabled(true);
            this.thirdBasePayloadCheckBox.setEnabled(true);
            this.fourthBasePayloadCheckBox.setEnabled(true);
            this.fifthBasePayloadCheckBox.setEnabled(true);
            this.sixthBasePayloadCheckBox.setEnabled(true);
            this.seventhBasePayloadCheckBox.setEnabled(true);
            this.eightBasePayloadCheckBox.setEnabled(true);
        }
        else
        {
            this.basePayloadCheckBox.setEnabled(false);
            this.secondBasePayloadCheckBox.setEnabled(false);
            this.thirdBasePayloadCheckBox.setEnabled(false);
            this.fourthBasePayloadCheckBox.setEnabled(false);
            this.fifthBasePayloadCheckBox.setEnabled(false);
            this.sixthBasePayloadCheckBox.setEnabled(false);
            this.seventhBasePayloadCheckBox.setEnabled(false);
            this.eightBasePayloadCheckBox.setEnabled(false);
        }
    }//GEN-LAST:event_doCommandInjectionActionPerformed

    private void removeTerminatorButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeTerminatorButtonActionPerformed
        // TODO add your handling code here:
        if(terminatorList.getSelectedIndex()!=-1)
        {
            ArrayList<String> toRemove = new ArrayList<>();
            int indices[]=terminatorList.getSelectedIndices();
            for(int i=0;i<indices.length;i++)
            {
                toRemove.add((String)terminatorList.getModel().getElementAt(indices[i]));
            }
            for(int i=0;i<toRemove.size();i++)
            {
                removeFromListData(terminatorList,toRemove.get(i));
            }
        }
    }//GEN-LAST:event_removeTerminatorButtonActionPerformed

    private void addTerminatorButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addTerminatorButtonActionPerformed
        // TODO add your handling code here:
        String val = addTerminatorField.getText();
        if(editorFormat=="HEX")
        {
            val=val.replaceAll("[^\\da-f]","");

            // make sure the number of characters is even
            int len=val.length();
            if(len%2==0)
            {
                // add the string to the list
                String n[]={val};
                appendListData(terminatorList,n);
                addTerminatorField.setText("");
            }
        }
        else
        {
            String n[]={val};
            appendListData(terminatorList,n);
            addTerminatorField.setText("");
        }
    }//GEN-LAST:event_addTerminatorButtonActionPerformed

    private void terminatorASCIIFormatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_terminatorASCIIFormatActionPerformed

        if(editorFormat=="ASCII") return;

        terminatorHexFormat.setSelected(false);
        terminatorASCIIFormat.setSelected(true);

        editorFormat="ASCII";

        // now, we have to go through the list and convert each element
        //
        // also, in such case we want to make sure this toggle is only activated once
        // breakupList
        // iterate and convert from hex to ascii
        // convert all from ASCII to HEX

        ListModel terminatorListModel = terminatorList.getModel();
        String newValues[] = new String[terminatorListModel.getSize()];
        for(int i=0;i<terminatorListModel.getSize();i++)
        {
            String hex=terminatorListModel.getElementAt(i).toString();
            StringBuilder output = new StringBuilder();
            for (int j = 0; j < hex.length(); j+=2)
            {
                String str = hex.substring(j, j+2);
                output.append((char)Integer.parseInt(str, 16));
            }
            newValues[i]=output.toString();
            // now, we convert it from ASCII to HEX
            //brutDocrootSuffixes.add(suffix);
        }
        terminatorList.setListData(newValues);
        /*
        String hex;
        */
    }//GEN-LAST:event_terminatorASCIIFormatActionPerformed

    private void terminatorHexFormatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_terminatorHexFormatActionPerformed
        switchToHex();

    }//GEN-LAST:event_terminatorHexFormatActionPerformed

    private void includeLiteralWhitesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_includeLiteralWhitesActionPerformed
        // TODO add your handling code here:
        if(includeLiteralWhites.isSelected()==true)
        {
            smart400Avoidance.setEnabled(true);
        }
        else
        {
            smart400Avoidance.setEnabled(false);
        }
    }//GEN-LAST:event_includeLiteralWhitesActionPerformed
    protected void switchToHex()
    {
        if(editorFormat=="HEX") return;
        terminatorHexFormat.setSelected(true);
        terminatorASCIIFormat.setSelected(false);

        editorFormat="HEX";

        // convert all from ASCII to HEX
        ListModel terminatorListModel = terminatorList.getModel();
        String newValues[] = new String[terminatorListModel.getSize()];
        for(int i=0;i<terminatorListModel.getSize();i++)
        {
            String currval=terminatorListModel.getElementAt(i).toString();
            String newVal="";
            for(int j=0;j<currval.length();j++)
            {
                char currChar = currval.charAt(j);
                String hex = Integer.toHexString(currChar);
                newVal+=hex;
            }
            newValues[i]=newVal;
            // now, we convert it from ASCII to HEX
            //brutDocrootSuffixes.add(suffix);
        }
        terminatorList.setListData(newValues);        
    }
    private void disableAuto()
    {
        this.mode="manual";
        this.commandField.setEnabled(true);
        this.argumentField.setEnabled(true);
                
        this.payloadMarkingBox.setEnabled(true);
        this.feedbackChannelCombo.setEnabled(false);
        
        updatePayloadMarkingHolder();        
    }
    private void enableAuto()
    {
        this.mode="auto";
        this.commandField.setEnabled(false);
        this.argumentField.setEnabled(false);               
        this.feedbackChannelCombo.setSelectedIndex(0); // preferred, but not enforced setting
        
        this.payloadMarkingBox.setSelected(true);
        this.payloadMarkingBox.setEnabled(false);      // for all applicable feedback channels (currently only one supported)
        this.feedbackChannelCombo.setEnabled(true);
        
        updatePayloadMarkingHolder();
    }
    private void flushThetracker() // used to initiate and reset (if requested by the user manually) the session tracker
    {
        this.collabClient = SHELLING.callbacks.createBurpCollaboratorClientContext();
        this.collabSessions = new ArrayList<collabSession>(); // consider providing the ability to reset this object if needed - another way to achieve this will be to reload the plugin        
    }
    public void checkCollabInteractions(boolean manual)
    {
        // don't run this more often than once in 30 seconds
        long currentTimestamp = System.currentTimeMillis();        
        if(manual==false)
        {            
            // from seconds to miliseconds
            long limit = 1000*this.collabSessionCheckThreshold; 
            long delta = currentTimestamp-this.lastCollabSessionCheck;
            // check if last checkCollabInteractions() happened within last than 30 seconds
            if(delta<limit) 
            {
                logDebug("Supressing a checkCollabInteractions() call (last check was done ");
                return;
            }
        }
        this.lastCollabSessionCheck=currentTimestamp; // we pass and we update the last session check
        //logOutput("\n[+] Collaborator interaction check [this check runs even if the current mode is manual].");
        logOutput("[+] The number of tracked collab sessions is right now "+this.collabSessions.size()); // let's leave this information out there all the time, even if verbose == false
        // only DNS interactions are supported at the moment
        // now, we decided to generate a unique burp collaborator ID per attack (this is simpler than an additional level of encapsulation in the payload itself, which is already way too long)
        // hence, we are going to fetch for all the interactions every time, one after another
        List<IScanIssue> report = null;
        List<IBurpCollaboratorInteraction> collabInter=null;
        Iterator<IBurpCollaboratorInteraction> collabInterItr;
        
        collabInter = this.collabClient.fetchAllCollaboratorInteractions();
        
        Map<String, ArrayList> validPayloads = new HashMap<String, ArrayList>();
                
        // validPayloads.get("collabId.burpcollaborator.net").add(";nslookup$IFS$9a23.collabId.burpcollaborator.net;"); // this is the expected result        

        // now we just iterate over all the interactions - and then search through our collabSessions
        if(collabInter.size()>0) 
        {                 
            //if interaction(s) were found from the current poll request, add all to overall list and continue
            collabInterItr = collabInter.iterator();
                
            report = new ArrayList<IScanIssue>();	
               
            IBurpCollaboratorInteraction inter;
            // OK, now we read all of them
            while(collabInterItr.hasNext())
            {            
                inter = collabInterItr.next();
                if(inter.getProperty("raw_query")==null) continue; // at this point we ingore all other interactions as DNS is the only one we are interested in
                // This method is used to retrieve a property of the interaction. 
                // Properties of all interactions are: interaction_id, type, client_ip, and time_stamp. 
                // Properties of DNS interactions are: query_type and raw_query. The raw_query value is Base64-encoded. 
                // Properties of HTTP interactions are: protocol, request, and response. 
              
                // The request and response values are Base64-encoded
                logDebug("[+] Received a Collaborator interaction.");
                                
                // fuck, we're gonna have to match against the loc ourselves, it cannot be directly retrieved from the iterator!
                
                byte[] collabQuery = SHELLING.callbacks.getHelpers().base64Decode(inter.getProperty("raw_query"));
            
                // NOW, WHAT FOLLOWS IS THE UGLIEST SCULPTURE I HAVE EVER CODED:           
                // logOutput("[+] Raw query (base 64): "+inter.getProperty("raw_query"));
            
                String rawS = SHELLING.callbacks.getHelpers().bytesToString(collabQuery);
                logDebug("[+] Raw query (clear): "+rawS);
                byte[] trimed = new byte[collabQuery.length-16];
                for(int i=13;i<collabQuery.length-3;i++)
                {
                    trimed[i-13]=collabQuery[i];
                }
                String collabQueryS = SHELLING.callbacks.getHelpers().bytesToString(trimed);
                logDebug("[+] Trimed query: "+collabQueryS);   
                byte[] t = new byte[1];
                t[0]=(byte)0x1e; // Record Separator            
                String parts[] = collabQueryS.trim().split(SHELLING.callbacks.getHelpers().bytesToString(t));
                            
                    
                if(parts.length>1) // if there was a record (subdomain) in the hostname - which suggests the payload comes from our payload marking mechanisms, as I have not seen anyone else using this feature this way
                {
                    String payloadIndexS="0";
                    String pLoc="";
                    payloadIndexS=parts[0];                               
                    pLoc=parts[1];                    
                    String collabLocID = parts[1].substring(0,30);
                    
                    logDebug("[+] Payload index:"+payloadIndexS);
                    logDebug("[+] Collab location:"+collabLocID);
                                                            
                    if(payloadIndexS.startsWith("a")) payloadIndexS = payloadIndexS.replace("a",""); // we use markers starting with "a" when $IFS$9 is used
                    // we use $IFS$9 because we need to separate the IFS variable name from an argument
                    // otherwise ping$IFSlocalhost would not work ($IFSlocalhost would be taken as a bash variable)
                    // so we use $9 to separate $IFS from the argument, but for the same exact reason an argument starting with a digit (like a marked domain name, e.g. 4.<collabLoc>.burpcollaborator.net) would fail as well
                    // so we have to prepend the marker with an alphanumeric character ("a" was a good candidate) to solve the same problem

                    logDebug("[+] Searching for "+collabLocID+" in our sessions (iterating overall the whole set, starting with the most recent one)...");
                    
                    // we NEED to have a HashMap<collabID> with payloads that have worked for each single separate collabID
                    // there is no way to guarantee the order of the events coming
                    // and don't want to miss any if more are avaiable
                    // while not issuing duplicates either
                    
                    // so, we need to collect the feedback (the list of valid payloads) for every single recognized collabId separately, into a separate bucket
                    // and once all the collab interactions are processed, we pop the aggregated results by calling addScanIssue().
                    
                    boolean found=false;
                    ArrayList<String> payloads = new ArrayList<>(); // 
                    for(int i=this.collabSessions.size()-1;i>-1;i--)
                    {
                        logDebug("[+] Checking "+this.collabSessions.get(i).collabLoc+"...");
                        if(this.collabSessions.get(i).collabLoc.startsWith(collabLocID)) // match found!
                        {
                            found=true;
                            logDebug("[+] MATCH! We have a finding, sir!");                            
                            logDebug("[+] Payload was generated at "+this.collabSessions.get(i).getCreated()+" to feed the "+this.collabSessions.get(i).action);                            
                            /// we can also extract the payload if full payload tracking is on
                            // now, gather all the information required to pop this issue up using callbacks.addScanIssue()
                            int payloadIndex  = Integer.parseInt(payloadIndexS); 
                            payloadIndex-=1;    // payload marker was using arrays starting at 1... "I don't have strong opinions on anything" hehe
                            if(validPayloads.get(collabLocID)==null) // first entry, we have to create the object
                            {
                                logDebug("[+] Saved the interaction into a new bucket created for "+collabLocID+".");                            
                                ArrayList<String> arr = new ArrayList<String>(); 
                                // we are getting a null pointer here (getShellingsRaw(), because... well, this thing is filled AFTER the first exhaustion of all its payloads
                                // soo, if it's null, it means the payloads come from the current generator...
                                // so that last generator pointer was kinda useful 
                                // how about a pointer to the last payload set instead?
                                
                                // right, we have payloads for generatePayloads... not the same thing uh
                                if(this.collabSessions.get(i).getShellingsRaw()==null)
                                { // current payloads have not been propagated yet, the session is still ongoing
                                    // try to use curr_generator payloads instead                                    
                                    arr.add(this.curr_generator.shellings.get(payloadIndex));  
                                }
                                else
                                {
                                    arr.add(this.collabSessions.get(i).getShellingsRaw().get(payloadIndex));    
                                }                                                                                                    
                                validPayloads.put(collabLocID,arr);
                            }
                            else
                            {
                                if(this.collabSessions.get(i).getShellingsRaw()==null)
                                {
                                    validPayloads.get(collabLocID).add(this.curr_generator.shellings.get(payloadIndex));
                                }
                                else
                                {
                                    validPayloads.get(collabLocID).add(this.collabSessions.get(i).getShellingsRaw().get(payloadIndex));                                                                        
                                }
                                logDebug("[+] Added the interaction into an already existing bucket for "+collabLocID+".");                            
                            }
                            
                        }
                    }                  
                    if(!found) 
                    {
                        logDebug("[+] Could not match this interaction with any registered Collaborator session... Maybe the plugin was reloaded since the scan was initiated? Inspect manually.");                    
                        // in this case we also need to pop up a finding, this is too important to miss (again, an "unknown/unexpected collaborator interaction).
                    }
                    
                }                                                    
                else // no valid payload mark was spotted in the queried domain name
                {
                    // OK, at this point we are also getting here lookups that do NOT contain subdomains but are definitely matching
                    // we have to detect them (parse out the domain and match it with the sessions loc list) and silently ignore them if this is a pattern (dummy collaborator event)
                    for(int i=0;i<this.collabSessions.size();i++)
                    {
                        if(collabQueryS==this.collabSessions.get(i).collabLoc)
                        {
                            logDebug("Seems like a dummy session for "+collabQueryS+", this warning will be supressed in the future if proven to only accompany actual finding events (lookups with the correct payload mark) that are reported and recognized.");   
                            // this should, however, only be supressed if we already hit issues for this particular collabLoc (just create an array of strings and push the locs if issues were raised or sth)
                            //
                        }
                        else
                        {
                            logDebug("Query not recognized as originating from SHELLING! Please investigate manually.\n"); // these, in turn, should be used to create a separate scanner issue - just to avoid staying unnoticed (hey, we received some weird collaborator event)
                        }
                    }
                    
                }            
            }
            
            for (String key : validPayloads.keySet()) 
            {
                ArrayList<String> payloads = validPayloads.get(key);                
                if(payloads.size()==0)
                {
                    logOutput("[+] ERROR: An empty payload bucket encountered for "+key+"! This should never happen!");
                }
                else
                {
                    boolean found=false;
                    for(int i=0;i<this.collabSessions.size();i++)
                    {                        
                        logOutput("Comparing "+key+" with "+this.collabSessions.get(i).collabLoc+".");                
                        if(key.equals(this.collabSessions.get(i).collabLoc))
                        {
                            found=true;
                            // grab the details (collabLocId, created at, reported at at (current time)
                            logDebug("[+] The "+key+" payload bucket has been found, a new Scanner issue incoming!");
                            String details = "A potential OS command injection was detected using DNS as the feedback channel.<br>";
                            details+="This finding was captured from a collabortor DNS interaction (session "+key+") initiated at <b>"+  this.collabSessions.get(i).getCreated()+"</b> for the following tool: <b>"+this.collabSessions.get(i).action+"</b>.<br><br>";
                        
                            // we can actually try to attempt to use current generator to establish this, if possible
                            // interactinos caught later will not have the insertion point identified unless we start tracking that somehow too, without killing the memory
                            // assemble all the payloads into one description
                            String payloadsList="The following payloads have successfully penetrated the input:<ul>";
                            for(int j=0;j<payloads.size();j++)
                            {
                                payloadsList+="<li>"+payloads.get(j)+"</li>"; // we should find a more optimum way, like a join("\n")                            
                                // also, might be a good idea to ship the payload index too - payloads with white/non-printable literals might be hard to identify
                            }
                            details+=payloadsList+"</ul><br><br>";
                            details+="Insertion point name: <b>"+this.collabSessions.get(i).insertionPointName+"</b><br>";
                            if(this.collabSessions.get(i).baseReqRes==null)
                            {
                                details+="Please keep in mind this tracking session was created for a payload export session, hence Burp is not able to provide the vulnerable request, as it came from an external client instead of Scanner/Intruder.<br>";
                            }
                            else
                            {                                                                                            
                                details+="Please keep in mind that the provided HTTP request is the BASE request (the one sent to Scanner/Intruder), NOT the actually vulnerable request (the memory/performance cost of asynchronous issue tracking).<br>";                                                                
                            }
                            // grab the baseReqResp
                            logDebug("[+] Adding a new Scan Issue, baby!");
                            SHELLING.callbacks.addScanIssue(new BinaryPayloadIssue(SHELLING.callbacks,this.collabSessions.get(i).baseReqRes,details,"DNS"));                                                
                            // add it
                            break; // from this loop
                        }
                    }
                    if(!found) logOutput("[+] ERROR! Weird, no matching sessions were found for "+key+"... This should never happen.");    
                }
                
            }                       
        }               
    } // end of the method
    
    protected int collabSessionID(String collabLocation)
    {        
        for(int i=this.collabSessions.size()-1;i>-1;i--)
        {
            if(this.collabSessions.get(i).collabLoc==collabLocation)
            {
                return i;
            }
        }
        return -1;
    }
    public void logOutput(String msg)
    {
        //this.logOutput.append(msg);
        stdout.println(msg);
    }
    public void logDebug(String msg) // only called when verboseOutput == true
    {
        if(this.verboseOutput==true)
        {
            logOutput(msg);
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addTerminatorButton;
    private javax.swing.JTextField addTerminatorField;
    private javax.swing.JPanel advancedPanel;
    protected javax.swing.JLabel advancedPayloadLabel;
    protected javax.swing.JCheckBox argInjectionCheckBox;
    protected javax.swing.JTextField argumentField;
    protected javax.swing.JCheckBox basePayloadCheckBox;
    protected javax.swing.JCheckBox bruteArgInjections;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.ButtonGroup buttonGroup2;
    protected javax.swing.JComboBox<String> byteGeneratorRangeCombo;
    private javax.swing.JButton checkForInteractions;
    protected javax.swing.JTextField commandField;
    protected javax.swing.JRadioButton customArgBruteRange;
    protected javax.swing.JTextField customCharacterRange;
    protected javax.swing.JRadioButton defaultArgBruteRange;
    private javax.swing.JSpinner delayTimeSpinner;
    protected javax.swing.JCheckBox doCommandInjection;
    protected javax.swing.JCheckBox doTerminalInjection;
    protected javax.swing.JCheckBox eightBasePayloadCheckBox;
    protected javax.swing.JList<String> encodeList;
    private javax.swing.JComboBox<String> encodingsToUse;
    protected javax.swing.JComboBox<String> feedbackChannelCombo;
    protected javax.swing.JCheckBox fifthBasePayloadCheckBox;
    protected javax.swing.JCheckBox fixedArguments;
    private javax.swing.JButton flushTheTrackerButton;
    protected javax.swing.JCheckBox fourthBasePayloadCheckBox;
    public javax.swing.JCheckBox includeLiteralWhites;
    public javax.swing.JCheckBox includeThePooComboBox;
    protected javax.swing.JCheckBox injectAdditionalArguments;
    protected javax.swing.JCheckBox injectFileCheckBox;
    protected javax.swing.JCheckBox injectHTTPCheckBox;
    protected javax.swing.JCheckBox injectSmbCheckBox;
    protected javax.swing.JCheckBox injectUncCheckBox;
    private javax.swing.JButton jButton4;
    private javax.swing.JCheckBox jCheckBox5;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane3;
    protected javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JCheckBox manualModeCheckBox;
    protected javax.swing.JCheckBox osSpecificTerminators;
    private java.awt.Panel panel1;
    public javax.swing.JCheckBox payloadMarkingBox;
    private javax.swing.JButton removeEncoding;
    private javax.swing.JButton removeTerminatorButton;
    private javax.swing.JButton saveToClipBoardButton;
    private javax.swing.JButton saveToFileButton;
    protected javax.swing.JCheckBox scannerChecksBox;
    protected javax.swing.JCheckBox secondBasePayloadCheckBox;
    protected javax.swing.JCheckBox seventhBasePayloadCheckBox;
    protected javax.swing.JCheckBox sixthBasePayloadCheckBox;
    public javax.swing.JCheckBox smart400Avoidance;
    public javax.swing.JCheckBox stopAllRunningScans;
    protected javax.swing.JComboBox<String> targetOSCombo;
    protected javax.swing.JRadioButton terminatorASCIIFormat;
    protected javax.swing.JRadioButton terminatorHexFormat;
    protected javax.swing.JList<String> terminatorList;
    protected javax.swing.JCheckBox thirdBasePayloadCheckBox;
    protected javax.swing.JCheckBox uncPathsCheckBox;
    protected javax.swing.JCheckBox useNullByte;
    protected javax.swing.JCheckBox useTerminatorsCheckBox;
    private javax.swing.JCheckBox verboseOutputCheckBox;
    // End of variables declaration//GEN-END:variables
}
