/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer.util;

import org.apache.commons.math3.util.FastMath;

public final class MercatorUtils {
    private MercatorUtils() {
    }

    public static int longToX(double longitudeDegrees, double radius) {
        double longitude = FastMath.toRadians((double)longitudeDegrees);
        return (int)(radius * longitude);
    }

    public static int latToY(double latitudeDegrees, double radius) {
        double latitude = FastMath.toRadians((double)latitudeDegrees);
        double y = radius / 2.0 * FastMath.log((double)((1.0 + FastMath.sin((double)latitude)) / (1.0 - FastMath.sin((double)latitude))));
        return (int)y;
    }

    public static double xToLong(int x, double radius) {
        double longRadians = (double)x / radius;
        double longDegrees = FastMath.toDegrees((double)longRadians);
        int rotations = (int)FastMath.floor((double)((longDegrees + 180.0) / 360.0));
        double longitude = longDegrees - (double)(rotations * 360);
        return longitude;
    }

    public static double yToLat(int y, double radius) {
        double latitude = 1.5707963267948966 - 2.0 * FastMath.atan((double)FastMath.exp((double)(-1.0 * (double)y / radius)));
        return FastMath.toDegrees((double)latitude);
    }
}

