/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer.esri;

import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.jdesktop.swingx.mapviewer.DefaultTileFactory;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.jdesktop.swingx.mapviewer.util.GeoUtil;

public class ESRITileFactory
extends DefaultTileFactory {
    private static final String projection = "8";
    private static final String format = "png";
    private String userId;
    private String datasource;

    public ESRITileFactory() {
        super(new ESRITileProviderInfo());
        ((ESRITileProviderInfo)super.getInfo()).factory = this;
        this.datasource = "ArcWeb:TA.Streets.NA";
    }

    public void setUserID(String id) {
        this.userId = id;
    }

    private static final class ESRITileProviderInfo
    extends TileFactoryInfo {
        private ESRITileFactory factory;

        private ESRITileProviderInfo() {
            super(0, 17, 18, 256, false, true, "http://www.arcwebservices.com/services/v2006/restmap?actn=getMap", "", "", "");
        }

        @Override
        public String getTileUrl(int x, int y, int zoom) {
            int tileY = y;
            int tileX = x;
            int pixelX = tileX * this.factory.getTileSize(zoom) + this.factory.getTileSize(zoom) / 2;
            int pixelY = tileY * this.factory.getTileSize(zoom) + this.factory.getTileSize(zoom) / 2;
            GeoPosition latlong = GeoUtil.getPosition(new Point2D.Double(pixelX, pixelY), zoom, this);
            double numFeetPerDegreeLong = 364610.6933333333;
            double numPixelsPerDegreeLong = this.getLongitudeDegreeWidthInPixels(zoom);
            double numPixelsPerFoot = 1152.0;
            int sf = (int)(numFeetPerDegreeLong / (numPixelsPerDegreeLong / numPixelsPerFoot));
            BigDecimal lat = new BigDecimal(latlong.getLatitude());
            BigDecimal lon = new BigDecimal(latlong.getLongitude());
            lat = lat.setScale(5, RoundingMode.DOWN);
            lon = lon.setScale(5, RoundingMode.DOWN);
            System.out.println("Tile      : [" + tileX + ", " + tileY + "]");
            System.out.println("Pixel     : [" + pixelX + ", " + pixelY + "]");
            System.out.println("Lat/Long  : [" + latlong.getLatitude() + ", " + latlong.getLongitude() + "]");
            System.out.println("Lat2/Long2: [" + lat.doubleValue() + ", " + lon.doubleValue() + "]");
            String url = this.baseURL + "&usrid=" + this.factory.userId + "&ds=" + this.factory.datasource + "&c=" + lon.doubleValue() + "%7C" + lat.doubleValue() + "&sf=" + sf + "&fmt=png&ocs=8";
            System.out.println("the URL: " + url);
            return url;
        }
    }
}

