/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector.calibrate.oscillator;

import io.github.dsheirer.dsp.oscillator.IRealOscillator;
import io.github.dsheirer.dsp.oscillator.ScalarRealOscillator;
import io.github.dsheirer.dsp.oscillator.VectorRealOscillator;
import io.github.dsheirer.vector.calibrate.Calibration;
import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class RealOscillatorCalibration
extends Calibration {
    private static final double FREQUENCY = 5.0;
    private static final double SAMPLE_RATE = 100.0;
    private static final int BUFFER_SIZE = 2048;
    private static final int ITERATION_DURATION_MS = 1000;
    private static final int WARMUP_ITERATIONS = 5;
    private static final int TEST_ITERATIONS = 5;
    private IRealOscillator mScalar = new ScalarRealOscillator(5.0, 100.0);
    private IRealOscillator mVector = new VectorRealOscillator(5.0, 100.0);

    public RealOscillatorCalibration() {
        super(CalibrationType.OSCILLATOR_REAL);
    }

    @Override
    public void calibrate() throws CalibrationException {
        long score;
        int x;
        Mean scalarMean = new Mean();
        for (int x2 = 0; x2 < 5; ++x2) {
            long score2 = this.testScalar();
            scalarMean.increment((double)score2);
        }
        mLog.info("REAL OSCILLATOR WARMUP - SCALAR:" + DECIMAL_FORMAT.format(scalarMean.getResult()));
        Mean vectorMean = new Mean();
        for (x = 0; x < 5; ++x) {
            score = this.testVector();
            vectorMean.increment((double)score);
        }
        mLog.info("REAL OSCILLATOR WARMUP - VECTOR:" + DECIMAL_FORMAT.format(vectorMean.getResult()));
        scalarMean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testScalar();
            scalarMean.increment((double)score);
        }
        mLog.info("REAL OSCILLATOR - SCALAR:" + DECIMAL_FORMAT.format(scalarMean.getResult()));
        vectorMean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testVector();
            vectorMean.increment((double)score);
        }
        mLog.info("REAL OSCILLATOR - VECTOR:" + DECIMAL_FORMAT.format(vectorMean.getResult()));
        if (scalarMean.getResult() > vectorMean.getResult()) {
            this.setImplementation(Implementation.SCALAR);
        } else {
            this.setImplementation(Implementation.VECTOR_SIMD_PREFERRED);
        }
        mLog.info("REAL OSCILLATOR - SET OPTIMAL IMPLEMENTATION TO:" + String.valueOf((Object)this.getImplementation()));
    }

    private long testScalar() {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] generated = this.mScalar.generate(2048);
            accumulator += (double)generated[1];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector() {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] generated = this.mVector.generate(2048);
            accumulator += (double)generated[1];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }
}

