/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector.calibrate.gain;

import io.github.dsheirer.dsp.gain.complex.ComplexGain;
import io.github.dsheirer.dsp.gain.complex.ScalarComplexGain;
import io.github.dsheirer.dsp.gain.complex.VectorComplexGain;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.vector.calibrate.Calibration;
import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class ComplexGainCalibration
extends Calibration {
    private static final int BUFFER_SIZE = 2048;
    private static final int ITERATION_DURATION_MS = 1000;
    private static final int WARMUP_ITERATIONS = 5;
    private static final int TEST_ITERATIONS = 5;
    private static final float GAIN = 0.99f;

    public ComplexGainCalibration() {
        super(CalibrationType.GAIN_COMPLEX);
    }

    @Override
    public void calibrate() throws CalibrationException {
        long score;
        int x;
        float[] i = this.getFloatSamples(2048);
        float[] q = this.getFloatSamples(2048);
        Mean scalarMean = new Mean();
        for (int x2 = 0; x2 < 5; ++x2) {
            long score2 = this.testScalar(i, q);
            scalarMean.increment((double)score2);
        }
        mLog.info("COMPLEX GAIN WARMUP - SCALAR:" + DECIMAL_FORMAT.format(scalarMean.getResult()));
        i = this.getFloatSamples(2048);
        q = this.getFloatSamples(2048);
        Mean vectorMean = new Mean();
        for (x = 0; x < 5; ++x) {
            score = this.testVector(i, q);
            vectorMean.increment((double)score);
        }
        mLog.info("COMPLEX GAIN WARMUP - VECTOR:" + DECIMAL_FORMAT.format(vectorMean.getResult()));
        i = this.getFloatSamples(2048);
        q = this.getFloatSamples(2048);
        scalarMean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testScalar(i, q);
            scalarMean.increment((double)score);
        }
        mLog.info("COMPLEX GAIN - SCALAR:" + DECIMAL_FORMAT.format(scalarMean.getResult()));
        i = this.getFloatSamples(2048);
        q = this.getFloatSamples(2048);
        vectorMean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testVector(i, q);
            vectorMean.increment((double)score);
        }
        mLog.info("COMPLEX GAIN - VECTOR:" + DECIMAL_FORMAT.format(vectorMean.getResult()));
        if (scalarMean.getResult() > vectorMean.getResult()) {
            this.setImplementation(Implementation.SCALAR);
        } else {
            this.setImplementation(Implementation.VECTOR_SIMD_PREFERRED);
        }
        mLog.info("COMPLEX GAIN - SET IMPLEMENTATION TO:" + String.valueOf((Object)this.getImplementation()));
    }

    private long testScalar(float[] i, float[] q) {
        float accumulator = 0.0f;
        long count = 0L;
        ScalarComplexGain scalar = new ScalarComplexGain(0.99f);
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            ComplexSamples amplified = ((ComplexGain)scalar).apply(i, q, start);
            accumulator += amplified.i()[2];
            ++count;
        }
        return count + (long)(accumulator * 0.0f);
    }

    private long testVector(float[] i, float[] q) {
        float accumulator = 0.0f;
        long count = 0L;
        VectorComplexGain scalar = new VectorComplexGain(0.99f);
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            ComplexSamples amplified = ((ComplexGain)scalar).apply(i, q, start);
            accumulator += amplified.i()[2];
            ++count;
        }
        return count + (long)(accumulator * 0.0f);
    }
}

