/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector.calibrate.airspy;

import io.github.dsheirer.buffer.airspy.AirspyInterleavedBufferIteratorScalar;
import io.github.dsheirer.buffer.airspy.AirspyInterleavedBufferIteratorVector128Bits;
import io.github.dsheirer.buffer.airspy.AirspyInterleavedBufferIteratorVector256Bits;
import io.github.dsheirer.buffer.airspy.AirspyInterleavedBufferIteratorVector512Bits;
import io.github.dsheirer.buffer.airspy.AirspyInterleavedBufferIteratorVector64Bits;
import io.github.dsheirer.vector.calibrate.Calibration;
import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import jdk.incubator.vector.FloatVector;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class AirspyUnpackedInterleavedCalibration
extends Calibration {
    private static final int BUFFER_SIZE = 131072;
    private static final int ITERATION_DURATION_MS = 1000;
    private static final int WARMUP_ITERATIONS = 5;
    private static final int TEST_ITERATIONS = 5;

    public AirspyUnpackedInterleavedCalibration() {
        super(CalibrationType.AIRSPY_UNPACKED_INTERLEAVED_ITERATOR);
    }

    @Override
    public void calibrate() throws CalibrationException {
        short[] samples = this.getShortSamples(131072);
        short[] residualI = this.getShortSamples(11);
        short[] residualQ = this.getShortSamples(23);
        mLog.info("AIRSPY UNPACKED INTERLEAVED - VECTOR SIMD LANES PREFERRED: " + FloatVector.SPECIES_PREFERRED.length());
        Mean scalarMean = new Mean();
        for (int x = 0; x < 5; ++x) {
            long score = this.calibrateScalar(samples, residualI, residualQ);
            scalarMean.increment((double)score);
        }
        mLog.info("AIRSPY UNPACKED INTERLEAVED WARMUP - SCALAR: " + DECIMAL_FORMAT.format(scalarMean.getResult()));
        switch (FloatVector.SPECIES_PREFERRED.length()) {
            case 16: {
                long score;
                Mean vectorMean = new Mean();
                for (int x = 0; x < 5; ++x) {
                    score = this.calibrateVector512(samples, residualI, residualQ);
                    vectorMean.increment((double)score);
                }
                mLog.info("AIRSPY UNPACKED INTERLEAVED WARMUP - VECTOR 512: " + DECIMAL_FORMAT.format(vectorMean.getResult()));
            }
            case 8: {
                long score;
                Mean vectorMean = new Mean();
                for (int x = 0; x < 5; ++x) {
                    score = this.calibrateVector256(samples, residualI, residualQ);
                    vectorMean.increment((double)score);
                }
                mLog.info("AIRSPY UNPACKED INTERLEAVED WARMUP - VECTOR 256: " + DECIMAL_FORMAT.format(vectorMean.getResult()));
            }
            case 4: {
                long score;
                Mean vectorMean = new Mean();
                for (int x = 0; x < 5; ++x) {
                    score = this.calibrateVector128(samples, residualI, residualQ);
                    vectorMean.increment((double)score);
                }
                mLog.info("AIRSPY UNPACKED INTERLEAVED WARMUP - VECTOR 128: " + DECIMAL_FORMAT.format(vectorMean.getResult()));
            }
            case 2: {
                long score;
                Mean vectorMean = new Mean();
                for (int x = 0; x < 5; ++x) {
                    score = this.calibrateVector64(samples, residualI, residualQ);
                    vectorMean.increment((double)score);
                }
                mLog.info("AIRSPY UNPACKED INTERLEAVED WARMUP - VECTOR 64: " + DECIMAL_FORMAT.format(vectorMean.getResult()));
                scalarMean.clear();
                for (int x = 0; x < 5; ++x) {
                    long score2 = this.calibrateScalar(samples, residualI, residualQ);
                    scalarMean.increment((double)score2);
                }
                double bestScore = scalarMean.getResult();
                this.setImplementation(Implementation.SCALAR);
                mLog.info("AIRSPY UNPACKED INTERLEAVED - SCALAR: " + DECIMAL_FORMAT.format(scalarMean.getResult()));
                switch (FloatVector.SPECIES_PREFERRED.length()) {
                    case 16: {
                        long score3;
                        int x;
                        Mean vectorMean2 = new Mean();
                        for (x = 0; x < 5; ++x) {
                            score3 = this.calibrateVector512(samples, residualI, residualQ);
                            vectorMean2.increment((double)score3);
                        }
                        if (vectorMean2.getResult() > bestScore) {
                            bestScore = vectorMean2.getResult();
                            this.setImplementation(Implementation.VECTOR_SIMD_512);
                        }
                        mLog.info("AIRSPY UNPACKED INTERLEAVED - VECTOR 512: " + DECIMAL_FORMAT.format(vectorMean2.getResult()));
                    }
                    case 8: {
                        long score3;
                        int x;
                        Mean vectorMean3 = new Mean();
                        for (x = 0; x < 5; ++x) {
                            score3 = this.calibrateVector256(samples, residualI, residualQ);
                            vectorMean3.increment((double)score3);
                        }
                        if (vectorMean3.getResult() > bestScore) {
                            bestScore = vectorMean3.getResult();
                            this.setImplementation(Implementation.VECTOR_SIMD_256);
                        }
                        mLog.info("AIRSPY UNPACKED INTERLEAVED - VECTOR 256: " + DECIMAL_FORMAT.format(vectorMean3.getResult()));
                    }
                    case 4: {
                        long score3;
                        int x;
                        Mean vectorMean4 = new Mean();
                        for (x = 0; x < 5; ++x) {
                            score3 = this.calibrateVector128(samples, residualI, residualQ);
                            vectorMean4.increment((double)score3);
                        }
                        if (vectorMean4.getResult() > bestScore) {
                            bestScore = vectorMean4.getResult();
                            this.setImplementation(Implementation.VECTOR_SIMD_128);
                        }
                        mLog.info("AIRSPY UNPACKED INTERLEAVED - VECTOR 128: " + DECIMAL_FORMAT.format(vectorMean4.getResult()));
                    }
                    case 2: {
                        long score3;
                        int x;
                        Mean vectorMean5 = new Mean();
                        for (x = 0; x < 5; ++x) {
                            score3 = this.calibrateVector64(samples, residualI, residualQ);
                            vectorMean5.increment((double)score3);
                        }
                        if (vectorMean5.getResult() > bestScore) {
                            this.setImplementation(Implementation.VECTOR_SIMD_64);
                        }
                        mLog.info("AIRSPY UNPACKED INTERLEAVED - VECTOR 64: " + DECIMAL_FORMAT.format(vectorMean5.getResult()));
                    }
                }
            }
        }
        mLog.info("AIRSPY UNPACKED INTERLEAVED - SET OPTIMAL IMPLEMENTATION TO: " + String.valueOf((Object)this.getImplementation()));
    }

    private long calibrateScalar(short[] samples, short[] residualI, short[] residualQ) {
        long start = System.currentTimeMillis();
        long accumulator = 0L;
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            AirspyInterleavedBufferIteratorScalar iterator = new AirspyInterleavedBufferIteratorScalar(samples, residualI, residualQ, 0.0f, System.currentTimeMillis(), 0.0f);
            while (iterator.hasNext() && System.currentTimeMillis() - start < 1000L) {
                accumulator = (long)((float)accumulator + iterator.next().samples()[2]);
                ++count;
            }
        }
        return count + accumulator * 0L;
    }

    private long calibrateVector64(short[] samples, short[] residualI, short[] residualQ) {
        long start = System.currentTimeMillis();
        long accumulator = 0L;
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            AirspyInterleavedBufferIteratorVector64Bits iterator = new AirspyInterleavedBufferIteratorVector64Bits(samples, residualI, residualQ, 0.0f, System.currentTimeMillis(), 0.0f);
            while (iterator.hasNext() && System.currentTimeMillis() - start < 1000L) {
                accumulator = (long)((float)accumulator + iterator.next().samples()[2]);
                ++count;
            }
        }
        return count + accumulator * 0L;
    }

    private long calibrateVector128(short[] samples, short[] residualI, short[] residualQ) {
        long start = System.currentTimeMillis();
        long accumulator = 0L;
        long count = 0L;
        for (int x = 0; x < 1000; ++x) {
            AirspyInterleavedBufferIteratorVector128Bits iterator = new AirspyInterleavedBufferIteratorVector128Bits(samples, residualI, residualQ, 0.0f, System.currentTimeMillis(), 0.0f);
            while (iterator.hasNext() && System.currentTimeMillis() - start < 1000L) {
                accumulator = (long)((float)accumulator + iterator.next().samples()[2]);
                ++count;
            }
        }
        return count + accumulator * 0L;
    }

    private long calibrateVector256(short[] samples, short[] residualI, short[] residualQ) {
        long start = System.currentTimeMillis();
        long accumulator = 0L;
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            AirspyInterleavedBufferIteratorVector256Bits iterator = new AirspyInterleavedBufferIteratorVector256Bits(samples, residualI, residualQ, 0.0f, System.currentTimeMillis(), 0.0f);
            while (iterator.hasNext() && System.currentTimeMillis() - start < 1000L) {
                accumulator = (long)((float)accumulator + iterator.next().samples()[2]);
                ++count;
            }
        }
        return count + accumulator * 0L;
    }

    private long calibrateVector512(short[] samples, short[] residualI, short[] residualQ) {
        long start = System.currentTimeMillis();
        long accumulator = 0L;
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            AirspyInterleavedBufferIteratorVector512Bits iterator = new AirspyInterleavedBufferIteratorVector512Bits(samples, residualI, residualQ, 0.0f, System.currentTimeMillis(), 0.0f);
            while (iterator.hasNext() && System.currentTimeMillis() - start < 1000L) {
                accumulator = (long)((float)accumulator + iterator.next().samples()[2]);
                ++count;
            }
        }
        return count + accumulator * 0L;
    }
}

